// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Data;

namespace TERASOLUNA.Fw.Client.Communication
{
    /// <summary>
    /// XMLf[^̑MAt@C̎Ms <see cref="CommunicatorBase{DataSet}"/> hNXłB
    /// </summary>
    /// <remarks>
    /// <para>
    /// ̓f[^ <see cref="DataSet"/> XMLɕϊăT[o֑MA
    /// Mt@C[Jɕۑ܂B
    /// </para>
    /// <para>
    /// ̃NX𗘗pă_E[hsꍇA
    /// <see cref="CommunicatorBase{DataSet}.Communicate"/> ł͂Ȃ
    /// <see cref="BinaryFileDownloadCommunicator.Download"/> gp܂B
    /// </para>
    /// </remarks>
    public class BinaryFileDownloadCommunicator : CommunicatorBase<DataSet>
    {
        /// <summary>
        /// <see cref="BinaryFileDownloadCommunicator"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// <para>
        /// <see cref="CommunicatorBase{DataSet}.Sender"/>  <see cref="DataSetXmlSender"/> ݒ肵܂B
        /// </para>
        /// <para>
        /// <see cref="CommunicatorBase{DataSet}.Receiver"/>  <see cref="BinaryFileReceiver"/> ݒ肵܂B
        /// </para>
        /// </remarks>
        public BinaryFileDownloadCommunicator()
        {
            Sender = new DataSetXmlSender();
            Receiver = new BinaryFileReceiver();
        }

        /// <summary>
        /// _E[hs܂B
        /// </summary>
        /// <remarks>
        /// _E[ht@C[Jɕۑꂽꍇ́A
        /// <see cref="DownloadResult"/>  <see cref="DownloadResult.DownloadFilePath"/> Ƀt@CpXݒ肳܂B
        /// t@C[JɕۑȂꍇ́A<see cref="DownloadResult.DownloadFilePath"/>  null QƂłB
        /// </remarks>
        /// <param name="paramData">T[oAvP[V֑M <see cref="DataSet"/>B</param>
        /// <param name="requestHeaders">M HTTP wb_Ƃėpwb_̃RNVB</param>
        /// <returns>ʐMʂi[ <see cref="DownloadResult"/>B</returns>
        /// <exception cref="ArgumentNullException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="paramData"/>  <c>null</c> QƂłB
        /// </item>
        /// <item>
        /// <paramref name="requestHeaders"/>  <c>null</c> QƂłB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ArgumentException">
        /// ʐMŕKvȃf[^słB
        /// </exception>
        /// <exception cref="ServerException">
        /// T[oAvP[Vőz肵ȂO܂B
        /// </exception>
        /// <exception cref="System.Net.WebException">
        /// ʐMG[܂B܂́ANGXgLZ܂B
        /// </exception>
        /// <exception cref="CommunicationException">
        /// f[^̑MɃG[܂B
        /// </exception>
        public virtual DownloadResult Download(DataSet paramData, IDictionary<string, string> requestHeaders)
        {
            CommunicationResult cResult = Communicate(paramData, requestHeaders);

            DownloadResult dResult = cResult as DownloadResult;
            if (dResult == null)
            {
                dResult = new DownloadResult(null);
                dResult.AddResponseHeaders(cResult.ResponseHeaders);
                dResult.ResultData = cResult.ResultData;
            }

            return dResult;
        }
    }
}
