﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Configuration;
using System.Data;

namespace TERASOLUNA.Fw.Client.Configuration.Conversion
{
    /// <summary>
    /// データセット変換設定ファイル内の convert 要素を表します。
    /// </summary>
    /// <remarks>
    /// データセット変換情報を定義する要素です。
    /// convert 要素は、以下の属性、または子要素を含みます。
    /// <list type="table">
    /// <listheader>
    /// <description>属性</description>
    /// <description>説明</description>
    /// </listheader>
    /// <item>
    /// <description>id</description>
    /// <description>必須の属性です。convert 要素のキーとなる文字列を指定します。</description>
    /// </item>
    /// </list>
    /// <list type="table">
    /// <listheader>
    /// <description>子要素</description>
    /// <description>説明</description>
    /// </listheader>
    /// <item>
    /// <description>param</description>
    /// <description>必須の要素です。
    /// 新規 <see cref="DataSet"/> への変換情報を指定します（ <see cref="ParamElement"/> を参照）。
    /// </description>
    /// </item>
    /// <item>
    /// <description>result</description>
    /// <description>必須の要素です。
    /// 値を持つ既存 <see cref="DataSet"/> への変換情報を指定します（ <see cref="ResultElement"/> を参照）。
    /// </description>
    /// </item>
    /// </list>
    /// </remarks>
    public sealed class ConvertElement : ConfigurationElement
    {
        /// <summary>
        /// ID 属性の値です。
        /// </summary>
        /// <remarks>
        /// この定数の値は "id" です。
        /// </remarks>
        private const string ATTRIBUTE_NAME_ID = "id";

        /// <summary>
        /// param 要素のコレクションです。
        /// </summary>
        /// <remarks>
        /// この定数の値は "param" です。
        /// </remarks>
        private const string ELEMENT_NAME_PARAMS = "param";

        /// <summary>
        /// result 要素のコレクションです。
        /// </summary>
        /// <remarks>
        /// この定数の値は "resutlt" です。
        /// </remarks>
        private const string ELEMENT_NAME_RESULT = "resutlt";

        /// <summary>
        /// <see cref="ConvertElement"/> の新しいインスタンスを初期化します。
        /// </summary>
        /// <remarks>
        /// デフォルトコンストラクタです。
        /// </remarks>
        public ConvertElement()
        {
        }

        /// <summary>
        /// <see cref="ConvertElement"/> の新しいインスタンスを初期化します。
        /// </summary>
        /// <remarks>
        /// convert 要素の属性、子要素を初期化します。
        /// </remarks>
        /// <param name="id">convert 要素の id 属性の値。</param>
        /// <param name="param">param 要素のコレクション。</param>
        /// <param name="result">result 要素のコレクション。</param>
        public ConvertElement(string id, ParamElement param, ResultElement result)
        {
            this[ATTRIBUTE_NAME_ID] = id;
            this[ELEMENT_NAME_PARAMS] = param;
            this[ELEMENT_NAME_RESULT] = result;
        }

        /// <summary>
        /// id 属性の値を取得します。
        /// </summary>
        /// <value>
        /// id 属性の値。
        /// </value>
        [ConfigurationProperty(ATTRIBUTE_NAME_ID, IsRequired = true, IsKey = true)]
        public string Id
        {
            get
            {
                return (string)this[ATTRIBUTE_NAME_ID];
            }
        }

        /// <summary>
        /// param 要素のコレクションを取得します。
        /// </summary>
        /// <value>
        /// param 要素のコレクション。
        /// </value>
        [ConfigurationProperty(ELEMENT_NAME_PARAMS)]
        public ParamElement Param
        {
            get
            {
                return (ParamElement)this[ELEMENT_NAME_PARAMS];
            }
        }

        /// <summary>
        /// result 要素のコレクションを取得します。
        /// </summary>
        /// <value>
        /// result 要素のコレクション。
        /// </value>
        [ConfigurationProperty(ELEMENT_NAME_RESULT)]
        public ResultElement Result
        {
            get
            {
                return (ResultElement)this[ELEMENT_NAME_RESULT];
            }
        }
    }
}
