// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Configuration;

namespace TERASOLUNA.Fw.Client.Configuration.View
{
    /// <summary>
    /// ʑJڐݒt@C view vf\܂B
    /// </summary>
    /// <remarks>
    /// ViewElement ́AʑJڐݒt@C view vf\܂B 
    /// ڍׂɂĂ <see cref="ConfigurationElement"/> QƂĂB
    /// </remarks>
    public sealed class ViewElement : ConfigurationElement
    {
        /// <summary>
        /// type ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "type" łB
        /// </remarks>
        private const string TYPE_ATTRIBUTE_NAME = "type";

        /// <summary>
        /// id ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "id" łB
        /// </remarks>
        private const string ID_ATTRIBUTE_NAME = "id";

        /// <summary>
        /// <see cref="ViewElement"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>ftHgRXgN^łB</remarks>
        public ViewElement()
        {
        }

        /// <summary>
        /// <see cref="ViewElement"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="id">id ̒lB</param>
        /// <param name="type">type ̒lB</param>
        public ViewElement(string type, string id)
        {
            this[TYPE_ATTRIBUTE_NAME] = type;
            this[ID_ATTRIBUTE_NAME] = id;
        }

        /// <summary>
        /// id ̒l擾܂B
        /// </summary>
        /// <value>
        /// id ̒lB
        /// </value>
        [ConfigurationProperty(ID_ATTRIBUTE_NAME, IsRequired = true, IsKey = true)]
        public string Id
        {
            get
            {
                return (string)this[ID_ATTRIBUTE_NAME];
            }
        }

        /// <summary>
        /// type ̒l擾܂B
        /// </summary>
        /// <value>
        /// type ̒lB
        /// </value>
        [ConfigurationProperty(TYPE_ATTRIBUTE_NAME, IsRequired = true, IsKey = true)]
        public string Type
        {
            get
            {
                return (string)this[TYPE_ATTRIBUTE_NAME];
            }
        }
    }
}
