// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Text;
using System.Threading;
using TERASOLUNA.Fw.Client.Conversion;
using TERASOLUNA.Fw.Client.Forms;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.BLogic;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Common.Validation;

namespace TERASOLUNA.Fw.Client
{
    /// <summary>
    /// w肳ꂽrWlXWbNsNXłB
    /// </summary>
    /// <remarks>
    /// w肳ꂽrWlXWbN𓯊͔񓯊Ŏs܂B
    /// </remarks>
    public class Coordinator
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(Coordinator));

        /// <summary>
        /// AvP[V\t@C appSettings vfɎw肳 
        /// <see cref="Coordinator"/>  key łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "CoordinatorTypeName" łB
        /// </remarks>
        public static readonly string COORDINATOR_TYPENAME = "CoordinatorTypeName";

        /// <summary>
        /// AvP[V\t@C appSettings vfɎw肳 
        /// <see cref="IValidator"/>  key łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "ValidatorTypeName" łB
        /// </remarks>
        public static readonly string VALIDATOR_TYPENAME = "ValidatorTypeName";

        /// <summary>
        /// AvP[V\t@C appSettings vfɎw肳 
        /// <see cref="IConverter"/>  key łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "ConverterTypeName" łB
        /// </remarks>
        public static readonly string CONVERTER_TYPENAME = "ConverterTypeName";

        /// <summary>
        /// ͒l؃G[̌ʕłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "validationFailed" łB
        /// </remarks>
        public static readonly string VALIDATION_FAILED = "validationFailed";

        /// <summary>
        /// OG[̌ʕłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "preprocessedFailed" łB
        /// </remarks>
        public static readonly string PREPROCESSED_FAILED = "preprocessedFailed";

        /// <summary>
        /// <see cref="Coordinator"/> hNX̃^CvłB
        /// </summary>
        private static Type _coordinatorType = null;

        /// <summary>
        /// <see cref="EventController"/> ێ܂B
        /// </summary>
        private EventController _eventController = null;

        /// <summary>
        /// <see cref="IValidator"/> NX̃CX^Xێ܂B
        /// </summary>
        private IValidator _validator = null;

        /// <summary>
        /// <see cref="IConverter"/> NX̃CX^Xێ܂B
        /// </summary>
        private IConverter _converter = null;

        /// <summary>
        /// <see cref="AsyncOperation"/> CX^Xێ܂B
        /// </summary>
        private AsyncOperation _asyncOpe = null;

        /// <summary>
        /// <see cref="IBLogic"/> NX̃CX^Xێ܂B
        /// </summary>
        private IBLogic _blogic = null;

        /// <summary>
        /// rWlXWbN񓯊Ŏsǂ\܂B
        /// </summary>
        /// <remarks>
        /// <para><see cref="CoordinatorType"/> 񓯊s̏ꍇ true ɂȂ܂B
        /// ȊȌꍇ false ɂȂ܂B </para>
        /// </remarks>
        private bool _isBusy = false;

        /// <summary>
        /// rWlXWbNʃXbhŎsfQ[gCX^XłB
        /// </summary>
        private DoExecuteAsyncDelegate _doExecuteAsyncDelegate;

        /// <summary>
        /// 񓯊ƂɎsR[obNfQ[gCX^XłB
        /// </summary>
        private SendOrPostCallback _executeAsyncCompletedCallback;

        /// <summary>
        /// 񓯊is󋵂񍐂ƂɎsR[obNfQ[gCX^XłB
        /// </summary>
        private SendOrPostCallback _executeAsyncProgressChangedCallback;

        /// <summary>
        /// <see cref="Coordinator"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// fQ[gAR[obNfQ[g܂B
        /// </remarks>
        public Coordinator()
        {
            _doExecuteAsyncDelegate = new DoExecuteAsyncDelegate(DoExecuteAsync);
            _executeAsyncCompletedCallback =
                new SendOrPostCallback(ExecuteAsyncCompletedCallback);
            _executeAsyncProgressChangedCallback =
                new SendOrPostCallback(ExecuteAsyncProgressChangedCallback);
        }

        /// <summary>
        /// <see cref="Coordinator"/> hNX̃^Cv擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// <see cref="Coordinator"/> hNX̃^CvB
        /// </value>
        protected static Type CoordinatorType
        {
            get
            {
                return _coordinatorType;
            }
            set
            {
                _coordinatorType = value;
            }
        }

        /// <summary>
        /// <see cref="EventController"/> 擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// <see cref="Coordinator"/> ̌Ăяoł <see cref="EventController"/> ̃CX^XB
        /// </value>
        protected EventController EventController
        {
            get
            {
                return _eventController;
            }
            set
            {
                _eventController = value;
            }
        }

        /// <summary>
        /// <see cref="IValidator"/> NX̃CX^X擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// <see cref="IValidator"/> NX̃CX^XB
        /// </value>
        protected IValidator Validator
        {
            get
            {
                return _validator;
            }
            set
            {
                _validator = value;
            }
        }

        /// <summary>
        /// <see cref="IConverter"/> NX̃CX^X擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// <see cref="IConverter"/> NX̃CX^XB
        /// </value>
        protected IConverter Converter
        {
            get
            {
                return _converter;
            }
            set
            {
                _converter = value;
            }
        }

        /// <summary>
        /// <see cref="AsyncOperation"/> CX^X擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// 񓯊̐is󋵂ǐՂIuWFNgB
        /// </value>
        protected AsyncOperation AsyncOpe
        {
            get
            {
                return _asyncOpe;
            }
            set
            {
                _asyncOpe = value;
            }
        }

        /// <summary>
        /// <see cref="IBLogic"/> NX擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// <see cref="IBLogic"/> NXB
        /// </value>
        protected IBLogic BLogic
        {
            get
            {
                return _blogic;
            }
            set
            {
                _blogic = value;
            }
        }

        /// <summary>
        /// <see cref="Coordinator"/> 񓯊sǂl擾܂B 
        /// </summary>
        /// <value>
        /// <see cref="Coordinator"/> 񓯊s̏ꍇ trueBȊȌꍇ falseB 
        /// </value>
        public bool IsBusy
        {
            get
            {
                return _isBusy;
            }
            protected set
            {
                _isBusy = value;
            }
        }

        /// <summary>
        /// <see cref="IValidator"/> NX 
        /// <see cref="IConverter"/> NX̃CX^X𐶐܂B
        /// </summary>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <see cref="IValidator"/> NX̃CX^X𐶐ł܂B
        /// </item>
        /// <item>
        /// <see cref="IConverter"/> NX̃CX^X𐶐ł܂B
        /// </item>
        /// </list>
        /// </exception>
        protected virtual void Initialize()
        {
            // ͒l؃NX̃CX^X̐
            _validator = ValidatorFactory.CreateValidator();
            // f[^ZbgϊNX̃CX^X̐
            _converter = ConverterFactory.CreateConverter();
        }

        /// <summary>
        /// <see cref="Coordinator"/> NX̃CX^X܂́A
        /// <see cref="Coordinator"/> hNX̃CX^X𐶐Aԋp܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// AvP[V\t@Cɐݒ肳ꂽ 
        /// <see cref="Coordinator"/> hNX̃CX^X𐶐Aԋp܂B
        /// </para>
        /// <para>
        /// AvP[V\t@C
        /// <see cref="Coordinator"/> hNX̐ݒ肪Ȃꍇ́A 
        /// <see cref="Coordinator"/> ̃CX^Xԋp܂B
        /// </para>
        /// </remarks>
        /// <returns>
        /// <see cref="Coordinator"/> NX̃CX^XB
        /// ܂́A<see cref="Coordinator"/> hNX̃CX^XB
        /// </returns>
        /// <exception cref="TerasolunaException">
        /// <see cref="Coordinator"/> hNX̃CX^X𐶐ł܂B
        /// </exception>
        public static Coordinator CreateCoordinator()
        {
            Coordinator coordinator = null;

            // Coordinator𐶐yь^LbV
            if (_coordinatorType == null)
            {
                coordinator = ClassUtil.CreateInstanceFromAppSettings<Coordinator>(
                    COORDINATOR_TYPENAME, typeof(Coordinator));
                _coordinatorType = coordinator.GetType();
            }
            else
            {
                coordinator =
                    ClassUtil.CreateInstanceByType<Coordinator>(_coordinatorType);
            }

            return coordinator;
        }

        /// <summary>
        /// rWlXWbN̎sɕKvȏi[
        /// <see cref="BLogicParam"/> NX̃CX^X𐶐Aԋp܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <see cref="EventController"/> ɐݒ肵rWlXWbN <see cref="DataSet"/> 
        /// ^ƂɃCX^X𐶐܂B
        /// </para>
        /// <para>
        /// <see cref="EventController"/> ɃrWlXWbN <see cref="DataSet"/> ̌^
        /// ݒ肳ĂȂꍇ́A<see cref="Coordinator.EventController"/>  ViewData 
        /// ^ <see cref="DataSet"/> ܂B
        /// <see cref="Coordinator.EventController"/>  ViewData ݒ肳ĂȂꍇ́A
        ///  <see cref="DataSet"/> ܂B
        /// </para>
        /// <para>
        /// <see cref="BLogicParam"/> NX̃CX^X𐶐A
        /// <see cref="EventController"/>  Items ACX^X Items ɃRs[܂B
        /// ܂A<see cref="Client.EventController.REQUEST_NAME"/> L[Ƃ <see cref="Client.EventController.RequestName"/>  
        /// ̒l Items ɒǉ܂B<see cref="Client.EventController.REQUEST_NAME"/> L[ƂĂłɗpĂꍇA
        /// l㏑܂B
        /// </para>
        /// <para>
        /// <see cref="BLogicParam"/> NX̃CX^X <see cref="BLogicParam.ParamData"/> 
        /// rWlXWbN <see cref="DataSet"/> ̃CX^Xݒ肵܂B
        /// </para>
        /// </remarks>
        /// <returns>
        /// rWlXWbN̎sɕKvȏi[邽߂̃NX <see cref="BLogicParam"/>B
        /// </returns>
        /// <param name="blogicParamTypeName">
        /// rWlXWbN <see cref="DataSet"/> ̌^B
        /// </param>
        /// <param name="viewData">
        ///  <see cref="DataSet"/>B
        /// </param>
        /// <param name="items">
        /// rWlXWbN̎sɕKvȃp[^i[ <see cref="IDictionary{String,Object}"/>B
        /// </param>
        /// <param name="requestName">
        /// ʐMɒʒm郊NGXgB
        /// </param>
        /// <exception cref="TerasolunaException">
        /// <see cref="DataSet"/> ̃CX^X𐶐ł܂B
        /// </exception>
        protected virtual BLogicParam CreateBLogicParam(
            string blogicParamTypeName, DataSet viewData, IDictionary<string, object> items, string requestName)
        {
            // rWlXWbN̓f[^Zbg
            DataSet blogicParamData = null;

            // typeNamenull܂͋󕶎̏ꍇ
            if (string.IsNullOrEmpty(blogicParamTypeName))
            {
                if (viewData == null)
                {
                    blogicParamData = ClassUtil.CreateInstanceByType<DataSet>(typeof(DataSet));
                }
                else
                {
                    blogicParamData = ClassUtil.CreateInstanceByType<DataSet>(viewData.GetType());
                }
            }
            else
            {
                blogicParamData = ClassUtil.CreateInstanceByTypeName<DataSet>(blogicParamTypeName);
            }

            // ̓IuWFNg̐
            BLogicParam blogicParam = new BLogicParam();

            // EventControllerItemsBLogicParamItemsւ̃Rs[
            foreach (string key in items.Keys)
            {
                blogicParam.Items.Add(key, items[key]);
            }

            // Request̐ݒ
            if (!string.IsNullOrEmpty(requestName))
            {
                blogicParam.Items[EventController.REQUEST_NAME] = requestName;
            }

            if (_log.IsTraceEnabled)
            {
                StringBuilder message = new StringBuilder();
                if (blogicParam.Items.Count > 0)
                {
                    StringBuilder itemList = new StringBuilder();
                    foreach (string key in blogicParam.Items.Keys)
                    {
                        itemList.AppendLine(string.Format(
                            Properties.Resources.T_DICTIONARY_KEY_VALUE, key, blogicParam.Items[key]));
                    }
                    message.AppendLine(string.Format(
                        Properties.Resources.T_ITEMS_VALUE, blogicParam.GetType().FullName, "Items"));
                    message.Append(itemList);
                }
                else
                {
                    message.AppendLine(string.Format(
                        Properties.Resources.T_NOT_ITEMS_VALUE, blogicParam.GetType().FullName, "Items"));
                }
                _log.Trace(message.ToString().Trim());
            }

            blogicParam.ParamData = blogicParamData;

            return blogicParam;
        }

        /// <summary>
        /// rWlXWbNo <see cref="DataSet"/> ̌^ƃrWlXWbNw肵A
        /// <see cref="IBLogic"/> NX̃CX^X𐶐ĕԋp܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <paramref name="eventController"/> ɐݒ肵 <see cref="Client.EventController.BLogicName"/> A
        /// rWlXWbNo <see cref="DataSet"/> ̌^Ƃ
        /// CX^X𐶐ĕԋp܂B
        /// </para>
        /// <para>
        /// <see cref="Client.EventController.BLogicName"/>  null ܂͋󕶎̏ꍇ́A
        /// sȂ <see cref="NopBLogic"/> ̃CX^X𐶐ĕԋp܂B
        /// </para>
        /// <para>
        /// rWlXWbNŃWFlbŇ^p[^KvƂĂꍇ́A
        /// <see cref="Coordinator.EventController"/>  <see cref="ExecutionResult.BLogicResultData"/>  
        /// <see cref="DataSet"/> ̌^w肵ĂB
        /// </para>
        /// <para>
        /// <see cref="Coordinator.EventController"/>  
        /// <see cref="Client.EventController.BLogicResultTypeName"/>  
        /// <see cref="DataSet"/> ̌^w肳ĂȂꍇ́A
        /// <see cref="Coordinator.EventController"/>  
        /// <see cref="Client.EventController.ViewData"/> ̌^𗘗p܂B
        /// <see cref="Coordinator.EventController"/>  
        /// <see cref="Client.EventController.ViewData"/> ݒ肳ĂȂꍇ́A
        ///  <see cref="DataSet"/> ̌^𗘗p܂B
        /// </para>
        /// </remarks>
        /// <param name="blogicName">rWlXWbNB</param>
        /// <param name="blogicResultTypeName">rWlXWbNo <see cref="DataSet"/> ̌^B</param>
        /// <param name="viewData"> <see cref="DataSet"/>B</param>
        /// <returns>
        /// <see cref="IBLogic"/> NX̃CX^XB
        /// </returns>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// <see cref="IBLogic"/> NX̃CX^Xł܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>RXgN^ɃANZXłȂꍇB</description>
        /// </item>
        /// <item>
        /// <description>RXgN^ŗOꍇB</description>
        /// </item>
        /// </list>
        /// </exception>
        protected virtual IBLogic CreateBLogic(string blogicName, string blogicResultTypeName, DataSet viewData)
        {
            // CxgReLXgrWlXWbNł̏ʂi[DataSet̃^Cv擾
            // ^Cvw肳ĂȂꍇ́AViewDatǎ^BLogicFactoryɓn
            string genericTypeName = null;
            if (string.IsNullOrEmpty(blogicResultTypeName))
            {
                if (viewData == null)
                {
                    genericTypeName = typeof(DataSet).AssemblyQualifiedName;
                }
                else
                {
                    genericTypeName = viewData.GetType().AssemblyQualifiedName;
                }
            }
            else
            {
                genericTypeName = blogicResultTypeName;
            }

            IBLogic blogic = BLogicFactory.CreateBLogic(blogicName, genericTypeName);

            IProgressChangedEventInvoker progressChangedEventInvoker = blogic as IProgressChangedEventInvoker;
            if (progressChangedEventInvoker != null)
            {
                progressChangedEventInvoker.ProgressChanged
                    += new ExecuteProgressChangedEventHandler(DoExecuteProgressChanged);
            }

            return blogic;
        }

        /// <summary>
        /// Cxgʂi[ <see cref="ExecutionResult"/> 𐶐܂B
        /// </summary>
        /// <returns>
        ///  <see cref="ExecutionResult"/> ̃CX^XB
        /// </returns>
        protected virtual ExecutionResult CreateExecutionResult()
        {
            return new ExecutionResult();
        }

        /// <summary>
        /// ͒l،ʂi[ <see cref="ValidationResult"/> 𐶐܂B
        /// </summary>
        /// <returns>
        ///  <see cref="ValidationResult"/> ̃CX^XB
        /// </returns>
        protected virtual ValidationResult CreateValidationResult()
        {
            return new ValidationResult();
        }

        /// <summary>
        /// rWlXWbN𓯊ŎsA
        /// sʂ <see cref="ExecutionResult"/> ԋp܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// rWlXWbN𓯊ŎsA
        /// sʂ <see cref="ExecutionResult"/> ԋp܂B
        /// </para>
        /// <para>
        ///  <see cref="DataSet"/> ɑ΂ē͒l؂s܂B
        /// ͒l؂́A͒l؋@\ɂPڃ`FbNƁA
        /// <see cref="EventController"/> ̃JX^`FbNCxgōsƂł܂B
        /// ͒l؎sɂ͓͎sꂸA
        /// <see cref="ExecutionResult"/> ̌ʕ
        /// <see cref="Coordinator.VALIDATION_FAILED"/> i[A
        /// <see cref="FormBase"/> ̃G[nhyсA
        /// <see cref="EventController"/> ̓͒l؎sCxgsA
        /// <see cref="ExecutionResult"/> ԋp܂B
        /// ܂A͒l؎sCxgŌʕύX邱Ƃł܂B
        /// </para>
        /// <para>
        ///  <see cref="DataSet"/> ̓eA <see cref="EventController"/> Őݒ肳Ă
        /// rWlXWbN <see cref="DataSet"/> ɋlߑւ܂B
        /// </para>
        /// <para>
        /// rWlXWbN <see cref="DataSet"/> ɑ΂đOs܂B
        /// ÓA <see cref="EventController"/> ̑OCxgōsƂł܂B
        /// Osɂ͓͎sꂸA
        /// <see cref="ExecutionResult"/> ̌ʕ
        /// <see cref="Coordinator.PREPROCESSED_FAILED"/> A܂͑OCxgŐݒ肵Cӂ̌ʕ񂪊i[A
        /// <see cref="FormBase"/> ̃G[nhyсA
        /// <see cref="EventController"/> ̑OsCxgsA
        /// <see cref="ExecutionResult"/> ԋp܂B
        /// ܂AOsCxgŁAʕύX邱Ƃł܂B
        /// </para>
        /// <para>
        /// rWlXWbNs܂B
        /// <see cref="ExecutionResult.ResultString"/>  <see cref="BLogicResult.SUCCESS"/> ̏ꍇA
        /// rWlXWbŇ <see cref="DataSet"/>  <see cref="DataSet"/> ɕϊsA
        /// <see cref="ExecutionResult"/> ԋp܂B
        /// <see cref="ExecutionResult.ResultString"/>  <see cref="BLogicResult.SUCCESS"/> ȊȌꍇA
        /// <see cref="FormBase"/> ̃G[nhyсA
        /// <see cref="EventController"/> ̃CxgsCxgsA
        /// <see cref="ExecutionResult"/> ԋp܂B
        /// </para>
        /// </remarks>
        /// <param name="eventController">
        /// <see cref="Execute"/> \bȟĂяoł <see cref="EventController"/> ̃CX^XB
        /// </param>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="eventController"/>  null QƂłB
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">      
        /// <item>
        /// <description>
        /// <see cref="Coordinator.EventController"/>  ValidationFilePath ݒ肵A
        /// <see cref="Coordinator.EventController"/>  View  null QƂ̏ꍇB
        /// </description>
        /// </item>        
        /// <item>
        /// <description>
        /// <see cref="Coordinator.EventController"/>  ConvertId ݒ肵A
        /// <see cref="Coordinator.EventController"/>  View  null QƂ̏ꍇB
        /// </description>
        /// </item>    
        /// <item>
        /// <description>
        /// <see cref="Coordinator.EventController"/>  ConvertId ݒ肵A
        /// <see cref="Coordinator.BLogic"/>  <see cref="IBLogic.Execute"/> 
        /// sʂł <see cref="BLogicResult"/>  ResultData  null QƂ̏ꍇB
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// <see cref="IValidator"/> NX̃CX^X𐶐ł܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// <see cref="IConverter"/> NX̃CX^X𐶐ł܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// rWlXWbN <see cref="DataSet"/> ̃CX^X𐶐ł܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// <see cref="IBLogic"/> NX̃CX^X𐶐ł܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// rWlXWbN̖߂l <see cref="BLogicResult"/>  null QƂłB
        /// </description>
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConversionException">
        /// f[^ZbgϊɃG[܂B
        /// </exception>
        /// <returns>
        /// sʂi[ <see cref="ExecutionResult"/> ̃CX^XB
        /// </returns>
        public virtual ExecutionResult Execute(EventController eventController)
        {
            if (eventController == null)
            {
                ArgumentNullException exception = new ArgumentNullException("eventController");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "eventController"), exception);
                }
                throw exception;
            }

            _eventController = eventController;

            // CxgʃNX̐
            ExecutionResult executionResult = CreateExecutionResult();

            // G[NA
            ClearError(eventController.ErrorHandler, eventController.ViewData, eventController.ErrorPaths);

            // Validator, Converteȑ
            Initialize();

            // OsAsBLogic̓̓p[^擾B
            BLogicParam blogicParam = Preprocess(eventController, executionResult);
            if (!string.IsNullOrEmpty(executionResult.ResultString))
            {
                return executionResult;
            }

            // BLogics()
            _blogic = CreateBLogic(
                eventController.BLogicName, eventController.BLogicResultTypeName, eventController.ViewData);
            BLogicResult blogicResult = null;
            try
            {
                blogicResult = ExecuteBLogic(blogicParam);
            }
            catch (Exception e)
            {
                if (_log.IsErrorEnabled)
                {
                    _log.Error(Properties.Resources.E_BLOGIC_EXECUTE_EXCEPTION, e);
                }
                throw;
            }

            if (blogicResult == null)
            {
                TerasolunaException exception = new TerasolunaException(
                    Properties.Resources.E_BLOGIC_NULL_RESULT);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            // rWlXWbŇ㏈
            Postprocess(eventController, executionResult, blogicResult);

            return executionResult;
        }

        /// <summary>
        /// rWlXWbN̑OsArWlXWbN <see cref="DataSet"/> 擾܂B
        /// </summary>
        /// <param name="eventController"><see cref="EventController"/> ̃CX^XB</param>
        /// <param name="executionResult"><see cref="Coordinator"/> ̎sʂi[ 
        /// <see cref="ExecutionResult"/> ̃CX^XB</param>
        /// <returns>rWlXWbN <see cref="DataSet"/> ̃CX^XB</returns>
        protected virtual BLogicParam Preprocess(
            EventController eventController, ExecutionResult executionResult)
        {
            // rWlXWbN̓f[^Zbg
            BLogicParam blogicParam = null;

            // ͒l؎s
            ValidationResult validationResult = Validate(eventController, executionResult);
            if (!validationResult.IsValid)
            {
                return blogicParam;
            }

            // rWlXWbN̓f[^Zbg
            blogicParam = CreateBLogicParam(eventController.BLogicParamTypeName,
                eventController.ViewData, eventController.Items, eventController.RequestName);

            // ViewDataBLogicParamDataϊ
            ConvertDataSet(eventController.ConvertId, eventController.ViewData, blogicParam.ParamData);

            // OCxg
            // CxgŃG[ꍇ Coordinator I
            eventController.ReportPreprocessed(executionResult, blogicParam.ParamData);
            if (!string.IsNullOrEmpty(executionResult.ResultString) || executionResult.Errors.Count > 0)
            {
                if (_log.IsDebugEnabled)
                {
                    _log.Debug(Properties.Resources.D_PREPROCESSED_FAILED);
                }
                if (string.IsNullOrEmpty(executionResult.ResultString))
                {
                    executionResult.ResultString = PREPROCESSED_FAILED;
                }
                HandleError(eventController.ErrorHandler, executionResult, 
                    eventController.ViewData, eventController.ErrorPaths);
                eventController.ReportPreprocessedFailed(executionResult, blogicParam.ParamData);
            }

            return blogicParam;
        }

        /// <summary>
        /// ͒l؂s܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <see cref="Client.EventController.ViewData"/> ɑ΂ē͒l؂sA
        /// <see cref="Client.EventController"/> ̃JX^`FbNCxgs܂B
        /// </para>
        /// </remarks>
        /// <param name="eventController"><see cref="Client.EventController"/> ̃CX^XB</param>
        /// <param name="executionResult">sʂi[ <see cref="ExecutionResult"/> ̃CX^XB</param>
        /// <returns>
        /// ،ʂ̃G[ێ <see cref="ValidationResult"/> ̃CX^XB
        /// </returns>
        protected virtual ValidationResult Validate(
            EventController eventController, ExecutionResult executionResult)
        {
            // ͒l؋@\ɂf[^Zbgɑ΂͒l
            ValidationResult validationResult = 
                ValidateViewData(eventController.ViewData, eventController.ValidationFilePath, eventController.RuleSet);

            // JX^`FbNCxgɂ͒l
            eventController.ReportCustomValidating(validationResult);

            // ͒l؃G[̏
            if (!validationResult.IsValid)
            {
                if (_log.IsDebugEnabled)
                {
                    _log.Debug(Properties.Resources.D_VALIDATOR_FAILED);
                }
                RepackExecutionResult(validationResult, executionResult);
                executionResult.ResultString = VALIDATION_FAILED;
                HandleError(eventController.ErrorHandler, executionResult, 
                    eventController.ViewData, eventController.ErrorPaths);
                eventController.ReportValidationFailed(executionResult);
            }

            return validationResult;
        }

        /// <summary>
        /// rWlXWbN̏ʂ܂B
        /// </summary>
        /// <remarks>
        /// rWlXWbN̏ꍇ́ArWlXWbNo̓f[^Zbg̒lA
        /// ʃf[^ZbgɃf[^ZbgϊsB
        /// rWlXWbNs̏ꍇ́AG[@\ĂтA
        /// rWlXWbNsCxg𔭍sB
        /// </remarks>
        /// <param name="eventController">
        /// <see cref="Execute"/> \bȟĂяo܂́A
        /// <see cref="ExecuteAsync"/> \bȟĂяoł 
        /// <see cref="EventController"/> ̃CX^XB
        /// </param>
        /// <param name="executionResult">
        /// sʂi[ <see cref="ExecutionResult"/> ̃CX^XB
        /// </param>
        /// <param name="blogicResult">
        /// rWlXWbN̎sʂi[ <see cref="BLogicResult"/> ̃CX^XB
        /// </param>
        protected virtual void Postprocess(
            EventController eventController, 
            ExecutionResult executionResult, 
            BLogicResult blogicResult)
        {
            // BLogicResultExecutionResultւ̋lߑւ
            RepackExecutionResult(blogicResult, executionResult);

            // BLogicResultEventControllerItems̋lߑւ
            foreach (string key in blogicResult.Items.Keys)
            {
                eventController.Items[key] = blogicResult.Items[key];
            }

            if (_log.IsTraceEnabled)
            {
                if (eventController.Items.Count != 0)
                {
                    StringBuilder message = new StringBuilder();
                    StringBuilder itemList = new StringBuilder();
                    foreach (string key in eventController.Items.Keys)
                    {
                        itemList.AppendLine(string.Format(
                            Properties.Resources.T_DICTIONARY_KEY_VALUE,
                            key, eventController.Items[key]));
                    }
                    message.AppendLine(string.Format(
                        Properties.Resources.T_ITEMS_VALUE, eventController.GetType().FullName, "Items"));
                    message.Append(itemList);
                    _log.Trace(message.ToString().Trim());
                }
                else
                {
                    _log.Trace(string.Format(
                        Properties.Resources.T_NOT_ITEMS_VALUE, eventController.GetType().FullName, "Items"));
                }
            }

            // rWlXWbN
            if (BLogicResult.SUCCESS.Equals(executionResult.ResultString))
            {
                ReverseDataSet(eventController.ConvertId, eventController.ViewData, executionResult.BLogicResultData);
            }
            else
            {
                // rWlXWbNs
                HandleError(eventController.ErrorHandler, executionResult, 
                    eventController.ViewData, eventController.ErrorPaths);
                eventController.ReportBLogicFailed(executionResult);
            }
        }

        /// <summary>
        /// rWlXWbNsāA<see cref="BLogicResult"/> ̃CX^Xԋp܂B
        /// </summary>
        /// <param name="blogicParam">
        /// rWlXWbN <see cref="BLogicParam"/> ̃CX^XB
        /// </param>
        /// <returns>
        /// rWlXWbNsʂi[ <see cref="BLogicResult"/> ̃CX^XB
        /// </returns>
        protected virtual BLogicResult ExecuteBLogic(BLogicParam blogicParam)
        {
            if (_log.IsDebugEnabled)
            {
                _log.Debug(string.Format(
                    Properties.Resources.D_BEGIN_BLOGIC_FUNCTION,
                    _blogic.GetType().FullName));
            }

            BLogicResult blogicResult = _blogic.Execute(blogicParam);

            if (_log.IsDebugEnabled)
            {
                _log.Debug(string.Format(
                    Properties.Resources.D_END_BLOGIC_FUNCTION,
                    _blogic.GetType().FullName));
            }

            return blogicResult;
        }

        /// <summary>
        /// <see cref="Client.EventController.ViewData"/> ɑ΂ē͒l؂sA
        /// <see cref="ValidationResult"/> ̃CX^Xԋp܂B
        /// </summary>
        /// <param name="viewData"> <see cref="DataSet"/>B</param>
        /// <param name="validationFilePath">͒lؐݒt@CpXB</param>
        /// <param name="ruleSet">͒l؃[ZbgB</param>
        /// <remarks>
        /// <para>
        /// <see cref="Client.EventController.ValidationFilePath"/> ݒ肳Ă΁A
        /// ͒l؋@\𗘗pPڃ`FbNs܂B
        /// </para>
        /// </remarks>
        /// <returns>
        /// ͒l،ʂi[ <see cref="ValidationResult"/> ̃CX^XB
        /// </returns>
        /// <exception cref="TerasolunaException">
        /// <see cref="Client.EventController.ValidationFilePath"/> ݒ肵A
        /// <see cref="Client.EventController.ViewData"/>  null QƂ̏ꍇB
        /// </exception>
        protected virtual ValidationResult ValidateViewData(DataSet viewData, string validationFilePath, string ruleSet)
        {
            ValidationResult validationResult = CreateValidationResult();

            // ͒l؋@\ɂPڃ`FbN
            if (!string.IsNullOrEmpty(validationFilePath))
            {
                if (viewData == null)
                {
                    string message = string.Format(
                        Properties.Resources.E_BLOGIC_NULL_DATASET,
                        "ValidationFilePath",
                        "ViewData");
                    TerasolunaException exception = new TerasolunaException(message);
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(message, exception);
                    }
                    throw exception;
                }

                _validator.ValidationFilePath = validationFilePath;
                if (!string.IsNullOrEmpty(ruleSet))
                {
                    _validator.RuleSet = ruleSet;
                }

                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_CALL_VALIDATOR,
                        validationFilePath, ruleSet));
                }

                validationResult = _validator.Validate(viewData);
            }
            else
            {
                if (_log.IsDebugEnabled)
                {
                    _log.Debug(Properties.Resources.D_NOT_VALIDATE_VIEW_DATA);
                }
            }

            return validationResult;
        }

        /// <summary>
        /// <see cref="IConverter"/>  <see cref="IConverter.Convert"/> s܂B
        /// </summary>
        /// <param name="convertId">Ro[g IDB</param>
        /// <param name="viewData"> <see cref="DataSet"/>B</param>
        /// <param name="blogicParamData">
        /// ϊ <see cref="DataSet"/> ̃CX^XB
        /// </param>
        /// <exception cref="TerasolunaException">
        /// <see cref="EventController"/>  ConvertId ݒ肵A
        /// <see cref="EventController"/>  ViewData  null QƂ̏ꍇB
        /// </exception>
        /// <exception cref="ConversionException">
        /// f[^ZbgϊɃG[܂B
        /// </exception>
        protected virtual void ConvertDataSet(string convertId, DataSet viewData, DataSet blogicParamData)
        {
            if (!string.IsNullOrEmpty(convertId))
            {
                if (viewData == null)
                {
                    string message = string.Format(
                        Properties.Resources.E_BLOGIC_NULL_DATASET, "ConvertId", "ViewData");
                    TerasolunaException exception = new TerasolunaException(message);
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(message, exception);
                    }
                    throw exception;
                }

                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_CALL_CONVERTER, convertId, "Convert"));
                }

                _converter.Convert(convertId, viewData, blogicParamData);
            }
            else
            {
                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_NOT_CONVERT_DATA_SET, "Convert"));
                }
            }
        }

        /// <summary>
        /// rWlXWbN̎sʂi[ꂽ <see cref="BLogicResult"/> CX^XA 
        /// <see cref="Coordinator"/> ̎sʂi[ 
        /// <see cref="ExecutionResult"/> CX^X֋lߑւ܂B
        /// </summary>
        /// <param name="blogicResult">
        /// rWlXWbN̎sʂi[ꂽ <see cref="BLogicResult"/> ̃CX^XB
        /// </param>
        /// <param name="executionResult">
        /// <see cref="Coordinator"/> ̎sʂi[ 
        /// <see cref="ExecutionResult"/> ̃CX^XB
        /// </param>
        protected virtual void RepackExecutionResult(
            BLogicResult blogicResult, ExecutionResult executionResult)
        {
            executionResult.AddErrors(blogicResult.Errors);
            executionResult.BLogicResultData = blogicResult.ResultData;
            executionResult.ResultString = blogicResult.ResultString;
        }

        /// <summary>
        /// ͒l،ʂi[ꂽ <see cref="ValidationResult"/> CX^X 
        /// <see cref="Coordinator"/> ̎sʂi[ 
        /// <see cref="ExecutionResult"/> CX^X֋lߑւ܂B
        /// </summary>
        /// <param name="validationResult">
        /// ͒l؂̌ʂi[ꂽ <see cref="ValidationResult"/> ̃CX^XB
        /// </param>
        /// <param name="executionResult">
        /// <see cref="Coordinator"/> ̎sʂi[ <see cref="ExecutionResult"/> ̃CX^XB
        /// </param>
        protected virtual void RepackExecutionResult(
            ValidationResult validationResult, ExecutionResult executionResult)
        {
            foreach (MessageInfo message in validationResult.Errors)
            {
                executionResult.Errors.Add(message);
            }
        }

        /// <summary>
        /// <see cref="IConverter"/>  <see cref="IConverter.Reverse"/> s܂B
        /// </summary>
        /// <param name="convertId">Ro[g IDB</param>
        /// <param name="viewData"> <see cref="DataSet"/>B</param>
        /// <param name="blogicResultData">rWlXWbN̎sʂi[ <see cref="DataSet"/>B</param>
        /// <exception cref="TerasolunaException">
        /// <see cref="EventController"/>  ConvertId ݒ肵A
        /// <see cref="Coordinator.BLogic"/>  <see cref="IBLogic.Execute"/> 
        /// sʂł <see cref="BLogicResult"/>  BLogicResultData  null QƂ̏ꍇB
        /// </exception>
        protected virtual void ReverseDataSet(
            string convertId, DataSet viewData, DataSet blogicResultData)
        {
            if (!string.IsNullOrEmpty(convertId))
            {
                if (blogicResultData == null)
                {
                    TerasolunaException exception = new TerasolunaException(Properties.Resources.E_BLOGIC_RESULT_NULL_DATASET);
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(exception.Message, exception);
                    }
                    throw exception;
                }

                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_CALL_CONVERTER, convertId, "Reverse"));
                }

                _converter.Reverse(convertId, viewData, blogicResultData);
            }
            else
            {
                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_NOT_CONVERT_DATA_SET, "Reverse"));
                }
            }
        }

        /// <summary>
        /// rWlXWbN񓯊Ŏs܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// rWlXWbN񓯊Ŏs܂B
        /// </para>
        /// <para>
        ///  <see cref="DataSet"/> ɑ΂ē͒l؂s܂B
        /// ͒l؂́A͒l؋@\ɂPڃ`FbNƁA
        /// <see cref="EventController"/> ̃JX^`FbNCxgɂ錟؂ōsƂł܂B
        /// ͒l؎sɂ͓͎sꂸA
        /// <see cref="ExecutionResult"/> ̌ʕ
        /// <see cref="Coordinator.VALIDATION_FAILED"/> i[A
        /// <see cref="FormBase"/> ̃G[nhyсA
        /// <see cref="EventController"/> ̓͒l؎sCxgsA
        /// 񓯊I܂B
        /// </para>
        /// <para>
        ///  <see cref="DataSet"/> ̓eA <see cref="EventController"/> ɐݒ肳Ă
        /// rWlXWbN <see cref="DataSet"/> ɋlߑւ܂B
        /// </para>
        /// <para>
        /// rWlXWbN <see cref="DataSet"/> ɑ΂đOs܂B
        /// ÓA <see cref="EventController"/> ̑OCxgōsƂł܂B
        /// Osɂ͓͎sꂸA 
        /// <see cref="ExecutionResult"/> ̌ʕ 
        /// <see cref="Coordinator.PREPROCESSED_FAILED"/> A܂͑OCxgŐݒ肵Cӂ̌ʕ񂪊i[A
        /// <see cref="FormBase"/> ̃G[nhyсA
        /// <see cref="EventController"/> ̑OsCxgsA
        /// 񓯊I܂B
        /// </para>
        /// <para>
        /// rWlXWbN񓯊s܂B
        /// <see cref="ExecutionResult.ResultString"/>  <see cref="BLogicResult.SUCCESS"/> ̏ꍇA
        /// rWlXWbŇ <see cref="DataSet"/>  <see cref="DataSet"/> ɕϊsA
        /// <see cref="EventController"/> ̔񓯊Cxgs܂B
        /// <see cref="ExecutionResult.ResultString"/>  <see cref="BLogicResult.SUCCESS"/> ȊȌꍇA
        /// <see cref="FormBase"/> ̃G[nhyсA
        /// <see cref="EventController"/> ̃CxgsCxgs܂B
        /// </para>
        /// </remarks>
        /// <param name="eventController">
        /// <see cref="ExecuteAsync"/> \bȟĂяoł 
        /// <see cref="EventController"/> ̃CX^XB
        /// </param>
        /// <exception cref="ArgumentNullException">
        /// ̗O <see cref="ExecuteCompletedEventArgs"/> Ɋi[܂B
        /// <para>
        /// <paramref name="eventController"/>  null QƂłB
        /// </para>
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOA <see cref="ExecuteCompletedEventArgs"/> Ɋi[܂B
        /// <list type="bullet">      
        /// <item>
        /// <description>
        /// <see cref="Coordinator.EventController"/>  ValidationFilePath ݒ肵A
        /// <see cref="Coordinator.EventController"/>  View  null QƂ̏ꍇB
        /// </description>
        /// </item>        
        /// <item>
        /// <description>
        /// <see cref="Coordinator.EventController"/>  ConvertId ݒ肵A
        /// <see cref="Coordinator.EventController"/>  View  null QƂ̏ꍇB
        /// </description>
        /// </item>    
        /// <item>
        /// <description>
        /// <see cref="Coordinator.EventController"/>  ConvertId ݒ肵A
        /// <see cref="Coordinator.BLogic"/>  <see cref="IBLogic.Execute"/> 
        /// sʂł <see cref="BLogicResult"/>  ResultData  null QƂ̏ꍇB
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// <see cref="IValidator"/> NX̃CX^X𐶐ł܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// <see cref="IConverter"/> NX̃CX^X𐶐ł܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// rWlXWbN <see cref="DataSet"/> ̃CX^X𐶐ł܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// <see cref="IBLogic"/> NX̃CX^X𐶐ł܂B
        /// </description>
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConversionException">
        /// ̗O <see cref="ExecuteCompletedEventArgs"/> Ɋi[܂B
        /// <para>
        /// f[^ZbgϊɃG[܂B
        /// </para>
        /// </exception>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes")]
        public virtual void ExecuteAsync(EventController eventController)
        {
            if (eventController == null)
            {
                ArgumentNullException exception = new ArgumentNullException("eventController");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "eventController"), exception);
                }
                throw exception;
            }

            // ɔ񓯊Ŏsł͂Ȃ`FbN
            if (_isBusy)
            {
                InvalidOperationException exception = new InvalidOperationException(
                    Properties.Resources.E_BLOGIC_EXECUTEASYNC_OPERATED);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            // 񓯊sɐݒ
            _isBusy = true;

            _eventController = eventController;

            ExecutionResult executionResult = new ExecutionResult();

            try
            {
                // G[NA
                ClearError(eventController.ErrorHandler, eventController.ViewData, eventController.ErrorPaths);

                // Validator, Converteȑ
                Initialize();

                // OsArWlXWbN̓f[^Zbg擾B
                BLogicParam blogicParam = Preprocess(eventController, executionResult);
                if (!string.IsNullOrEmpty(executionResult.ResultString))
                {
                    eventController.ReportExecuteCompleted(executionResult, null, false);
                    _isBusy = false;
                    return;
                }

                // BLogics(񓯊)
                _blogic = CreateBLogic(
                    eventController.BLogicName, eventController.BLogicResultTypeName, eventController.ViewData);
                _asyncOpe = AsyncOperationManager.CreateOperation(null);


                if (_log.IsDebugEnabled)
                {
                    _log.Debug(Properties.Resources.D_DO_EXECUTE_ASYNC);
                }

                _doExecuteAsyncDelegate.BeginInvoke(blogicParam, executionResult, null, null);
            }
            catch (Exception)
            {
                _isBusy = false;
                throw;
            }
        }

        /// <summary>
        /// rWlXWbNʃXbhŎsA񓯊܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <see cref="ExecuteAsync"/> \bhĂяo܂B
        /// rWlXWbNʃXbhŎsA񓯊܂B
        /// sI <see cref="ExecuteAsyncCompletedCallback"/> Ăяo܂B
        /// </para>
        /// <para>
        /// rWlXWbNŗOꍇ́AׂĂ̗O <see cref="ExecutionResult"/> Ɋi[A
        /// <see cref="ExecuteAsyncCompletedCallback"/> ĂяoďI܂B
        /// </para>
        /// </remarks>
        /// <param name="blogicParam">rWlXWbN <see cref="BLogicParam"/>B</param>
        /// <param name="executionResult">sʂi[ <see cref="ExecutionResult"/>B</param>
        /// <exception cref="TerasolunaException">
        /// rWlXWbN̖߂l <see cref="BLogicResult"/>  null QƂłB
        /// </exception>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes")]
        protected virtual void DoExecuteAsync(BLogicParam blogicParam, ExecutionResult executionResult)
        {
            BLogicResult blogicResult = null;
            Exception error = null;

            // rWlXWbNs
            if (_log.IsDebugEnabled)
            {
                _log.Debug(string.Format(Properties.Resources.D_BEGIN_WORKER_THREAD, Thread.CurrentThread.ManagedThreadId));
            }

            try
            {
                blogicResult = ExecuteBLogic(blogicParam);
            }
            catch (Exception e)
            {
                if (_log.IsWarnEnabled)
                {
                    _log.Warn(Properties.Resources.W_BLOGIC_EXECUTEASYNC_EXCEPTION, e);
                }
                error = e;
            }

            // rWlXWbŇʂnullArWlXWbNŗOĂȂꍇ
            if (blogicResult == null && error == null)
            {
                // rWlXWbNŗOĂȂꍇ̂݁ATerasolunaExceptionerrorɂ߂
                error = new TerasolunaException(Properties.Resources.E_BLOGIC_NULL_RESULT);
                if (_log.IsWarnEnabled)
                {
                    _log.Warn(Properties.Resources.W_BLOGIC_NULL_RESULT, error);
                }
            }

            bool cancelled = false;
            if (_blogic is ICancelable)
            {
                cancelled = ((ICancelable)_blogic).Cancelled;
            }

            if (_log.IsDebugEnabled)
            {
                _log.Debug(string.Format(Properties.Resources.D_END_WORKER_THREAD, Thread.CurrentThread.ManagedThreadId));
            }

            // R[obN\bȟĂяo
            BLogicCompletedEventArgs eceArgs =
                new BLogicCompletedEventArgs(executionResult, blogicResult, error, cancelled);
            _asyncOpe.PostOperationCompleted(_executeAsyncCompletedCallback, eceArgs);
        }

        /// <summary>
        /// 񓯊̎sɌĂяoR[obN\bhłB
        /// </summary>
        /// <remarks>
        /// <para>
        /// 񓯊̎sɌĂяoR[obN\bhłB
        /// rWlXWbNo <see cref="DataSet"/> 
        ///  <see cref="DataSet"/> ւ̕ϊsACxg𔭐܂B
        /// </para>
        /// <para>
        /// rWlXWbN̎sLZꂽꍇ́A
        /// <see cref="AsyncCompletedEventArgs.Cancelled"/>  true ɂ
        /// Cxg𔭐܂B
        /// </para>
        /// <para>
        /// rWlXWbNŗOꍇ́A<see cref="ExecuteCompletedEventArgs"/> ɔO 
        /// i[ĊCxg𔭐܂B
        /// </para>
        /// <para>
        /// rWlXWbNo <see cref="DataSet"/> 
        ///  <see cref="DataSet"/> ւ̕ϊŗOꍇ́A
        /// ̗O <see cref="ExecuteCompletedEventArgs"/> Ɋi[ĊCxg𔭐܂B
        /// </para>
        /// </remarks>
        /// <param name="obj">
        /// <see cref="DoExecuteAsync"/> \bhn <see cref="ExecuteCompletedEventArgs"/>B
        /// </param>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes")]
        protected virtual void ExecuteAsyncCompletedCallback(object obj)
        {
            if (_log.IsDebugEnabled)
            {
                _log.Debug(Properties.Resources.D_ASYNC_COMPLETED_CALLBACK);
            }

            ExecutionResult executionResult = null;
            BLogicCompletedEventArgs blogicArgs = (BLogicCompletedEventArgs)obj;
            ExecuteCompletedEventArgs executeArgs = new ExecuteCompletedEventArgs(
                blogicArgs.ExecutionResult, blogicArgs.Error, blogicArgs.Cancelled);
            Exception error = executeArgs.Error;
            
            try
            {
                // rWlXWbNł̏ɏIƂ
                if (!executeArgs.Cancelled && error == null)
                {
                    executionResult = executeArgs.ExecutionResult;
                    Postprocess(_eventController, executionResult, blogicArgs.BLogicResult);
                }
                _eventController.ReportExecuteCompleted(executionResult, error, executeArgs.Cancelled);
            }
            finally
            {
                _isBusy = false;
            }
        }

        /// <summary>
        /// 񓯊s̃rWlXWbNɃLZv܂B
        /// </summary>
        /// <remarks>
        /// 񓯊s̃rWlXWbN <see cref="ICancelable.Cancel"/> \bhs܂B
        /// <para>
        /// rWlXWbN񓯊ŎsłȂꍇ <see cref="ICancelable"/> ĂȂ
        /// ꍇ́A<see cref="InvalidOperationException"/> 𔭐܂B
        /// </para>
        /// </remarks>
        /// <exception cref="InvalidOperationException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">      
        /// <item>
        /// rWlXWbN񓯊ŎsĂ܂B
        /// </item>
        /// <item>
        /// rWlXWbN <see cref="ICancelable"/> Ă܂B
        /// </item>
        /// </list>
        /// </exception>
        public virtual void ExecuteAsyncCancel()
        {
            // 񓯊sĂȂꍇ
            if (!_isBusy || _blogic == null)
            {
                InvalidOperationException exception = new InvalidOperationException(
                    Properties.Resources.E_BLOGIC_NOT_EXECUTEASYNC_OPERATED);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            // rWlXWbNICancelableĂȂꍇ͗O
            if (!(_blogic is ICancelable))
            {
                InvalidOperationException exception = new InvalidOperationException(
                    Properties.Resources.E_BLOGIC_NOT_IMPLEMENTS_ICANCELABLE);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            ((ICancelable)_blogic).Cancel();
        }

        /// <summary>
        /// tH[̃G[nhs܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <see cref="Coordinator.EventController"/>  <see cref="TERASOLUNA.Fw.Client.EventController.ErrorHandler"/> ێĂƂA
        /// G[ɌĂяo܂B
        /// </para>
        /// <para>
        /// G[ӏ\L[ <see cref="Coordinator.EventController"/>  ErrorPaths ֊i[܂B
        /// </para>
        /// </remarks>
        /// <param name="errorHandler">G[ϏG[nhB</param>
        /// <param name="executionResult">sʂ̊i[ꂽ <see cref="ExecutionResult"/>B</param>
        /// <param name="viewData"> <see cref="DataSet"/>B</param>
        /// <param name="errorPaths">G[ӏ\L[̃XgB</param>
        protected virtual void HandleError(
            IErrorHandler errorHandler, ExecutionResult executionResult, DataSet viewData, IList<string> errorPaths)
        {
            if (errorHandler != null)
            {
                errorHandler.HandleError(executionResult.ResultString, executionResult.Errors, viewData);
            }

            foreach (MessageInfo error in executionResult.Errors)
            {
                ValidationMessageInfo validationMessage = error as ValidationMessageInfo;
                if (validationMessage != null)
                {
                    errorPaths.Add(validationMessage.ErrorPath);
                }
            }
        }

        /// <summary>
        /// tH[̃G[NAs܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <see cref="Coordinator.EventController"/>  <see cref="Client.EventController.ErrorHandler"/> ێĂƂA
        /// <see cref="Client.EventController.ErrorHandler"/>  <see cref="IErrorHandler.ClearError"/> s܂B
        /// </para>
        /// </remarks>
        /// <param name="errorHandler">G[ϏG[nhB</param>
        /// <param name="viewData"> <see cref="DataSet"/>B</param>
        /// <param name="errorPaths">G[ӏ\L[̃XgB</param>
        protected virtual void ClearError(IErrorHandler errorHandler, DataSet viewData, IList<string> errorPaths)
        {
            if (errorHandler != null)
            {
                errorHandler.ClearError(viewData);
            }
            errorPaths.Clear();
        }

        /// <summary>
        /// <see cref="IBLogic"/> s <see  cref="IProgressChangedEventInvoker.ProgressChanged"/> 
        /// <see cref="Client.EventController.ReportExecuteProgressChanged"/> ɈϏ܂B
        /// </summary>
        /// <param name="sender">Cxg̃\[XB</param>
        /// <param name="e">Cxg f[^i[Ă <see cref="ExecuteProgressChangedEventArgs"/>B</param>
        /// <exception cref="ArgumentNullException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// <paramref name="sender"/>  null QƂłB
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// <paramref name="e"/>  null QƂłB
        /// </description>
        /// </item>
        /// </list>
        /// </exception>
        protected virtual void DoExecuteProgressChanged(object sender, ExecuteProgressChangedEventArgs e)
        {
            if (sender == null)
            {
                ArgumentNullException exception = new ArgumentNullException("sender");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "sender"), exception);
                }
                throw exception;
            }

            if (e == null)
            {
                ArgumentNullException exception = new ArgumentNullException("e");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "e"), exception);
                }
                throw exception;
            }

            if (_asyncOpe == null)
            {
                // s
                _eventController.ReportExecuteProgressChanged(e.ProgressPercentage, e.Items);
            }
            else
            {
                // 񓯊s
                _asyncOpe.SynchronizationContext.Send(_executeAsyncProgressChangedCallback, e);
            }
        }

        /// <summary>
        /// is󋵃Cxg𔭐܂B
        /// </summary>
        /// <param name="obj">is󋵃Cxg <see cref="ExecuteProgressChangedEventArgs"/>B</param>
        protected virtual void ExecuteAsyncProgressChangedCallback(object obj)
        {
            ExecuteProgressChangedEventArgs e = (ExecuteProgressChangedEventArgs)obj;
            _eventController.ReportExecuteProgressChanged(e.ProgressPercentage, e.Items);
        }

    }

    /// <summary>
    /// rWlXWbNʃXbhŎsA񓯊fQ[głB
    /// </summary>
    /// <param name="blogicParam">rWlXWbNւ̓͂ƂȂ <see cref="BLogicParam"/>B</param>
    /// <param name="executionResult">sʂi[ <see cref="ExecutionResult"/>B</param>
    public delegate void DoExecuteAsyncDelegate(BLogicParam blogicParam, ExecutionResult executionResult);

}
