// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using TERASOLUNA.Fw.Common.Validation;

namespace TERASOLUNA.Fw.Client
{
    /// <summary>
    /// <see cref="EventController.CustomValidating"/> Cxg̃f[^񋟂܂B
    /// </summary>
    /// <remarks>
    /// Cxg@\񋟂JX^`FbNCxg (<see cref="EventController.CustomValidating"/>) 
    /// Cxgnh֓np^łB
    /// </remarks>
    public class CustomValidatingEventArgs : EventArgs
    {
        /// <summary>
        /// ،ʂ̃G[Xgێ <see cref="ValidationResult"/> łB
        /// </summary>
        private ValidationResult _validationResult = null;

        /// <summary>
        /// ،ʂ̃G[Xgێ <see cref="ValidationResult"/> 擾܂B
        /// </summary>
        /// <value>
        /// ،ʂ̃G[Xgێ <see cref="ValidationResult"/> B
        /// </value>
        public ValidationResult ValidationResult
        {
            get
            {
                return _validationResult;
            }
        }

        /// <summary>
        /// <see cref="CustomValidatingEventArgs"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="validationResult">
        /// Pڃ`FbNʂێ <see cref="ValidationResult"/> B
        /// </param>
        public CustomValidatingEventArgs(ValidationResult validationResult)
        {
            _validationResult = validationResult;
        }
    }
}
