// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using TERASOLUNA.Fw.Client.Communication;

namespace TERASOLUNA.Fw.ClientUT.BLogic.CommunicateBLogicBaseTestData
{
    /// <summary>
    /// 正常値を返却するスタブ。
    /// </summary>
    public class CommunicateBLogicBase_CommunicatorStub01: ICommunicator<DataSet>
    {

        public bool _calledFlag = false; 

        /// <summary>
        /// イベント。
        /// </summary>
        public event TERASOLUNA.Fw.Client.ExecuteProgressChangedEventHandler ProgressChanged;

        public CommunicationResult Communicate(DataSet paramData, IDictionary<string, string> requestHeaders)
        {
            return null;
        }

        /// <summary>
        /// Addressのgetter/setter。
        /// </summary>
        public string Address
        {
            get
            {
                return null;
            }
            set
            {
            }
        }

        /// <summary>
        /// RequestTimeoutのgetter/setter。
        /// </summary>
        public int RequestTimeout
        {
            get
            {
                return 0;
            }
            set
            {
            }
        }

        /// <summary>
        /// Cancelledのgetter/setter。
        /// </summary>
        public bool Cancelled
        {
            get
            {
                return false;
            }
            set
            {
            }
        }

        public void Cancel()
        {
            _calledFlag = true;
        }
    }
}
