// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Client.Communication;
using System.Data;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Validation;

namespace TERASOLUNA.Fw.ClientUT.BLogic.MultipartUploadBLogicData
{
    public class MultipartUploadBLogic_MultipartUploadCommunicatorStub04<TResult> : MultipartUploadCommunicator<TResult> where TResult : DataSet, new()
    {
        /// <summary>
        /// Communicate \bhsꂽꍇA paramData ێtB[hB
        /// </summary>
        public IList<MultipartElement> _paramData = null;

        /// <summary>
        /// Communicate \bhsꂽꍇA requestHeaders ێtB[hB
        /// </summary>
        public IDictionary<string, string> _requestHeaders = null;

        /// <summary>
        /// Communicate \bhsꂽꍇA߂l ResultData ɐݒ肷CX^XB
        /// </summary>
        public TResult _result = new TResult();

        /// <summary>
        /// <see cref="ConverterFactory"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public MultipartUploadBLogic_MultipartUploadCommunicatorStub04()
        {
        }

        /// <summary>
        /// K ErrorType "serverValidateException"  ServerException X[B
        /// </summary>
        /// <param name="paramData"></param>
        /// <param name="requestHeaders"></param>
        /// <returns></returns>
        public override CommunicationResult Communicate(IList<MultipartElement> paramData, IDictionary<string, string> requestHeaders)
        {
            _paramData = paramData;
            _requestHeaders = requestHeaders;

            ServerException exception = new ServerException("MultipartUploadException", "serverValidateException");
            exception.Errors.Add(new MessageInfo("key01", "value01"));
            throw exception;
        }
    }
}
