// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Client;
using System.Data;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.ClientUT
{
    /// <summary>
    ///TERASOLUNA.Fw.Client.PreprocessedFailedEventArgs のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Client.PreprocessedFailedEventArgs 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class PreprocessedFailedEventArgsTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        ///　BLogicParamData のテスト
        ///</summary>
        /// <remarks>
        /// 想定通りの値の取得ができることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void BLogicParamDataTest01()
        {
            // 準備
            PreprocessedFailedEventArgs target = new PreprocessedFailedEventArgs(null, null);
            DataSet expectedBlogicParamData = new DataSet();
            TERASOLUNA_Fw_Client_PreprocessedFailedEventArgsAccessor accessor = new TERASOLUNA_Fw_Client_PreprocessedFailedEventArgsAccessor(target);
            accessor._blogicParamData = expectedBlogicParamData;

            // 実施
            DataSet actualBlogicParamData = target.BLogicParamData;

            // 確認
            Assert.AreSame(expectedBlogicParamData, actualBlogicParamData);

            // ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PreprocessedFailedEventArgs), LogLevel.INFO));
        }

        /// <summary>
        ///ExecutionResult のテスト
        ///</summary>
        /// <remarks>
        /// 想定通りの値の取得ができることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ExecutionResultTest01()
        {
            // 準備
            PreprocessedFailedEventArgs target = new PreprocessedFailedEventArgs(null, null);
            ExecutionResult expectedExecutionResult = new ExecutionResult();
            TERASOLUNA_Fw_Client_PreprocessedFailedEventArgsAccessor accessor = new TERASOLUNA_Fw_Client_PreprocessedFailedEventArgsAccessor(target);
            accessor._executionResult = expectedExecutionResult;

            // 実施
            ExecutionResult actualExecutionResult = target.ExecutionResult;

            // 確認
            Assert.AreSame(expectedExecutionResult, actualExecutionResult);

            // ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PreprocessedFailedEventArgs), LogLevel.INFO));
        }

        /// <summary>
        ///PreprocessedFailedEventArgs (ExecutionResult, DataSet) のテスト
        ///</summary>
        /// <remarks>
        /// コンストラクタで値が正常に設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTest01()
        {
            // 準備
            ExecutionResult expectedExecutionResult = new ExecutionResult();
            DataSet expectedBlogicParamData = new DataSet();

            // 実施
            PreprocessedFailedEventArgs target = new PreprocessedFailedEventArgs(expectedExecutionResult, expectedBlogicParamData);

            // 確認
            TERASOLUNA_Fw_Client_PreprocessedFailedEventArgsAccessor accessor = new TERASOLUNA_Fw_Client_PreprocessedFailedEventArgsAccessor(target);
            Assert.AreSame(expectedExecutionResult, accessor._executionResult);
            Assert.AreSame(expectedBlogicParamData, accessor._blogicParamData);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PreprocessedFailedEventArgs), LogLevel.INFO));
        }

    }
}
