﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.CommonUT
{
    /// <summary>
    ///TERASOLUNA.Fw.Common.MessageInfo のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Common.MessageInfo 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class MessageInfoTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        /// Detail のテスト
        /// </summary>
        /// <remarks>
        /// 想定通りの値の取得・設定ができることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DetailTest01()
        {
            // 準備
            object expectedDetail = new Object();
            MessageInfo target = new MessageInfo("message");

            // 実施
            target.Detail = expectedDetail;
            object actualDetail = target.Detail;

            Assert.AreSame(expectedDetail, actualDetail);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(MessageInfo), LogLevel.INFO));
        }

        /// <summary>
        /// Key のテスト
        /// </summary>
        /// <remarks>
        /// 想定通りの値の取得・設定ができることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void KeyTest01()
        {
            // 準備
            string expectedKey = "TERASOLUNA";
            MessageInfo target = new MessageInfo("message");
            
            // 実施
            target.Key = expectedKey;
            string actualKey = target.Key;

            // 結果
            Assert.AreSame(expectedKey, actualKey);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(MessageInfo), LogLevel.INFO));
        }

        /// <summary>
        /// Message のテスト
        /// </summary>
        /// <remarks>
        /// 想定通りの値の取得・設定ができることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void MessageTest01()
        {
            // 準備
            string expectedMessage = "TERASOLUNA";
            MessageInfo target = new MessageInfo("message");

            // 実施
            target.Message = expectedMessage;
            string actualMessage = target.Message;

            // 結果
            Assert.AreSame(expectedMessage, actualMessage);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(MessageInfo), LogLevel.INFO));
        }

        /// <summary>
        /// MessageInfo(string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数の message が null の場合、
        /// 正常にインスタンスが生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringTest01()
        {
            // 準備
            string message = null;

            // 実施
            MessageInfo target = new MessageInfo(message);

            // 結果
            Assert.IsInstanceOfType(target, typeof(MessageInfo));
            TERASOLUNA_Fw_Common_MessageInfoAccessor accessor = 
                new TERASOLUNA_Fw_Common_MessageInfoAccessor(target);
            Assert.IsNull(accessor._message);
            Assert.IsNull(accessor._key);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(MessageInfo), LogLevel.INFO));
        }

        /// <summary>
        /// MessageInfo(string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数 message が空文字列の場合、
        /// 正常にインスタンスが生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringTest02()
        {
            // 準備
            string message = string.Empty;

            // 実施
            MessageInfo target = new MessageInfo(message);

            // 結果
            TERASOLUNA_Fw_Common_MessageInfoAccessor accessor = 
                new TERASOLUNA_Fw_Common_MessageInfoAccessor(target);
            Assert.AreEqual(string.Empty, accessor._message);
            Assert.IsNull(accessor._key);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(MessageInfo), LogLevel.INFO));
        }

        /// <summary>
        /// MessageInfo(string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数 message が null または空文字列でない場合、
        /// 正常にインスタンスが生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringTest03()
        {
            // 準備
            string message = "TERASOLUNA";

            // 実施
            MessageInfo target = new MessageInfo(message);

            // 結果
            TERASOLUNA_Fw_Common_MessageInfoAccessor accessor = 
                new TERASOLUNA_Fw_Common_MessageInfoAccessor(target);
            Assert.AreEqual(message, accessor._message);
            Assert.IsNull(accessor._key);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(MessageInfo), LogLevel.INFO));
        }

        /// <summary>
        /// MessageInfo(string, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数 key が null であり、引数 message が null である場合、
        /// 正常にインスタンスが生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringStringTest01()
        {
            // 準備
            string key = null;
            string message = null;

            // 実施
            MessageInfo target = new MessageInfo(key, message);

            // 結果
            TERASOLUNA_Fw_Common_MessageInfoAccessor accessor = 
                new TERASOLUNA_Fw_Common_MessageInfoAccessor(target);
            Assert.IsNull(accessor._key);
            Assert.IsNull(accessor._message);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(MessageInfo), LogLevel.INFO));
        }

        /// <summary>
        /// MessageInfo(string, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数 key が空文字列であり、引数 message が null である場合、
        /// 正常にインスタンスが生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringStringTest02()
        {
            // 準備
            string key = string.Empty;
            string message = null;

            // 実施
            MessageInfo target = new MessageInfo(key, message);

            // 結果
            TERASOLUNA_Fw_Common_MessageInfoAccessor accessor = 
                new TERASOLUNA_Fw_Common_MessageInfoAccessor(target);
            Assert.AreEqual(string.Empty, accessor._key);
            Assert.IsNull(accessor._message);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(MessageInfo), LogLevel.INFO));
        }

        /// <summary>
        /// MessageInfo(string, string) のテスト
        /// </summary>
        /// <remarks>
        /// 引数 key が null または空文字列でない文字列であり、引数 message が null である場合、
        /// 正常にインスタンスが生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringStringTest03()
        {
            // 準備
            string key = "TERASOLUNA";
            string message = null;

            // 実施
            MessageInfo target = new MessageInfo(key, message);

            // 結果
            TERASOLUNA_Fw_Common_MessageInfoAccessor accessor = new TERASOLUNA_Fw_Common_MessageInfoAccessor(target);
            Assert.AreEqual(key, accessor._key);
            Assert.IsNull(accessor._message);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(MessageInfo), LogLevel.INFO));
        }
    }
}
