// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Web.Configuration.ExceptionTransition
{
    /// <summary>
    /// exceptionTransition vf̃RNVi[\vf\܂B
    /// </summary>
    /// <remarks>
    /// <see cref="ExceptionTransitionCollection"/> ́AG[ʑJڐݒt@C exceptionTransition vf̃RNV\܂B 
    /// ڍׂɂĂ <see cref="ConfigurationElementCollection"/> QƂĂB
    /// </remarks>
    public class ExceptionTransitionCollection : ConfigurationElementCollection
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(ExceptionTransitionCollection));

        /// <summary>
        /// <see cref="ExceptionTransitionCollection"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public ExceptionTransitionCollection()
        {
        }

        /// <summary>
        /// <see cref="ExceptionTransitionCollection"/> ̌^擾܂B 
        /// </summary>
        /// <remarks>
        /// ̃RNV <see cref="ConfigurationElementCollectionType"/>  <seealso cref="ConfigurationElementCollectionType.BasicMap"/> łB
        /// </remarks>
        public override ConfigurationElementCollectionType CollectionType
        {
            get
            {
                return ConfigurationElementCollectionType.BasicMap;
            }
        }

        /// <summary>
        /// V exceptionTransition vf쐬܂B
        /// </summary>
        /// <returns>V exceptionTransition vfB</returns>
        /// <remarks>
        /// V <see cref="ExceptionTransitionElement"/> IuWFNg쐬܂B
        /// </remarks>
        protected override ConfigurationElement CreateNewElement()
        {
            return new ExceptionTransitionElement();
        }

        /// <summary>
        /// w肵CfbNXʒuɂ exceptionTransition vf擾܂B
        /// </summary>
        /// <param name="index">擾 <see cref="ExceptionTransitionElement"/> ̃CfbNXʒuB</param>
        /// <returns>w肵CfbNXʒuɂ <see cref="ExceptionTransitionElement"/> sB</returns>
        /// <remarks>
        /// <seealso cref="ConfigurationElementCollection.BaseGet(int)"/> \bhgpāA<see cref="ExceptionTransitionCollection"/>  <see cref="ExceptionTransitionElement"/> IuWFNg擾܂B
        /// </remarks>
        public ExceptionTransitionElement this[int index]
        {
            get
            {
                return (ExceptionTransitionElement)BaseGet(index);
            }
        }

        /// <summary>
        /// w肵L[ exceptionTransition vf擾܂B
        /// </summary>
        /// <param name="exceptionType">擾 exceptionTransition vf̃L[BONX\B</param>
        /// <returns>w肵L[ <see cref="ExceptionTransitionElement"/>BȊȌꍇ null QƁB</returns>
        /// <remarks>
        /// <seealso cref="ConfigurationElementCollection.BaseGet(object)"/> \bhgpāA<see cref="ExceptionTransitionCollection"/>  <see cref="ExceptionTransitionElement"/> IuWFNg擾܂B
        /// w肵L[ <see cref="ExceptionTransitionElement"/> IuWFNgRNVɑ݂ȂꍇAnull QƂԂ܂B
        /// </remarks>
        public virtual new ExceptionTransitionElement this[string exceptionType]
        {
            get
            {
                return (ExceptionTransitionElement)BaseGet(exceptionType);
            }
        }

        /// <summary>
        /// <see cref="ExceptionTransitionCollection"/> ̗vf擾܂B
        /// </summary>
        /// <value>
        /// <see cref="ExceptionTransitionCollection"/> ̗vfB
        /// </value>
        public virtual new int Count
        {
            get
            {
                return base.Count;
            }
        }

        /// <summary>
        /// G[ʑJڐݒt@Ĉ̗vf̃RNVʂ邽߂Ɏgp閼O擾܂B
        /// </summary>
        /// <value>
        /// RNVʂ邽߂Ɏgp閼OB
        /// </value>
        /// <remarks>
        /// RNVʂ邽߂Ɏgp閼ÓA "exceptionTransition" łB
        /// </remarks>
        protected override string ElementName
        {
            get
            {
                return "exceptionTransition";
            }
        }

        /// <summary>
        /// exceptionTransition vf̗vfL[擾܂B
        /// </summary>
        /// <param name="element">L[Ԃ <see cref="ExceptionTransitionElement"/> B</param>
        /// <returns>w肵 <see cref="ExceptionTransitionElement"/> ̃L[Ƃċ@\ <see cref="Object"/> B</returns>
        /// <exception cref="System.ArgumentNullException">
        /// <paramref name="element"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="element"/>  <see cref="ExceptionTransitionElement"/> ł͂܂B
        /// </exception>
        protected override Object GetElementKey(ConfigurationElement element)
        {
            if (element == null)
            {
                ArgumentNullException exception = new ArgumentNullException("element");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Web.Properties.Resources.E_NULL_ARGUMENT, "element"), exception);
                }
                throw exception;
            }
            ExceptionTransitionElement exTransElement = element as ExceptionTransitionElement;
            if (exTransElement == null)
            {
                string message = string.Format(Web.Properties.Resources.E_INVALID_TYPE, "element");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            return exTransElement.ExceptionType;
        }

        /// <summary>
        /// <see cref="ExceptionTransitionCollection"/>  exceptionTransition vfǉ܂B
        /// </summary>
        /// <param name="element">ǉ <see cref="ExceptionTransitionElement"/> B</param>
        /// <remarks>
        /// <seealso cref="BaseAdd(ConfigurationElement)"/> \bhgpāARNVɐV <see cref="ExceptionTransitionElement"/> ǉ܂B
        /// </remarks>
        public virtual void Add(ExceptionTransitionElement element)
        {
            BaseAdd(element);
        }

        /// <summary>
        /// <see cref="ExceptionTransitionCollection"/>  exceptionTransition vfǉ܂B
        /// </summary>
        /// <param name="element">ǉ <see cref="ExceptionTransitionElement"/> B</param>
        /// <remarks>
        /// w肵 <paramref name="element"/>  exceptionTransition vfRNVɊɑ݂ꍇAO͔܂B
        /// </remarks>
        protected override void BaseAdd(ConfigurationElement element)
        {
            BaseAdd(element, false);
        }

        /// <summary>
        /// <see cref="ExceptionTransitionCollection"/> IuWFNgǂݎpǂl擾܂B 
        /// </summary>
        /// <returns>
        /// <see cref="ExceptionTransitionCollection"/> IuWFNgǂݎp̏ꍇ true BȊȌꍇ false B
        /// </returns>
        /// <remarks>
        /// <see cref="ExceptionTransitionCollection"/> IuWFNg͓ǂݎpł͂܂B
        /// </remarks>
        public override bool IsReadOnly()
        {
            return false;
        }
    }
}