// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Web.Configuration.Page
{
    /// <summary>
    /// page vf̃RNVi[\vf\܂B
    /// </summary>
    /// <remarks>
    /// <see cref="PagesCollection"/> ́Ay[Wݒt@C page vf̃RNV\܂B 
    /// ڍׂɂĂ <see cref="ConfigurationElementCollection"/> QƂĂB
    /// </remarks>
    public class PagesCollection : ConfigurationElementCollection
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(PagesCollection));

        /// <summary>
        /// page vf̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒ĺA "page" łB
        /// </remarks>
        private const string PAGE_ELEMENT_NAME = "page";

        /// <summary>
        /// <see cref="PagesCollection"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public PagesCollection()
        {
        }

        /// <summary>
        /// <see cref="PagesCollection"/> ̌^擾܂B 
        /// </summary>
        /// <remarks>
        /// ̃RNV <see cref="ConfigurationElementCollectionType"/>  <seealso cref="ConfigurationElementCollectionType.BasicMap"/> łB
        /// </remarks>
        public override ConfigurationElementCollectionType CollectionType
        {
            get
            {
                return ConfigurationElementCollectionType.BasicMap;
            }
        }

        /// <summary>
        /// V page vf쐬܂B
        /// </summary>
        /// <returns>V page vfB</returns>
        /// <remarks>
        /// V <see cref="PageElement"/> IuWFNg쐬܂B
        /// </remarks>
        protected override ConfigurationElement CreateNewElement()
        {
            return new PageElement();
        }

        /// <summary>
        /// w肵CfbNXʒuɂ page vf擾܂B
        /// </summary>
        /// <param name="index">擾 <see cref="PageElement"/> ̃CfbNXʒuB</param>
        /// <returns>w肵CfbNXʒuɂ <see cref="PageElement"/> B</returns>
        /// <remarks>
        /// <seealso cref="ConfigurationElementCollection.BaseGet(int)"/> \bhgpāA<see cref="PagesCollection"/>  <see cref="PageElement"/> IuWFNg擾܂B
        /// </remarks>
        public PageElement this[int index]
        {
            get
            {
                return (PageElement)BaseGet(index);
            }
        }

        /// <summary>
        /// w肵L[ page vf擾܂B
        /// </summary>
        /// <param name="name">擾 page vf̃L[B</param>
        /// <returns>w肵L[ <see cref="PageElement"/>BȊȌꍇ null QƁB</returns>
        /// <remarks>
        /// <seealso cref="ConfigurationElementCollection.BaseGet(object)"/> \bhgpāA<see cref="PagesCollection"/>  <see cref="PageElement"/> IuWFNg擾܂B
        /// w肵L[ <see cref="PageElement"/> IuWFNgRNVɑ݂ȂꍇAnull QƂԂ܂B
        /// </remarks>
        public virtual new PageElement this[string name]
        {
            get
            {
                return (PageElement)BaseGet(name);
            }
        }

        /// <summary>
        /// <see cref="PagesCollection"/> ̗vf擾܂B
        /// </summary>
        /// <value>
        /// <see cref="PagesCollection"/> ̗vfB
        /// </value>
        public virtual new int Count
        {
            get
            {
                return base.Count;
            }
        }

        /// <summary>
        /// y[Wݒt@Ĉ̗vf̃RNVʂ邽߂Ɏgp閼O擾܂B
        /// </summary>
        /// <value>
        /// RNVʂ邽߂Ɏgp閼OB
        /// </value>
        /// <remarks>
        /// RNVʂ邽߂Ɏgp閼ÓA "page" łB
        /// </remarks>
        protected override string ElementName
        {
            get
            {
                return PAGE_ELEMENT_NAME;
            }
        }

        /// <summary>
        /// page vf̗vfL[擾܂B
        /// </summary>
        /// <param name="element">L[Ԃ <see cref="PageElement"/> B</param>
        /// <returns>w肵 <see cref="PageElement"/> ̃L[Ƃċ@\ <see cref="Object"/> B</returns>
        /// <remarks>ɂȂB</remarks>
        /// <exception cref="System.ArgumentNullException"><paramref name="element"/>  null ̏ꍇB</exception>
        /// <exception cref="System.ArgumentException"><paramref name="element"/>  <see cref="PageElement"/> ł͂ȂꍇB</exception>
        protected override Object GetElementKey(ConfigurationElement element)
        {
            if (element == null)
            {
                ArgumentNullException exception = new ArgumentNullException("element");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Web.Properties.Resources.E_NULL_ARGUMENT, "element"), exception);
                }
                throw exception;
            }
            PageElement pageElement = element as PageElement;
            if (pageElement == null)
            {
                string message = string.Format(Web.Properties.Resources.E_INVALID_TYPE, "element");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            return pageElement.Name;
        }

        /// <summary>
        /// <see cref="PagesCollection"/>  page vfǉ܂B
        /// </summary>
        /// <param name="page">ǉ <see cref="PageElement"/> B</param>
        /// <remarks>
        /// <seealso cref="ConfigurationElementCollection.BaseAdd(ConfigurationElement)"/> \bhgpāARNVɐV <see cref="PageElement"/> ǉ܂B
        /// </remarks>
        public virtual void Add(PageElement page)
        {
            BaseAdd(page);
        }

        /// <summary>
        /// <see cref="PagesCollection"/>  page vfǉ܂B
        /// </summary>
        /// <param name="element">ǉ <see cref="PageElement"/> B</param>
        /// <remarks>
        /// w肵 <paramref name="element"/>  page vfRNVɊɑ݂ꍇAO͔܂B
        /// </remarks>
        protected override void BaseAdd(ConfigurationElement element)
        {
            BaseAdd(element, false);
        }

        /// <summary>
        /// <see cref="PagesCollection"/> IuWFNgǂݎpǂl擾܂B 
        /// </summary>
        /// <returns>
        /// <see cref="PagesCollection"/> IuWFNgǂݎp̏ꍇ true BȊȌꍇ false B
        /// </returns>
        /// <remarks>
        /// <see cref="PagesCollection"/> IuWFNg͓ǂݎpł͂܂B
        /// </remarks>
        public override bool IsReadOnly()
        {
            return false;
        }
    }
}
