// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.Configuration.Page;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Common;
namespace TERASOLUNA.Fw.WebUT.Configuration.Page
{
    /// <summary>
    /// TERASOLUNA.Fw.Common.Configuration.PageConfiguration のテスト クラスです。すべての
    /// TERASOLUNA.Fw.Common.Configuration.PageConfiguration 単体テストをここに含めます
    /// </summary>

    [TestClass()]
    public class PageConfigurationTest
    {

        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        /// CheckUnAvailablePage (string) のテスト
        /// </summary>
        /// <TestTarget>PageConfiguration</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>
        /// 正しい結果(False: preventDoubleSubmit="on")が取得できること
        /// </TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestCheckUnAvailablePage01()
        {

            string PagePath = "/XXX001.aspx";

            bool expected = false;
            bool actual;

            actual = PageConfiguration.CheckUnAvailablePage(PagePath);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// CheckUnAvailablePage (string) のテスト
        /// </summary>
        /// <TestTarget>PageConfiguration</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>
        /// 正しい結果(True: preventDoubleSubmit="off")が取得できること
        /// </TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestCheckUnAvailablePage02()
        {
            string PagePath = "/XXX005.aspx";

            bool expected = true;
            bool actual;

            actual = PageConfiguration.CheckUnAvailablePage(PagePath);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));

        }

        /// <summary>
        /// CheckUnAvailablePage (string) のテスト
        /// </summary>
        /// <TestTarget>PageConfiguration</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>
        /// 正しい結果(False)が取得できること 該当Pathなし：default(on)
        /// </TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestCheckUnAvailablePage03()
        {
            string PagePath = "/XXX099.aspx";

            bool expected = false;
            bool actual;

            actual = PageConfiguration.CheckUnAvailablePage(PagePath);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));

        }

        /// <summary>
        /// CheckUnAvailablePage (string) のテスト
        /// </summary>
        /// <TestTarget>PageConfiguration</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>
        /// 正しい結果(False)が取得できること該当属性指定なし：default(on)
        /// </TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestCheckUnAvailablePage04()
        {
            string PagePath = "/XXX002.aspx";

            bool expected = false;
            bool actual;

            actual = PageConfiguration.CheckUnAvailablePage(PagePath);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// CheckUnAvailablePage (string) のテスト
        /// </summary>
        /// <TestTarget>PageConfiguration</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestCheckUnAvailablePage05()
        {
            string PagePath = null;
            bool actual;

            try
            {
                actual = PageConfiguration.CheckUnAvailablePage(PagePath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("pagePath", e.ParamName);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(PageConfiguration), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "pagePath"));
        }

        /// <summary>
        /// CheckUnAvailablePage (string) のテスト
        /// </summary>
        /// <TestTarget>PageConfiguration</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>ArgumentExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestCheckUnAvailablePage06()
        {
            string PagePath = "";
            bool actual;

            try
            {
                actual = PageConfiguration.CheckUnAvailablePage(PagePath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // 成功
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual(MessageManager.GetMessage("E_EMPTY_STRING", "pagePath"), e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(PageConfiguration), typeof(ArgumentException), "E_EMPTY_STRING", "pagePath"));
        }
        /// <summary>
        ///IsCheckTokenEnabled (string) のテスト
        ///</summary>
        /// <TestTarget>IsCheckTokenEnabled (string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>trueが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestIsCheckTokenEnabled01()
        {
            string pagePath = "/XXX001.aspx";

            bool expected = true;
            bool actual;

            actual = PageConfiguration.IsCheckTokenEnabled(pagePath);

            Assert.AreEqual(expected, actual);
            
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
        }

        /// <summary>
        ///IsCheckTokenEnabled (string) のテスト
        ///</summary>
        /// <TestTarget>IsCheckTokenEnabled (string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>falseが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestIsCheckTokenEnabled02()
        {
            string pagePath = "/XXX005.aspx";

            bool expected = false;
            bool actual;

            actual = PageConfiguration.IsCheckTokenEnabled(pagePath);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
        }

        /// <summary>
        ///IsCheckTokenEnabled (string) のテスト
        ///</summary>
        /// <TestTarget>IsCheckTokenEnabled (string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>falseが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestIsCheckTokenEnabled03()
        {
            string pagePath = "/XXX099.aspx";

            bool expected = true;
            bool actual;

            actual = PageConfiguration.IsCheckTokenEnabled(pagePath);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
        }

        /// <summary>
        ///IsCheckTokenEnabled (string) のテスト
        ///</summary>
        /// <TestTarget>IsCheckTokenEnabled (string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>trueが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestIsCheckTokenEnabled04()
        {
            string pagePath = "/XXX004.aspx";

            bool expected = true;
            bool actual;

            actual = PageConfiguration.IsCheckTokenEnabled(pagePath);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
        }

        /// <summary>
        ///IsCheckTokenEnabled (string) のテスト
        ///</summary>
        /// <TestTarget>IsCheckTokenEnabled (string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestIsCheckTokenEnabled05()
        {
            string pagePath = null;
            bool actual;

            try
            {
                actual = PageConfiguration.IsCheckTokenEnabled(pagePath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("pagePath", e.ParamName);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(PageConfiguration), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "pagePath"));
        }

        /// <summary>
        ///IsCheckTokenEnabled (string) のテスト
        ///</summary>
        /// <TestTarget>IsCheckTokenEnabled (string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>ArgumentExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestIsCheckTokenEnabled06()
        {
            string pagePath = "";
            bool actual;

            try
            {
                actual = PageConfiguration.IsCheckTokenEnabled(pagePath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // 成功
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual(MessageManager.GetMessage("E_EMPTY_STRING", "pagePath"), e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(PageConfiguration), typeof(ArgumentException), "E_EMPTY_STRING", "pagePath"));
        }

        /// <summary>
        ///IsSetTokenEnabled (string) のテスト
        ///</summary>
        /// <TestTarget>IsSetTokenEnabled (string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>trueが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestIsSetTokenEnabled01()
        {
            string pagePath = "/XXX001.aspx";

            bool expected = true;
            bool actual;

            actual = PageConfiguration.IsSetTokenEnabled(pagePath);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
        }

        /// <summary>
        ///IsSetTokenEnabled (string) のテスト
        ///</summary>
        /// <TestTarget>IsSetTokenEnabled (string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>falseが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestIsSetTokenEnabled02()
        {
            string pagePath = "/XXX005.aspx";

            bool expected = false;
            bool actual;

            actual = PageConfiguration.IsSetTokenEnabled(pagePath);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
        }

        /// <summary>
        ///IsSetTokenEnabled (string) のテスト
        ///</summary>
        /// <TestTarget>IsSetTokenEnabled (string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>falseが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestIsSetTokenEnabled03()
        {
            string pagePath = "/XXX099.aspx";

            bool expected = true;
            bool actual;

            actual = PageConfiguration.IsSetTokenEnabled(pagePath);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
        }

        /// <summary>
        ///IsSetTokenEnabled (string) のテスト
        ///</summary>
        /// <TestTarget>IsSetTokenEnabled (string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>trueが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestIsSetTokenEnabled04()
        {
            string pagePath = "/XXX004.aspx";

            bool expected = true;
            bool actual;

            actual = PageConfiguration.IsSetTokenEnabled(pagePath);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
        }

        /// <summary>
        ///IsSetTokenEnabled (string) のテスト
        ///</summary>
        /// <TestTarget>IsSetTokenEnabled (string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestIsSetTokenEnabled05()
        {
            string pagePath = null;
            bool actual;

            try
            {
                actual = PageConfiguration.IsSetTokenEnabled(pagePath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("pagePath", e.ParamName);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(PageConfiguration), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "pagePath"));
        }

        /// <summary>
        ///IsSetTokenEnabled (string) のテスト
        ///</summary>
        /// <TestTarget>IsSetTokenEnabled (string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>ArgumentExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestIsSetTokenEnabled06()
        {
            string pagePath = "";
            bool actual;

            try
            {
                actual = PageConfiguration.IsSetTokenEnabled(pagePath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // 成功
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual(MessageManager.GetMessage("E_EMPTY_STRING", "pagePath"), e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(PageConfiguration), typeof(ArgumentException), "E_EMPTY_STRING", "pagePath"));
        }


        /// <summary>
        /// GetPageID (string) のテスト
        ///</summary>
        /// <TestTarget>GetPageID(string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>識別子に対応するpageIDが取得できること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestGetPageID01()
        {
            string pagePath = "/XXX001.aspx";
            string expected = "XXX_001";
            string actual;

            actual = PageConfiguration.GetPageID(pagePath);
            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// GetPageID (string) のテスト
        ///</summary>
        /// <TestTarget>GetPageID(string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>nullが取得できること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestGetPageID02()
        {
            string pagePath = "/XXXXXX.aspx";
            string expected = null;
            string actual;

            actual = PageConfiguration.GetPageID(pagePath);
            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// GetPageID (string) のテスト
        /// </summary>
        /// <TestTarget>GetPageID(string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestGetPageID03()
        {
            string pagePath = null;
            string actual;

            try
            {
                actual = PageConfiguration.GetPageID(pagePath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("pagePath", e.ParamName);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(PageConfiguration), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "pagePath"));
        }

        /// <summary>
        /// GetPageID (string) のテスト
        /// </summary>
        /// <TestTarget>GetPageID(string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>ArgumentExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestGetPageID04()
        {
            string pagePath = "";
            string actual;

            try
            {
                actual = PageConfiguration.GetPageID(pagePath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // 成功
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual(MessageManager.GetMessage("E_EMPTY_STRING", "pagePath"), e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(PageConfiguration), typeof(ArgumentException), "E_EMPTY_STRING", "pagePath"));
        }

        /// <summary>
        /// GetPath (string) のテスト
        ///</summary>
        /// <TestTarget>GetPath(string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>識別子に対応するpagePathが取得できること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestGetPath01()
        {
            string pageID = "XXX_001";
            string expected = "/XXX001.aspx";
            string actual;

            actual = PageConfiguration.GetPath(pageID);
            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// GetPath (string) のテスト
        ///</summary>
        /// <TestTarget>GetPath(string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>nullが取得できること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestGetPath02()
        {
            string pageID = "XXX_XXX";
            string expected = null;
            string actual;

            actual = PageConfiguration.GetPath(pageID);
            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// GetPath (string) のテスト
        /// </summary>
        /// <TestTarget>GetPath(string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestGetPath03()
        {
            string pageID = null;
            string actual;

            try
            {
                actual = PageConfiguration.GetPath(pageID);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("pageID", e.ParamName);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(PageConfiguration), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "pageID"));
        }

        /// <summary>
        /// GetPath (string) のテスト
        /// </summary>
        /// <TestTarget>GetPath(string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>ArgumentExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestGetPath04()
        {
            string pageID = "";
            string actual;

            try
            {
                actual = PageConfiguration.GetPath(pageID);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // 成功
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual(MessageManager.GetMessage("E_EMPTY_STRING", "pageID"), e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(PageConfiguration), typeof(ArgumentException), "E_EMPTY_STRING", "pageID"));

        }
        /// <summary>
        ///IsUpdateTokenEnabled (string) のテスト
        ///</summary>
        /// <TestTarget>IsUpdateTokenEnabled (string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>trueが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestIsUpdateTokenEnabled01()
        {
            string pagePath = "/XXX001.aspx";

            bool expected = true;
            bool actual;

            actual = PageConfiguration.IsUpdateTokenEnabled(pagePath);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
        }

        /// <summary>
        ///IsUpdateTokenEnabled (string) のテスト
        ///</summary>
        /// <TestTarget>IsUpdateTokenEnabled (string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>falseが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestIsUpdateTokenEnabled02()
        {
            string pagePath = "/XXX005.aspx";

            bool expected = false;
            bool actual;

            actual = PageConfiguration.IsUpdateTokenEnabled(pagePath);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
        }

        /// <summary>
        ///IsUpdateTokenEnabled (string) のテスト
        ///</summary>
        /// <TestTarget>IsUpdateTokenEnabled (string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>falseが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestIsUpdateTokenEnabled03()
        {
            string pagePath = "/XXX099.aspx";

            bool expected = true;
            bool actual;

            actual = PageConfiguration.IsUpdateTokenEnabled(pagePath);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
        }

        /// <summary>
        ///IsUpdateTokenEnabled (string) のテスト
        ///</summary>
        /// <TestTarget>IsUpdateTokenEnabled (string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>trueが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestIsUpdateTokenEnabled04()
        {
            string pagePath = "/XXX004.aspx";

            bool expected = true;
            bool actual;

            actual = PageConfiguration.IsUpdateTokenEnabled(pagePath);

            Assert.AreEqual(expected, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
        }

        /// <summary>
        ///IsUpdateTokenEnabled (string) のテスト
        ///</summary>
        /// <TestTarget>IsUpdateTokenEnabled (string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestIsUpdateTokenEnabled05()
        {
            string pagePath = null;
            bool actual;

            try
            {
                actual = PageConfiguration.IsUpdateTokenEnabled(pagePath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("pagePath", e.ParamName);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(PageConfiguration), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "pagePath"));
        }

        /// <summary>
        ///IsUpdateTokenEnabled (string) のテスト
        ///</summary>
        /// <TestTarget>IsUpdateTokenEnabled (string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>ArgumentExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal01.config")]
        [DeploymentItem(@"Configuration\Page\TestItem_PageExternal02.config")]
        [DeploymentItem(@"Configuration\ExceptionTransition\TestItem_PageExternalExTran.config")]
        public void TestIsUpdateTokenEnabled06()
        {
            string pagePath = "";
            bool actual;

            try
            {
                actual = PageConfiguration.IsUpdateTokenEnabled(pagePath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // 成功
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual(MessageManager.GetMessage("E_EMPTY_STRING", "pagePath"), e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(PageConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(PageConfiguration), typeof(ArgumentException), "E_EMPTY_STRING", "pagePath"));
        }
    }
}
