/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.commonj.init;

import commonj.work.Work;
import commonj.work.WorkItem;
import commonj.work.WorkListener;
import commonj.work.WorkManager;
import jp.terasoluna.fw.batch.commonj.init.JobExecutor;
import jp.terasoluna.fw.batch.commonj.init.JobStarter;
import jp.terasoluna.fw.batch.commonj.listener.WorkMapListener;
import jp.terasoluna.fw.batch.core.InitializeException;
import jp.terasoluna.fw.batch.init.JobRequestInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobStarterImpl
implements JobStarter {
    private static final Log log = LogFactory.getLog(JobStarterImpl.class);
    private static final int SCHDULE_SUCCESS = 0;
    private static final int SCHDULE_ERROR = -1;
    private WorkManager workManager = null;
    private WorkMapListener workListener = null;

    public int execute(String jobId, String beanFileName, String[] args) {
        if (this.workManager == null) {
            throw new InitializeException("WorkManager is required.");
        }
        if (this.workListener == null) {
            throw new InitializeException("WorkListener is required.");
        }
        try {
            String[] newArgs = new String[args.length + 2];
            newArgs[0] = jobId;
            newArgs[1] = beanFileName;
            System.arraycopy(args, 0, newArgs, 2, args.length);
            JobRequestInfo jobInfo = new JobRequestInfo(newArgs);
            jobInfo.init();
            JobExecutor jobExecutor = new JobExecutor();
            jobExecutor.setJobInfo(jobInfo);
            WorkItem workItem = this.workManager.schedule((Work)jobExecutor, (WorkListener)this.workListener);
            this.workListener.addWork(workItem, jobExecutor);
        }
        catch (Throwable throwable) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Critical Error!! JobID: ");
            logStr.append(jobId);
            logStr.append(" ");
            logStr.append(throwable.getMessage());
            log.error((Object)logStr.toString(), throwable);
            return -1;
        }
        return 0;
    }

    public void setWorkListener(WorkMapListener workListener) {
        this.workListener = workListener;
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }
}

