/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.util.ArrayList;
import java.util.Map;
import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.standard.AbstractFileLineIterator;
import jp.terasoluna.fw.file.dao.standard.ColumnParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableFileLineIterator<T>
extends AbstractFileLineIterator<T> {
    private char delimiter = (char)44;
    private char encloseChar = '\u0000';

    public VariableFileLineIterator(String fileName, Class<T> clazz, Map<String, ColumnParser> columnParserMap) {
        super(fileName, clazz, columnParserMap);
        FileFormat fileFormat = clazz.getAnnotation(FileFormat.class);
        if (fileFormat.delimiter() == '\u0000') {
            throw new FileException("Delimiter can not use '\\u0000'.", new IllegalStateException(), fileName);
        }
        this.setEncloseChar(fileFormat.encloseChar());
        this.setDelimiter(fileFormat.delimiter());
        super.init();
    }

    @Override
    protected String[] separateColumns(String fileLineString) {
        if (fileLineString == null || "".equals(fileLineString)) {
            return new String[0];
        }
        StringBuilder columnBuilder = new StringBuilder();
        char previousChar = '\u0000';
        ArrayList<String> columnList = new ArrayList<String>();
        boolean isEnclosed = true;
        boolean isEscaped = false;
        if (this.encloseChar == '\u0000') {
            return fileLineString.split(Character.toString(this.delimiter), -1);
        }
        for (char currentChar : fileLineString.toCharArray()) {
            if (previousChar == '\u0000') {
                previousChar = currentChar;
            }
            if (previousChar == this.encloseChar) {
                if (isEnclosed) {
                    if (currentChar != this.encloseChar) continue;
                    isEnclosed = false;
                    continue;
                }
                if (currentChar == this.encloseChar) {
                    if (isEscaped) {
                        columnBuilder.append(currentChar);
                        isEscaped = false;
                        continue;
                    }
                    isEscaped = true;
                    continue;
                }
                if (currentChar == this.delimiter) {
                    if (isEscaped) {
                        columnList.add(columnBuilder.toString());
                        previousChar = '\u0000';
                        columnBuilder.delete(0, columnBuilder.length());
                        isEnclosed = true;
                        isEscaped = false;
                        continue;
                    }
                    columnBuilder.append(currentChar);
                    isEscaped = false;
                    continue;
                }
                columnBuilder.append(currentChar);
                continue;
            }
            if (currentChar != this.delimiter) {
                columnBuilder.append(currentChar);
                continue;
            }
            columnList.add(columnBuilder.toString());
            previousChar = '\u0000';
            columnBuilder.delete(0, columnBuilder.length());
        }
        columnList.add(columnBuilder.toString());
        return columnList.toArray(new String[columnList.size()]);
    }

    @Override
    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public char getEncloseChar() {
        return this.encloseChar;
    }

    public void setEncloseChar(char encloseChar) {
        this.encloseChar = encloseChar;
    }
}

