/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.util;

import java.lang.reflect.InvocationTargetException;
import jp.terasoluna.fw.util.PropertyAccessException;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;

public final class BeanUtil {
    public static void setBeanProperty(Object bean, String property, Object value) throws PropertyAccessException {
        try {
            PropertyUtils.setProperty((Object)bean, (String)property, (Object)value);
        }
        catch (IllegalArgumentException e) {
            throw new PropertyAccessException(e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException(e);
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            throw new PropertyAccessException(e);
        }
    }

    public static Object getBeanProperty(Object bean, String property) throws PropertyAccessException {
        Object value = null;
        try {
            value = PropertyUtils.getProperty((Object)bean, (String)property);
        }
        catch (IllegalArgumentException e) {
            throw new PropertyAccessException(e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException(e);
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            throw new PropertyAccessException(e);
        }
        return value;
    }

    public static Class getBeanPropertyType(Object bean, String property) throws PropertyAccessException {
        try {
            Class type = null;
            if (bean instanceof DynaBean) {
                DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(property);
                if (descriptor != null) {
                    type = descriptor.getType();
                }
            } else {
                type = PropertyUtils.getPropertyType((Object)bean, (String)property);
            }
            return type;
        }
        catch (IllegalArgumentException e) {
            throw new PropertyAccessException(e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException(e);
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(e);
        }
        catch (NoSuchMethodException e) {
            throw new PropertyAccessException(e);
        }
    }
}

