/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.controlbreak;

import java.util.List;

import jp.terasoluna.fw.batch.core.InitializeException;
import jp.terasoluna.fw.batch.openapi.ControlBreakHandler;
import jp.terasoluna.fw.batch.openapi.JobContext;

/**
 * <P>Rg[uCNL[`B</P>
 * <P>[U`Rg[uCÑuCNL[i[NXB</P>
 * <P>Rg[uCNL[Xg̓`NRg[uCNL[Xg
 *  ͈͂𒴂邱Ƃ͂łȂB</P>
 * <P>gXRg[uCNL[Xg̓`NRg[uCNL[
 * Xg ܂ޒ`ɂKvB</P>
 * 
 */
public class ControlBreakDef {

    /**
     * Rg[uCŃuuCNL[AnhvXgB
     * iRg[uCŃ͈Fj
     */
    private List<ControlBreakDefItem> controlBreakDefItemList = null;

    /**
     * `NRg[uCŃuuCNL[AnhvB
     * iRg[uCŃ͈Fj
     */
    private ControlBreakDefItem chunkControlBreakDefItem = null;

    /**
     * gX`NRg[uCŃuuCNL[AnhvXgB
     * iRg[uCŃ͈Fj
     */
    private List<ControlBreakDefItem> transChunkControlBreakDefItemList = null;

    /**
     * <P>B</P>
     * <P>uCNL[̐ݒe`FbNB</P>
     * <P>Rg[uCNL[Xg`NRg[uCNL[Xg
     * ܂߂ĂȂꍇ<code>InitializeException</code>𔭐𒆒f
     * B</P>
     * <P>`NRg[uCNL[Xg̒`ꍇA 
     * `bNRg[uCNL[Xg`NRg[uCNL[
     * Xg܂߂ĂȂꍇ<code>InitializeException</code>𔭐
     * fB</P>
     */
    public void init() {
        
        List breakKeyList = null;
        
        //y`NRg[uCNL[z̐ݒ肪A
        //y`NRg[uCNnhz̐ݒ肪ꍇ
        //ygXRg[uCNL[z͐ݒłȂ
        if (chunkControlBreakDefItem == null
                || (chunkControlBreakDefItem.getBreakKey().size() == 0 
                && chunkControlBreakDefItem.getControlBreakHandler() == null)) {
            if (transChunkControlBreakDefItemList != null
                    && transChunkControlBreakDefItemList.size() != 0) {
                throw new InitializeException(
                        "TransChunkControlBreakDefItemList setup of "
                        + "ChunkControlBreakDefItem is required to set up "
                        + "TransChunkControlBreakDefItemList.");
            }
        } else {
            breakKeyList = chunkControlBreakDefItem.getBreakKey();
        }

        // y`NRg[uCNL[zɐݒ肳ĂȂL[ygX
        //  Rg[uCNL[zɐݒ肷邱Ƃ͂łȂB
        //  gXRg[uCNL[̐ݒ͕܊֌WłKvB
        for (int i = 0; breakKeyList != null
                && transChunkControlBreakDefItemList != null
                && i < transChunkControlBreakDefItemList.size(); i++) {
            List checkBreakKeyList = transChunkControlBreakDefItemList.get(i)
                    .getBreakKey();

            List nextBreakKeyList = null;
            if (i + 1 < transChunkControlBreakDefItemList.size()) {
                nextBreakKeyList = transChunkControlBreakDefItemList.get(i + 1)
                        .getBreakKey();
            }

            for (int k = 0; k < checkBreakKeyList.size(); k++) {
                if (k >= breakKeyList.size()
                        || !checkBreakKeyList.get(k)
                                .equals(breakKeyList.get(k))) {
                    throw new InitializeException(
                            "It is necessary to define TransChunkControlBreak"
                            + "DefItemList within the limits of ChunkControl"
                            + "BreakDefItem");
                }
            }

            for (int k = 0; nextBreakKeyList != null
                    && k < nextBreakKeyList.size(); k++) {
                if (k >= checkBreakKeyList.size()) {
                    throw new InitializeException(
                            "A transChunkControlBreakDefItemList needs to"
                            + " define it as becoming the break of a higher "
                            + "rank from a low-ranking break.");
                }
                if (!checkBreakKeyList.get(k).equals(nextBreakKeyList.get(k))) {
                    throw new InitializeException(
                            "A setup of a BreakKey needs to be an inclusive "
                            + "relation.");
                }
            }

            // ̃uCNL[2ȏRg[`Ă邩`FbN
            if (nextBreakKeyList != null
                    && checkBreakKeyList.size() == nextBreakKeyList.size()) {
                int sameCount = 0;
                for (int m = 0; m < checkBreakKeyList.size(); m++) {
                    for (int n = 0; n < nextBreakKeyList.size(); n++) {
                        if (checkBreakKeyList.get(m).equals(
                                nextBreakKeyList.get(n))) {
                            sameCount++;
                            break;
                        }
                    }
                }
                if (checkBreakKeyList.size() == sameCount) {
                    throw new InitializeException(
                            "Two or more TransChunkControlBreak cannot"
                            + " be defined as the same Break key.");
                }
            }
        }

        // yRg[uCNL[źy`NRg[uCNL[z
        //  ܂L[XgłKvB
        for (int i = 0; breakKeyList != null 
                && controlBreakDefItemList != null
                && i < controlBreakDefItemList.size(); i++) {
            List checkBreakKeyList = controlBreakDefItemList.get(i)
                    .getBreakKey();
            for (int k = 0; k < breakKeyList.size(); k++) {
                if (k >= checkBreakKeyList.size()
                        || !checkBreakKeyList.get(k)
                                .equals(breakKeyList.get(k))) {
                    throw new InitializeException(
                            "It is necessary to define ChunkControl"
                            + "BreakDefItem within the limits of Control"
                            + "BreakDefItemList");
                }
            }
        }

        // Rg[uCNL[̐ݒ͕܊֌WłKvB
        for (int i = 0; controlBreakDefItemList != null
                && i < controlBreakDefItemList.size(); i++) {
            List checkBreakKeyList = controlBreakDefItemList.get(i)
                    .getBreakKey();
            List nextBreakKeyList = null;
            if (i + 1 < controlBreakDefItemList.size()) {
                nextBreakKeyList = controlBreakDefItemList.get(i + 1)
                        .getBreakKey();
            }

            for (int k = 0; nextBreakKeyList != null
                    && k < nextBreakKeyList.size(); k++) {
                if (k >= checkBreakKeyList.size()) {
                    throw new InitializeException(
                            "A controlBreakDefItemList needs to define"
                            + " it as becoming the break of a higher rank"
                            + " from a low-ranking break.");
                }
                if (!checkBreakKeyList.get(k).equals(nextBreakKeyList.get(k))) {
                    throw new InitializeException(
                            "A setup of a BreakKey needs to be an inclusive"
                            + " relation.");
                }
            }

            // ̃uCNL[2ȏRg[`Ă邩`FbN
            if (nextBreakKeyList != null
                    && checkBreakKeyList.size() == nextBreakKeyList.size()) {
                int sameCount = 0;
                for (int m = 0; m < checkBreakKeyList.size(); m++) {
                    for (int n = 0; n < nextBreakKeyList.size(); n++) {
                        if (checkBreakKeyList.get(m).equals(
                                nextBreakKeyList.get(n))) {
                            sameCount++;
                            break;
                        }
                    }
                }
                if (checkBreakKeyList.size() == sameCount) {
                    throw new InitializeException(
                            "Two or more ControlBreak cannot be defined"
                            + " as the same Break key.");
                }
            }
        }

    }

    /**
     * gUNViRg[uCNL[Xg擾B
     * 
     * @return gUNViRg[uCNL[XgB
     */
    public ControlBreakDefItem getChunkControlBreakDefItem() {
        return chunkControlBreakDefItem;
    }

    /**
     * `NʃRg[uCNL[Xgݒ肷B
     * 
     * @param chunkControlBreakDefItem
     *            `NʃRg[uCNL[XgB
     */
    public void setChunkControlBreakDefItem(
            ControlBreakDefItem chunkControlBreakDefItem) {
        this.chunkControlBreakDefItem = chunkControlBreakDefItem;
    }

    /**
     * PRg[uCNL[Xg擾B
     * 
     * @return PRg[uCNL[XgB
     */
    public List<ControlBreakDefItem> getControlBreakDefItemList() {
        return controlBreakDefItemList;
    }

    /**
     * PRg[uCNL[Xg擾B
     * 
     * @param controlBreakDefItemList
     *            PRg[uCNL[XgB
     */
    public void setControlBreakDefItemList(
            List<ControlBreakDefItem> controlBreakDefItemList) {
        this.controlBreakDefItemList = controlBreakDefItemList;
    }

    /**
     * gXRg[uCNL[Xg擾B
     * 
     * @return gXRg[uCNL[XgB
     */
    public List<ControlBreakDefItem> getTransChunkControlBreakDefItemList() {
        return transChunkControlBreakDefItemList;
    }

    /**
     * gXRg[uCNL[Xg擾B
     * 
     * @param transChunkControlBreakDefItemList
     *            gXRg[uCNL[XgB
     */
    public void setTransChunkControlBreakDefItemList(
            List<ControlBreakDefItem> transChunkControlBreakDefItemList) {
        this.transChunkControlBreakDefItemList = 
            transChunkControlBreakDefItemList;
    }

    /**
     * gXRg[uCNL[Xg̃L[Xgl擾B
     * 
     * @param transChunkControlBreakkey gXRg[uCNL[Xg
     * L[
     * @return gXRg[uCNL[Xg̃nhXglB
     */
    public ControlBreakHandler<JobContext> getTransChunkControlBreakHandler(
            List<String> transChunkControlBreakkey) {
        if (transChunkControlBreakkey == null
                || transChunkControlBreakkey.size() == 0) {
            throw new NullPointerException("TransChunkControlBreakkey is Null");
        }

        if (transChunkControlBreakDefItemList == null
                || transChunkControlBreakDefItemList.size() == 0) {
            throw new IllegalArgumentException(
                    "ControlBreakHandler not found: "
                            + transChunkControlBreakkey.toString());
        }

        for (ControlBreakDefItem controlBreakDefItem
                : transChunkControlBreakDefItemList) {
            if (controlBreakDefItem.getBreakKey().equals(
                    transChunkControlBreakkey)) {
                return controlBreakDefItem.getControlBreakHandler();
            }
        }

        throw new IllegalArgumentException("ControlBreakHandler not found: "
                + transChunkControlBreakkey.toString());
    }

    /**
     * PRg[uCNL[Xg̃L[Xgl擾B
     * 
     * @param controlBreakkey PRg[uCNL[Xg̃L[
     * @return PRg[uCNL[Xg̃nhXglB
     */
    public ControlBreakHandler<JobContext> getControlBreakHandler(
            List<String> controlBreakkey) {
        if (controlBreakkey == null || controlBreakkey.size() == 0) {
            throw new NullPointerException("ControlBreakkey is Null");
        }

        if (controlBreakDefItemList == null
                || controlBreakDefItemList.size() == 0) {
            throw new IllegalArgumentException(
                    "ControlBreakHandler not found: "
                            + controlBreakkey.toString());
        }

        for (ControlBreakDefItem controlBreakDefItem : controlBreakDefItemList)
        {
            if (controlBreakDefItem.getBreakKey().equals(controlBreakkey)) {
                return controlBreakDefItem.getControlBreakHandler();
            }
        }

        throw new IllegalArgumentException("ControlBreakHandler not found: "
                + controlBreakkey.toString());
    }
}
