/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.restart;

import java.io.Serializable;

/**
 * X^[g擾EXVNXpC^tF[XB
 * 
 */
public interface JobRestartInfo extends Serializable {

    /**
     * X^[g|Cg擾B
     * 
     * @return restartPoint X^[g|Cg
     */
    int getRestartPoint();

    /**
     * N󋵂擾B
     * 
     * @return N
     */
    String getState();

    /**
     * X^[g|CgݒB
     * 
     * @param restartPoint
     *            X^[g|Cg
     */
    void setRestartPoint(int restartPoint);

    /**
     * WuReLXg擾B
     * 
     * @return jobContext WuReLXg
     */
    byte[] getJobContext();

    /**
     * N󋵂ݒB
     * 
     * @param state
     *            N
     */
    void setState(String state);

    /**
     * NGXgݒB
     * 
     * @param requestNo
     *            NGXg
     */
    void setRequestNo(String requestNo);

    /**
     * WuIDݒB
     * 
     * @param jobId
     *            WuID
     */
    void setJobId(String jobId);

    /**
     * p[eBVԍݒB
     * 
     * @param partitionNo
     *            p[eBVԍ
     */
    void setPartitionNo(int partitionNo);

    /**
     * p[eBVL[ݒB
     * 
     * @param partitionKey
     *            p[eBVL[
     */
    void setPartitionKey(String partitionKey);

    /**
     * WuReLXgݒB
     * 
     * @param jobContext
     *            WuReLXg
     */
    void setJobContext(byte[] jobContext);
}
