package jp.terasoluna.fw.batch.standard;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.exception.BatchSystemError;
import jp.terasoluna.fw.batch.openapi.JobContext;

/**
 * <code>ThrowableHandler</code>C^tF[X̕WNXB
 * 
 * <p>
 * ̃NXł́AThrowable
 * <code>BatchSystemError</code>ɃbvāAăX[B
 * </p>
 * 
 */
public class ThrowBatchSystemErrorThrowableHandler implements ThrowableHandler {

    /**
     * <code>Throwable</code>ɑ΂鏈sB
     * 
     * <p>ł́AThrowable
     * <code>BatchSystemError</code>ɃbvāAăX[B
     * </p>
     *
     * @param jobContext WuReLXg
     * @param throwable Throwable
     * @param jobStatus WuXe[^X
     */
    public void handle(JobContext jobContext, Throwable throwable,
            JobStatus jobStatus) {
        // BatchSystemErrorȂ炻̂܂܃X[
        if (throwable instanceof BatchSystemError) {
            throw (BatchSystemError) throwable;
        }

        // ThrowableȂ烉bvāAX[
        throw new BatchSystemError(throwable);
    }

}
