/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.springmodules.validation.util.collection.ReadOnlyIterator;
import org.springmodules.validation.util.condition.Condition;

public class FilteredIterator
extends ReadOnlyIterator {
    private Condition condition;
    private Iterator iterator;
    private boolean initialized;
    private boolean finished;
    private Object nextElement;

    public FilteredIterator(Iterator iterator, Condition condition) {
        this.iterator = iterator;
        this.condition = condition;
    }

    public boolean hasNext() {
        this.initializeIfNeeded();
        return !this.finished;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object result = this.nextElement;
        this.advanceIterator();
        return result;
    }

    protected void initializeIfNeeded() {
        if (!this.initialized) {
            this.advanceIterator();
            this.initialized = true;
        }
    }

    protected void advanceIterator() {
        boolean assigned = false;
        while (this.iterator.hasNext()) {
            Object element = this.iterator.next();
            if (!this.condition.check(element)) continue;
            this.nextElement = element;
            assigned = true;
            break;
        }
        this.finished = !assigned;
    }
}

