/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.rich;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jp.terasoluna.fw.web.rich.ForbiddenURIChecker;
import jp.terasoluna.fw.web.rich.exception.ForbiddenURIException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ForbiddenURIFilter
implements Filter {
    private static Log log = LogFactory.getLog(ForbiddenURIFilter.class);
    private static final String DEFAULT_CHECKER_BEANID = "forbiddenURIChecker";
    private static final String INITPARAM_KEY_CHECKER_BEANID = "checkerBeanID";
    private ForbiddenURIChecker checker = null;

    public void init(FilterConfig config) throws ServletException {
        String checkerBeanID = config.getInitParameter(INITPARAM_KEY_CHECKER_BEANID);
        if (checkerBeanID == null) {
            checkerBeanID = DEFAULT_CHECKER_BEANID;
        }
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)config.getServletContext());
        try {
            this.checker = (ForbiddenURIChecker)context.getBean(checkerBeanID, ForbiddenURIChecker.class);
        }
        catch (BeanNotOfRequiredTypeException e) {
            log.error((Object)"the bean is not of the required type - ForbiddenURIChecker.");
            throw e;
        }
        catch (NoSuchBeanDefinitionException e) {
            log.error((Object)("there's no such bean definition. BeanID=" + checkerBeanID + "."));
            throw e;
        }
        catch (BeansException e) {
            log.error((Object)("the bean could not be created. BeanID=" + checkerBeanID + "."));
            throw e;
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        String requestURI = ((HttpServletRequest)req).getRequestURI().replaceFirst(((HttpServletRequest)req).getContextPath(), "");
        if (!this.checker.isAllowedURI(requestURI)) {
            log.error((Object)"request url is forbidden!");
            throw new ForbiddenURIException();
        }
        chain.doFilter(req, res);
    }

    public void destroy() {
    }
}

