/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.servlet.handler;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;
/**
 * ONXƃr[̃}bsOsException resolver̊gNXB
 * 
 * <p>
 * Spring񋟂 SimpleMappingExceptionResolver
 * exceptionMappingśAݒ荀ڂ̏̕ێoȂB<br>
 * {NX́ASimpleMappingExceptionResolvergA
 * ɏ̕ێ\ȑlinkedExceptionMappings񋟂̂łB
 * </p>
 * 
 * <p>
 * NGXgRg[ŔOnhOA
 * Bean`t@Cɏ]X[ꂽO^ɑΉViewCX^X
 * ModelCX^XԋpB<br>
 * ModelCX^Xɏi[鏈́A{@link ExceptionResolveDelegator}NXɈϏB<br>
 * ViewCX^XŁAModelCX^XɊi[ꂽ𗘗p
 * G[X|X̃_OsƂz肵ĂB
 * </p>
 * 
 * <p>
 * X|XɗOƂʒmwb_ݒ肷B<br>
 * wb_ɏݒ肷鏈́A{@link ExceptionResolveDelegator}NXɈϏB
 * </p>
 * 
 * <p>
 * {NX𗘗pꍇA{NXBean`sƁB
 * ܂Aȉ̃vpeBKݒ肷邱ƁB
 * </p>
 * 
 * <p>
 *   <table border="1" CELLPADDING="8">
 *     <th></th>
 *     <th>K{</th>
 *     <th></th>
 * 
 *     <tr>
 *       <td align=center><b>linkedExceptionMappings</b></td>
 *       <td></td>
 *       <td>
 *           ONXView̃}bsOimap`jB<br>
 *           entrỹL[́AONXݒ肷B<br>
 *           entry̒ĺAgp{@link ExceptionResolveDelegator}NXjavadocQlɐݒ肷邱ƁB
 *       </td>
 *     </tr>
 *     <tr>
 *       <td align=center><b>exceptionResolveDelegatorClass</b></td>
 *       <td></td>
 *       <td>
 *           ExceptionResolveDelegatorNX
 *       </td>
 *     </tr>
 *     <tr>
 *       <td align=center><b>exceptionResolveDelegatorParams</b></td>
 *       <td>&nbsp;</td>
 *       <td>
 *           ExceptionResolveDelegatorNXp̃}bsOB<br>
 *           entrỹL[́A񖼁B<br>
 *           entry̒ĺAlB
 *       </td>
 *     </tr>
 *     <tr>
 *       <td align=center><b>outputErrorLogHandledException</b></td>
 *       <td>&nbsp;</td>
 *       <td>
 *           nhOȌG[Oo͂邩킷booleanlB<br>
 *           truȅꍇAG[Oo͂sB<br>
 *           ftHgtruełB<br>
 *           vWFNgƂ̃OĎ̗vȂǂ
 *           nhOȌG[Oo͂Ȃꍇ̂ݐݒ肷邱ƁB
 *           ʏ͖{ݒ𗘗pKv͂ȂB
 *       </td>
 *     </tr>
 *  </table>
 * 
 * </p>
 * ExceptionResolveDelegatorNXƂāAExceptionResolveDelegatorImplgpꍇ̐ݒȉɋLB
 * y<code>Bean`t@C</code>̐ݒz<br>
 * <code><pre>
 *   &lt;bean id="handlerExceptionResolver"
 *       class="jp.terasoluna.fw.web.rich.springmvc.servlet.handler.SimpleMappingExceptionResolverEx"&gt;
 *     &lt;property name="linkedExceptionMappings"&gt;
 *       &lt;map&gt;
 *         &lt;entry key="jp.terasoluna.fw.web.rich.exception.UnknownRequestNameException"&gt;
 *           &lt;value&gt;exception,kind01,8004C003&lt;/value&gt;
 *         &lt;/entry&gt;
 *         &lt;entry key="org.springframework.validation.BindException"&gt;
 *           &lt;value&gt;bindException,kind02&lt;/value&gt;
 *         &lt;/entry&gt;
 *         &lt;entry key="jp.terasoluna.fw.service.rich.exception.SystemException"&gt;
 *           &lt;value&gt;systemException,kind03&lt;/value&gt;
 *         &lt;/entry&gt;
 *         &lt;entry key="jp.terasoluna.fw.service.rich.exception.ServiceException"&gt;
 *           &lt;value&gt;serviceException,kind04&lt;/value&gt;
 *         &lt;/entry&gt;
 *         &lt;entry key="java.lang.Exception"&gt;
 *           &lt;value&gt;exception,kind05,8004C999&lt;/value&gt;
 *         &lt;/entry&gt;
 *       &lt;/map&gt;
 *     &lt;/property&gt;
 *     &lt;property name="exceptionResolveDelegatorClass" value="jp.terasoluna.fw.web.rich.springmvc.servlet.handler.ExceptionResolveDelegatorImpl" /&gt;
 *     &lt;property name="exceptionResolveDelegatorParams"&gt;
 *       &lt;map&gt;
 *         &lt;entry key="errorTypeHeaderName"&gt;
 *           &lt;value&gt;errorType&lt;/value&gt;
 *         &lt;/entry&gt;
 *       &lt;/map&gt;
 *     &lt;/property&gt; 
 *   &lt;/bean&gt;
 * </pre></code>
 * 
 * <p>
 * Ƃ΁AL̐ݒsŁA
 * UnknownRequestNameExceptionX[ĂꍇA
 * uexceptionvƂ̂̃r[ƁA
 * X[ꂽOCX^XƁAG[R[hu8004C003v
 * i[fԋpB<br>
 * X|Xwb_ɂ́AuerrorTypevL[Ƃāukind01vݒ肷B
 * </p>
 * 
 * <p>
 * SimpleMappingExceptionResolverEx́AX[ꂽǑ^
 * linkedExceptionMappings̃L[ݒt@CɋLqꂽɔrB
 * ݒt@CɋLqꂽO^AX[ꂽO^
 * ̌^A܂͐ě^ꍇɁAΉl̖̂View𐶐ԋpB
 * 
 * X[ꂽ^ƈvݒ肪ꍇ́A
 * ɋLqݒ肪̗pB
 * ŌɑSĂ̗O̐eNXƂȂjava.lang.Exception̐ݒsƂŁA
 *@\ʗOꍇłKAjava.lang.Exception̐ݒ
 * G[X|X̃_OoB
 * </p>
 * 
 * <p>
 * ŏ\ȗÓANGXgRg[ŔÔ݂łB
 * ViewFilterADispacherServletOŔÕnhÓA
 * {NX͐ӖȂB
 * ̗OnhO邽߂ɂ́AServlet񋟂Ă
 * G[y[W̋@\𗘗p邱ƁB
 * Ǒ^ƂɔCӂ̌ŒdX|XɃ_O邱ƂoB
 * </p>
 * 
 * <p>
 * y<code>web.xml</code>̐ݒz<br>
 * <code><pre>
 *   &lt;error-page&gt;
 *     &lt;exception-type&gt;java.lang.Exception&lt;/exception-type&gt;
 *     &lt;location&gt;/error/unknown-error.jsp&lt;/location&gt;
 *   &lt;/error-page&gt;
 * @@ 炩ߌŒ̃G[dLq/error/unknown-error.jsppӂĂƁB
 * </pre></code>
 * </p>
 * @see jp.terasoluna.fw.web.rich.springmvc.servlet.handler.ExceptionResolveDelegator
 * 
 *
 */
public class SimpleMappingExceptionResolverEx extends SimpleMappingExceptionResolver implements InitializingBean {
    /**
     * ONXB
     */
    private final Log log = LogFactory.getLog(getClass());
    
    /**
     * ێOViewiG[j̃}bsOB
     */
    protected Map<String, Object> linkedExceptionMappings = null;

    /**
     * {NXׂnh̃ZbgB
     * <p>ׂRg[CX^Xݒ肷B
     * {@link #resolveException(HttpServletRequest, HttpServletResponse, Object, Exception)}
     * \bhŎgpBRg[IuWFNg̔rs߁A
     * Rg[VOgݒɂȂ΂ȂȂB</p>
     */
    protected Set mappedHandlers = null;

    /**
     * OꍇɃX|Xɐݒ肷G[R[hB
     */
    protected Integer defaultStatusCode = null;
    
    /**
     * X[ꂽOɑΉݒ肪ꍇɎsVieẃ̖B
     * linkedExceptionMappingsŁAjava.lang.Exception̒`Ăꍇ͕svB
     */
    protected String defaultErrorView = null;

    /**
     * ExceptionResolveDelegatorNX̌^
     */
    protected Class< ? extends ExceptionResolveDelegator> exceptionResolveDelegatorClass = jp.terasoluna.fw.web.rich.springmvc.servlet.handler.ExceptionResolveDelegatorImpl.class;
    
    /**
     * Ǒ^L[ExceptionResolveDelegatori[Map
     */
    protected LinkedHashMap<String, ExceptionResolveDelegator> exceptionResolveDelegatorMap = new LinkedHashMap<String, ExceptionResolveDelegator>();
    
    /**
     * ExceptionResolveDelegator̃p[^[̃L[ƒli[Map
     */
    protected Map<String, String> exceptionResolveDelegatorParams = null;
    
    /**
     * nhOȌG[Oo͂邩
     */
    protected boolean outputErrorLogHandledException = true;
    
    /**
     * {NXCX^XꂽɌĂ΂郁\bhB 
     * ExceptionResolveDelegator𐶐AɊi[B
     */
    public void afterPropertiesSet() {
        if (this.linkedExceptionMappings == null) {
            return;
        }

        // exceptionResolveDelegatorClassnull`FbN
        if (this.exceptionResolveDelegatorClass == null) {
            String message = "SimpleMappingExceptionResolverEx must be set exceptionResolveDelegatorClass. "
                    + "Check Spring Bean definition file.";
            log.error(message);
            throw new IllegalStateException(message);
        }

        for (String mappingKey : this.linkedExceptionMappings.keySet()) {
            ExceptionResolveDelegator exceptionResolveDelegator = null;
            try {
                // exceptionResolveDelegatorClass̃CX^XAExceptionResolveDelegator^ł邱Ƃ̃`FbN
                if (!(ExceptionResolveDelegator.class
                        .isAssignableFrom(exceptionResolveDelegatorClass))) {
                    String message = exceptionResolveDelegatorClass.getName()
                            + " is not ExceptionResolveDelegator type. "
                            + "Check Spring Bean definition file.";
                    log.error(message);
                    throw new IllegalStateException(message);
                }
                exceptionResolveDelegator = exceptionResolveDelegatorClass
                        .newInstance();
            } catch (InstantiationException e) {
                // exceptionResolveDelegatorClass̃CX^XɎsꍇAOX[
                String message = exceptionResolveDelegatorClass.getName()
                        + " cannot be instantiated. "
                        + "Check Spring Bean definition file.";
                log.error(message, e);
                throw new IllegalStateException(message, e);
            } catch (IllegalAccessException e) {
                // exceptionResolveDelegatorClass̃CX^XɎsꍇAOX[
                String message = exceptionResolveDelegatorClass.getName()
                        + " cannot be instantiated. "
                        + "Check Spring Bean definition file.";
                log.error(message, e);
                throw new IllegalStateException(message, e);
            }
            // ExceptionResolveDelegatorɁAG[̌^ƃG[}bsO
            exceptionResolveDelegator.initMapping(mappingKey,
                    this.linkedExceptionMappings.get(mappingKey),
                    this.exceptionResolveDelegatorParams);
            exceptionResolveDelegatorMap.put(mappingKey,
                    exceptionResolveDelegator);
        }
    }   

    /**
     * X[ꂽOɑΉݒ肪ꍇɎsVieŵ̖ݒ肷B
     * eNXŕێĂ邪A{NXŎQƂłȂ߁A
     * {NXłƂĊǗB
     * 
     * @param defaultErrorView X[ꂽOɑΉݒ肪ꍇɎsView̖
     */
    @Override
    public void setDefaultErrorView(String defaultErrorView) {
        super.setDefaultErrorView(defaultErrorView);
        this.defaultErrorView = defaultErrorView;
        if (logger.isInfoEnabled()) {
            logger.info("Default error view is '"
                            + this.defaultErrorView + "'");
        }
    }

    /**
     * Oƃr[iG[j̃}bsOێNXݒ肷
     * @param exceptionResolveDelegatorClass Oƃr[iG[j̃}bsOێNX
     */
    public void setExceptionResolveDelegatorClass(
            Class< ? extends ExceptionResolveDelegator> exceptionResolveDelegatorClass) {
        this.exceptionResolveDelegatorClass = exceptionResolveDelegatorClass;
    }
     
    /**@
     * ExceptionResolveDelegator̃p[^[̃L[ƒli[Mapݒ肷
     * @param exceptionResolveDelegatorParams ExceptionResolveDelegator̃p[^[̃L[ƒli[Map
     */
    public void setExceptionResolveDelegatorParams(
            Map<String, String> exceptionResolveDelegatorParams) {
        this.exceptionResolveDelegatorParams = exceptionResolveDelegatorParams;
    }
    
    /**
     * mappedHandlersݒ肷B
     * eNXŕێĂ邪A{NXŎQƂłȂ߁A
     * {NXłƂĊǗB
     * @param mappedHandlers mappedHandlers
     */
    @Override
    public void setMappedHandlers(Set mappedHandlers) {
        super.setMappedHandlers(mappedHandlers);
        this.mappedHandlers = mappedHandlers;
    }

    /**
     * OꍇɃX|Xɐݒ肷G[R[hݒ肷B
     * 
     * @param defaultStatusCode HTTPXe[^XR[hl
     */
    @Override
    public void setDefaultStatusCode(int defaultStatusCode) {
        super.setDefaultStatusCode(defaultStatusCode);
        this.defaultStatusCode = Integer.valueOf(defaultStatusCode);
    }
    
    /**
     * ێłȂOViewiG[j̃}bsOݒ肷B
     * ɏێ@\񋟂Ă̂ŁA
     * KUnsupportedOperationExceptionX[B
     * @deprecated linkedExceptionMappings𗘗p邱ƁB
     * @param mappings OView̃}bsO
     */
    @Deprecated
    @Override
    public void setExceptionMappings(Properties mappings) {
        throw new UnsupportedOperationException();
    }

    
    /**
     * ێ鏇ێOView(&G[)
     * }bsOݒ肷B
     * @param linkedExceptionMappings ێOViewiG[j̃}bsO
     */
    public void setLinkedExceptionMappings(
            Map<String, Object> linkedExceptionMappings) {
        this.linkedExceptionMappings = linkedExceptionMappings;
    }
    
    /**
     * nhOȌG[Oo͂邩booleanlݒ肷B
     * 
     * <p>
     * ftHgtrueȂ̂ŃvWFNgƂ̃OĎ̗vȂǂ
     * nhOȌG[Oo͂Ȃꍇ̂ݖ{\bh𗘗p邱ƁB
     * ʏ͖{\bh𗘗pKv͂ȂB
     * </p>
     * 
     * @param outputErrorLogHandledException falseȂΏo͂ȂB
     */
    public void setOutputErrorLogHandledException(boolean outputErrorLogHandledException) {
        this.outputErrorLogHandledException = outputErrorLogHandledException;
    }

    /**
     * X[ꂽOɑΉViewModelԋpB
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @param handler nh
     * @param ex X[ꂽO
     * @return f(OƃG[(C)i[)ƃr[
     */
    @Override
    public ModelAndView resolveException (
            HttpServletRequest request,
            HttpServletResponse response,
            Object handler,
            Exception ex) {

        // {NXׂnh
        if (this.mappedHandlers != null
                && !this.mappedHandlers.contains(handler)) {
            return null;
        }

        // X[ꂽǑ^ƒ`ĂǑ^`FbN
        ExceptionResolveDelegator exceptionResolveDelegator = null;
        for (String mappingKey : exceptionResolveDelegatorMap.keySet()) {
            int depth = getDepth(mappingKey, ex);
            if (depth >= 0) {
                exceptionResolveDelegator = exceptionResolveDelegatorMap
                        .get(mappingKey);
                break;
            }
        }

        // `ĂȂOX[Ăꍇ̏
        if (exceptionResolveDelegator == null) {
            return null;
        }

        String viewName = exceptionResolveDelegator.getViewName();
        // r[ݒ肳ĂȂꍇ̏
        if (viewName == null && this.defaultErrorView != null) {
            viewName = this.defaultErrorView;
        }

        if (viewName != null) {
            // X[ꂽO`Ăꍇ Oo
            if (this.outputErrorLogHandledException) {
                log.error("Handled the following exception.", ex);
            }

            // HTTPG[Xe[^XX|Xɐݒ肷
            if (this.defaultStatusCode != null) {
                response.setStatus(this.defaultStatusCode.intValue());
            }

            exceptionResolveDelegator.setHeader(response);

            // View̌
            ModelAndView mv = getModelAndView(viewName, ex);
            
            exceptionResolveDelegator.addObjectToModel(mv);

            return mv;
        } 
        return null;
    }

}
