/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.servlet.view.castor;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.oxm.mapper.OXMapper;
import jp.terasoluna.fw.web.rich.springmvc.Constants;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

/**
 * Castor𗘗pHTTPX|XsNXB
 * Ɩʂł郂fIuWFNgXML`̃f[^쐬A
 * HTTPX|Xɐݒ肷B
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.servlet.view.castor.CastorViewResolver
 */
public class CastorView extends AbstractUrlBasedView {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(CastorView.class);
    
    /**
     * XMLIuWFNgϊNXB
     */
    private OXMapper oxmapper = null;
    
    /**
     * Castorr[̕\sȂB
     * @param model Ɩ̌
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @throws Exception OB
     */
    @Override
    protected void renderMergedOutputModel(Map model, 
            HttpServletRequest request, HttpServletResponse response) 
            throws Exception {
        
        // ObjectXML
        StringWriter stringWriter = new StringWriter();
        oxmapper.marshal(model.get(Constants.RESULT_KEY), stringWriter);
        
        // XMLf[^HTTPX|Xɏo
        Writer responseWriter = null;
        try {
            response.setContentType(this.getContentType());
            addResponseHeader(model, request, response);
            responseWriter = response.getWriter();
            responseWriter.write(stringWriter.getBuffer().toString());
        } catch (IOException e) {
            log.error("Cannot get Response Writer object.");
            throw e;
        } finally {
            if (responseWriter != null) {
                try {
                    responseWriter.close();
                } catch (IOException ee) {
                    log.error("Cannot close response writer.", ee);
                }
            }
        }
    }

    /**
     * X|Xwb_ǉB
     * X|Xwb_ǉꍇÃ\bhI[oChB
     *
     * @param model Ɩ̌
     * @param request HTTPNGXg
     * @param response HTTPX|X
     */
    protected void addResponseHeader(Map model, 
            HttpServletRequest request, HttpServletResponse response) {
    }

    /**
     * oxmapper擾B
     *
     * @return oxmapper
     */
    public OXMapper getOxmapper() {
        return oxmapper;
    }

    /**
     * oxmapperݒ肷B
     *
     * @param oxmapper oxmapperɐݒ肷l
     */
    public void setOxmapper(OXMapper oxmapper) {
        this.oxmapper = oxmapper;
    }

}
