/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.common.context.support;

import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import jp.terasoluna.fw.web.rich.context.RequestContext;
import jp.terasoluna.fw.web.rich.context.support.
        AbstractRequestContextSupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * T|[gNX<br>
 * NGXgwb_Ɉȉ̏񂪂̏𐧌NXɊi[B<br>
 * <br>
 * <table border="1">
 *   <tr>
 *     <td>NGXgL[</td>
 *     <td>gp[XP[X</td>
 *   </tr>
 *   <tr>
 *     <td><code>requestName</code></td>
 *     <td>S[XP[X</td>
 *   </tr>
 *   <tr>
 *     <td><code>userId</code></td>
 *     <td>Ǘ(UC104)</td>
 *   </tr>
 *   <tr>
 *     <td><code>password</code></td>
 *     <td>Ǘ(UC104)</td>
 *   </tr>
 *   <tr>
 *     <td>accept-language</td>
 *     <td>DBbZ[WǗ(UC110)</td>
 *   </tr>
 * </table>
 * <br>
 * ӎFgp[XP[XȊO̓NGXgwb_ɂ̃f[^͂ȂB
 *
 *  
 */
public class RequestContextSupportImpl extends AbstractRequestContextSupport {
    
    /**
     * NGXg̃L[
     */
    public static final String REQUEST_NAME_KEY  = "requestName";
    
    /**
     * [UID̃L[
     */
    public static final String USERID_KEY = "userId";
    
    /**
     * pX[h̃L[
     */
    public static final String PASSWORD_KEY  = "password";
    
    /**
     * P[
     */
    public static final String LANGUAGE_KEY = "language";
    
    /**
     * P[
     */
    public static final String COUNTRY_KEY = "country";
    
    /**
     * P[oAg
     */
    public static final String VARIANT_KEY = "variant";

    /**
     * ANZX̃L[
     */
    public static final String ACCESS_DATE_KEY = "accessDate";
    
    /**
     * NGXgReLXg̏ɐ𐶐B<br>
     *
     * @param request HTTPT[ubgNGXg
     * @return NGXgReLXg
     */
    @Override
    protected RequestContext doGenerateContext(HttpServletRequest request) {
        
        RequestContext ctx = new RequestContext();
        ctx.setRequestName(
                request.getHeader(RequestContextSupportImpl.REQUEST_NAME_KEY));
        
        //NGXgwb_擾
        String userId =
            request.getHeader(RequestContextSupportImpl.USERID_KEY);
        String password =
            request.getHeader(RequestContextSupportImpl.PASSWORD_KEY);        
        Locale locale = request.getLocale();
        
        // NGXgwb_擾it^̐j
        Date accessDate = null;
        DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
        String accessDateString = request.getHeader(RequestContextSupportImpl.ACCESS_DATE_KEY);
        
        if (accessDateString != null) {
            try {
                accessDate = dateFormat.parse(accessDateString);
            }catch(ParseException e){
                // sO
            	throw new IllegalStateException();
            }
        }
        
        //i[NXɐݒ
        if (userId != null) {
            ctx.setProperty(RequestContextSupportImpl.USERID_KEY, userId);
        }
        
        if (password != null) {
            ctx.setProperty(
                    RequestContextSupportImpl.PASSWORD_KEY, password);
        }

        // i[NXɐݒit^̐j
        if (accessDate != null) {
            ctx.setProperty(
                    RequestContextSupportImpl.ACCESS_DATE_KEY, accessDate);
        }
        
        //DBbZ[W̃P[𐧌i[NXɐݒ
        if (locale != null) {
            ctx.setProperty(RequestContextSupportImpl.LANGUAGE_KEY, 
                    locale.getLanguage());
            ctx.setProperty(RequestContextSupportImpl.COUNTRY_KEY,
                    locale.getCountry());
            ctx.setProperty(RequestContextSupportImpl.VARIANT_KEY,
                    locale.getVariant());
        }
        
        
        
        return ctx;
    }
}
