/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.rich;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jp.terasoluna.fw.web.rich.context.support.RequestContextSupport;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RequestContextHandlingFilter
implements Filter {
    private static final String DEFAULT_CTXSUPPORT_BEANID = "ctxSupport";
    private static final String INITPARAM_KEY_CTXSUPPORT_BEANID = "ctxSupportBeanID";
    private RequestContextSupport ctxSupport = null;

    public void init(FilterConfig config) throws ServletException {
        String ctxSupportBeanID = config.getInitParameter(INITPARAM_KEY_CTXSUPPORT_BEANID);
        if (ctxSupportBeanID == null) {
            ctxSupportBeanID = DEFAULT_CTXSUPPORT_BEANID;
        }
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)config.getServletContext());
        this.ctxSupport = (RequestContextSupport)context.getBean(ctxSupportBeanID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.ctxSupport.generateContext((HttpServletRequest)request);
            chain.doFilter(request, response);
        }
        finally {
            this.ctxSupport.destroyContext();
        }
    }

    public void destroy() {
    }
}

