/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich;

import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 񂪋URI肷`FbJ̃ftHgNXB
 * 
 * <p>
 * ̕񂪁A
 * 炩ߐݒ肳ꂽ̃XgɂĂ͂܂邪ǂ`FbNB
 * </p>
 * 
 * <p>
 * {NXł́AVXe̗v𖞂Ȃꍇ̂݁A
 * {NXgpForbiddenURIChecker̎NXVK쐬A
 * `FbN\bh邱ƁB
 * ڍׂ́AForbiddenURICheckerQƂ邱ƁB
 * </p>
 * 
 * <p>
 * {NX𗘗pꍇABean`邱ƁB
 * `@́AForbiddenURICheckerQƂ邱ƁB
 * ܂Aȉ̃vpeBKݒ肷邱ƁB
 * </p>
 * <p>
 *   <table border="1" CELLPADDING="8">
 *     <th></th>
 *     <th>K{</th>
 *     <th></th>
 *     
 *     <tr>
 *       <td align=center><b>allowedURISet</b></td>
 *       <td></td>
 *       <td>URI(Zbg`)</td>
 *     </tr>
 *  </table>
 * </p>
 * 
 * <p>
 * y<code>Bean`t@C</code>̐ݒz<br>
 * <code><pre>
 * &lt;bean id="forbiddenURIChecker"
 *      class="jp.terasoluna.fw.web.rich.ForbiddenURICheckerImpl"&gt;
 *   &lt;property name="allowedURISet"&gt;
 *     &lt;set&gt;
 *       &lt;value&gt;/secure/blogic.do&lt;/value&gt;
 *     &lt;/set&gt;
 *   &lt;/property&gt;
 * &lt;/bean&gt;
 * </pre></code>
 * </p>
 * 
 */
public class ForbiddenURICheckerImpl implements ForbiddenURIChecker {
    /**
     * OB
     */
    private static Log logger
        = LogFactory.getLog(ForbiddenURICheckerImpl.class);

    /**
     * URĨZbgB
     */
    private Set<String> allowedURISet = null;
    
    /**
     * URĨXgݒ肷B
     * 
     * @param allowedURISet URĨXg
     */
    public void setAllowedURISet(Set<String> allowedURISet) {
        this.allowedURISet = allowedURISet;
    }
    
    /**
     * ĂURI`FbNB
     * 
     * @param requestURI `FbNΏۂURI
     * @return `FbNʁiĂtruej
     */
    public boolean isAllowedURI(String requestURI) {
        if (allowedURISet == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("allowedURISet is null.");
            }
            return false;
        }
        
        // URI̋۔菈
        return allowedURISet.contains(requestURI);
    }
}
