/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.conf.loader.xml.handler;

import org.springframework.util.StringUtils;
import org.springmodules.validation.bean.conf.ValidationConfigurationException;
import org.springmodules.validation.bean.conf.loader.xml.handler.AbstractPropertyValidationElementHandler;
import org.springmodules.validation.bean.rule.AbstractValidationRule;
import org.springmodules.validation.bean.rule.LengthValidationRule;
import org.springmodules.validation.bean.rule.MaxLengthValidationRule;
import org.springmodules.validation.bean.rule.MinLengthValidationRule;
import org.w3c.dom.Element;

public class LengthRuleElementHandler
extends AbstractPropertyValidationElementHandler {
    private static final String ELEMENT_NAME = "length";
    private static final String MIN_ATTR = "min";
    private static final String MAX_ATTR = "max";

    public LengthRuleElementHandler(String namespaceUri) {
        super(ELEMENT_NAME, namespaceUri);
    }

    protected AbstractValidationRule createValidationRule(Element element) {
        Integer max;
        String minText = element.getAttribute(MIN_ATTR);
        String maxText = element.getAttribute(MAX_ATTR);
        Integer min = StringUtils.hasText((String)minText) ? new Integer(minText) : null;
        Integer n = max = StringUtils.hasText((String)maxText) ? new Integer(maxText) : null;
        if (min != null && max != null) {
            return new LengthValidationRule(min, max);
        }
        if (min != null) {
            return new MinLengthValidationRule(min);
        }
        if (max != null) {
            return new MaxLengthValidationRule(max);
        }
        throw new ValidationConfigurationException("Element 'length' must have either 'min' attribute, 'max' attribute, or both");
    }
}

