/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.condition.bean;

import org.springframework.beans.BeanWrapper;
import org.springframework.util.Assert;
import org.springmodules.validation.util.condition.Condition;
import org.springmodules.validation.util.condition.bean.AbstractBeanCondition;

public class PropertyBeanCondition
extends AbstractBeanCondition {
    private String propertyName;
    private Condition propertyCondition;

    public PropertyBeanCondition(String propertyName, Condition propertyCondition) {
        Assert.notNull((Object)propertyName, (String)"Property name cannot be null");
        Assert.notNull((Object)propertyCondition, (String)"Property condition cannot be null");
        this.propertyName = propertyName;
        this.propertyCondition = propertyCondition;
    }

    protected boolean checkBean(BeanWrapper bean) {
        Object value = bean.getPropertyValue(this.propertyName);
        return this.propertyCondition.check(value);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Condition getPropertyCondition() {
        return this.propertyCondition;
    }
}

