/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.commonj.init;

import commonj.work.Work;
import commonj.work.WorkException;
import commonj.work.WorkItem;
import commonj.work.WorkListener;
import commonj.work.WorkManager;
import jp.terasoluna.fw.batch.commonj.init.ChildJobExecutor;
import jp.terasoluna.fw.batch.commonj.listener.WorkMapListener;
import jp.terasoluna.fw.batch.core.InitializeException;
import jp.terasoluna.fw.batch.init.JobRequestInfo;
import jp.terasoluna.fw.batch.openapi.JobContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChildJobStarter {
    private static final Log log = LogFactory.getLog(ChildJobStarter.class);
    private static final int SCHDULE_SUCCESS = 0;
    private static final int SCHDULE_ERROR = -1;
    private WorkManager workManager = null;
    private WorkMapListener workListener = null;

    public int execute(String[] args, JobContext jobContext) {
        if (this.workManager == null) {
            throw new InitializeException("WorkManager is required.");
        }
        if (this.workListener == null) {
            throw new InitializeException("WorkListener is required.");
        }
        JobRequestInfo jobInfo = new JobRequestInfo(args);
        jobInfo.init();
        ChildJobExecutor childJobExecutor = new ChildJobExecutor();
        childJobExecutor.setJobInfo(jobInfo);
        childJobExecutor.setJobContext(jobContext);
        try {
            WorkItem workItem = this.workManager.schedule((Work)childJobExecutor, (WorkListener)this.workListener);
            this.workListener.addWork(workItem, childJobExecutor);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return -1;
        }
        catch (WorkException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return -1;
        }
        return 0;
    }

    public void setWorkListener(WorkMapListener workListener) {
        this.workListener = workListener;
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }
}

