/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.controlbreak;

import java.util.LinkedHashMap;
import java.util.List;

import jp.terasoluna.fw.batch.core.BLogicExecutor;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.openapi.JobContext;

/**
 * rWlXWbNsNXC^tF[X̎NXB
 * rWlXWbN̎sARg[uCNsB
 * 
 */
public class ControlBreakBLogicExecutor implements BLogicExecutor {

    /**
     * rWlXWbNsNX̃CX^XB
     * 
     * <p>rWlXWbNśÃCX^XɈϏB</p>
     */
    private BLogicExecutor blogicExecutor = null;
    
    /**
     * OĂяõrWlXWbN̓f[^B
     */
    private ControlBreakRowObject previousData = null;
    
    /**
     * uCNNXB
     */
    private ControlBreakProcessor controlBreakProcessor = null;
    
    /**
     * rWlXWbNsAw肳ꂽRg[uCN΁A
     * uCNsB
     * ܂A̍ŌłΒ`ꂽSẴuCNsB
     * 
     *
     * @param blogicInputData Ώۃf[^ێRg[uCNRowf
     * [^
     * @param jobContext WuReLXg
     * @param jobStatus Wu
     * @param batchUpdateMapList ob`XVXg
     */
    public void executeBLogic(Object blogicInputData, JobContext jobContext,
            JobStatus jobStatus,
            List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        
        // ŏIRowIuWFNgNXB
        ControlBreakRowObject lastData = null;
        
        ControlBreakRowObject controlBreakRowObject = 
            (ControlBreakRowObject) blogicInputData;
        if (previousData == null) {
            previousData = controlBreakRowObject;
            return;
        }

        // IԂ̏ꍇɂ̓Rg[uCN
        // s킸Â܂܃^[B
        if (!jobStatus.isContinue()) {
            return;
        }

        /*
         * Of[^܂ł̃Rg[uCNs
         */
        if (previousData.getControlBreakKeyList().size() > 0) {
            controlBreakProcessor.doControlBreak(previousData, jobContext,
                    jobStatus, batchUpdateMapList);
        }

        // IԂ̏ꍇɂ̓rWlXWbN
        // s킸Â܂܃^[B
        if (!jobStatus.isContinue()) {
            return;
        }

        // Of[^ŃrWlXWbNĂяoϏB
        blogicExecutor.executeBLogic(previousData.getRowObject(), jobContext,
                jobStatus, batchUpdateMapList);

        /*
         * `NI[}[NiOf[^p̃_~[ĵƂ Rg[u
         * CNsB
         */
        if (controlBreakRowObject.getRowObject() == ControlBreakChunk.
                CHUNK_BREAK_MARK) {
            // IԂ̏ꍇɂ̓Rg[uCN
            // s킸Â܂܃^[B
            if (!jobStatus.isContinue()) {
                return;
            }
            if (controlBreakRowObject.getControlBreakKeyList().size() > 0) {
                controlBreakProcessor.doControlBreak(controlBreakRowObject,
                        jobContext, jobStatus, batchUpdateMapList);
            }
            previousData = null;
        } else {
            previousData = controlBreakRowObject;
        }

        // ŏIf[^̂Ƃ́AS̎s
        if (controlBreakRowObject.getRowObject()
                == ControlBreakChunk.END_MARK) {
            lastData = new ControlBreakRowObject(previousData.getRowObject(),
                    controlBreakRowObject.getControlBreakKeyList(),
                    controlBreakRowObject.getControlBreakMap());
            controlBreakProcessor.doAllChunkInternalControlBreak(lastData,
                    jobContext, jobStatus, batchUpdateMapList);
            return;
        }

    }

    /**
     * rWlXWbNsNX̃CX^Xݒ肷B
     * 
     * @param blogicExecutor rWlXWbNsNX̃CX^X
     */
    public void setBlogicExecutor(BLogicExecutor blogicExecutor) {
        this.blogicExecutor = blogicExecutor;
    }

    /**
     * uCNNXݒ肷B
     * 
     * @param controlBreakProcessor uCNNX̃CX^X
     */
    public void setControlBreakProcessor(
            ControlBreakProcessor controlBreakProcessor) {
        this.controlBreakProcessor = controlBreakProcessor;
    }
}
