/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.monitor;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

import jp.terasoluna.fw.batch.core.JobStatus;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * WuJMXŊĎ邽߂̓o^NXB<br>
 * 
 * <p>
 * jp.terasoluna.fw.batch.monitor.MonitorableJobStatusMBean
 *NXĎΏۂƂȂB
 * </p>
 * <strong>ݒ</strong><br>
 * {@\gpꍇAt[[NBean`t@CƃftHgBean`t@CɈȉ̓eݒ肷B
 * <br>ȉ̗ł͊ĎsAĎWuiqWu܂ށj̏l20łB
 * <br><br>    
 * - t[[NBean`t@C(FrameworkBean.xml)ݒB<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;!-- Ď`B--&gt;<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;bean id=&quot;MBeanRegister&quot; class=&quot;jp.terasoluna.fw.batch.monitor.MBeanRegister&quot;&gt;<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;property name=&quot;manageableJobSize&quot; ref=&quot;manageableJobSize&quot;/&gt;<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/bean&gt;<br>
 * <br>
 * - ftHgBean`t@C(DefaultValueBean.xml)ݒB<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;!-- WuĎ@\̎gpLݒB--&gt;<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;util:constant id=&quot;useMonitorable&quot; static-field=&quot;java.lang.Boolean.True&quot;/&gt;<br>
 * <br>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt!-- WuĎlݒB--&gt;<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;bean id=&quot;manageableJobSize&quot; class=&quot;java.lang.Integer&quot;&gt;<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;constructor-arg value=&quot;20&quot;/&gt;<br>
 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/bean&gt;<br>
 * 
 * @deprecated
 */
public class MBeanRegister {

    /**
     * OCX^XB
     */
    private static final Log log = LogFactory.getLog(MBeanRegister.class);

    /**
     * MBeanServerɓo^MBean̏lB
     */
    private static int manageableJobSize = 0;

    /**
     * MBean 𑀍삷邽߂̃CX^XB
     */
    private MBeanServer server = null;

    /**
     * MBeanServerɓo^ꂽMBeanێ}bvB
     */
    private static Map<String, JobStatus> registerMBeanJobStatusMap = new ConcurrentHashMap<String, JobStatus>();

    /**
     * Wuo^̃JEgB
     */
    private static int mbeanCount = 0;

    /**
     * MBeanServerɓo^ꂽeWuMBeanێ}bvB
     */
    private static Queue<String> registerParentObjectName = new ConcurrentLinkedQueue<String>();
    
    /**
     * MBeanServerɓo^ꂽqWuMBeanێ}bvB
     */
    private static Queue<String> registerChildObjectName = new ConcurrentLinkedQueue<String>();
        
    /**
     * RXgN^B
     *
     */
    public MBeanRegister() {
        server = ManagementFactory.getPlatformMBeanServer();
    }

    /**
     * MBeanServerJobResult(mbean)o^B
     *
     * @param jobStatus WuXe[^X
     */
    public void registerMBean(JobStatus jobStatus) {

        if (jobStatus.getJobId() == null) {
            return;
        }
        
        try {
            // o^𒴂ꍇ͓o^
            if (mbeanCount >= manageableJobSize) {
                unregisterMBean();
            }

            // o^擾
            String name = getRegistName(jobStatus);

            if (((ConcurrentMap<String, JobStatus>) registerMBeanJobStatusMap)
                    .putIfAbsent(name, jobStatus) == null) {
                server.registerMBean(jobStatus, ObjectName.getInstance(name));
                mbeanCount++;
                
                if (log.isDebugEnabled()) {
                    log.debug("[" + name + "] MBean was registered");
                }
            } else {
                log.warn("It wasn't registered becasuse MBean name [" + name + "] overlapped.");
            }
            
        } catch (MalformedObjectNameException e) {
            log.error(e.getMessage(), e);
        } catch (MBeanRegistrationException e) {
            log.error(e.getMessage(), e);
        } catch (NotCompliantMBeanException e) {
            log.error(e.getMessage(), e);
        } catch (InstanceAlreadyExistsException e) {
            log.error(e.getMessage(), e);
        } catch (AttributeNotFoundException e) {
            log.error(e.getMessage(), e);
        } catch (InstanceNotFoundException e) {
            log.error(e.getMessage(), e);
        } catch (MBeanException e) {
            log.error(e.getMessage(), e);
        } catch (ReflectionException e) {
            log.error(e.getMessage(), e);
        }
    }

    /**
     * MBeano^𐶐AԋpB
     * 
     * <p>
     * eWu̓o^<br>
     * uJOB:name=WuIDv ܂<br>
     * uJOB:name=WuID_WuNGXgNoviWuNGXgNo󕶎ȊO
     *  ̏ꍇjłA qWu̓o^<br>
     * ueWu̓o^,name2=L[v ƂȂB
     * </p>
     * 
     * @param jobStatus
     *            WuXe[^X
     * @return MBeano^
     */
    private String getRegistName(JobStatus jobStatus) {
    
        StringBuilder name = new StringBuilder();
        name.append("JOB:name=");
        name.append(jobStatus.getJobId());

        if (!"".equals(jobStatus.getJobRequestNo())) {
            name.append("_");
            name.append(jobStatus.getJobRequestNo());
        }

        if (!registerParentObjectName.contains(name.toString())) {
            registerParentObjectName.add(name.toString());
        }

        // qWȕꍇ͓o^̊Kw𕪂
        if (jobStatus.getPartitionNo() != -1) {
            name.append(",name2=");
            name.append(jobStatus.getPartitionKey().replaceAll(":", ""));
            registerChildObjectName.add(name.toString());
        }
        
        return name.toString();
    }

    /**
     * MBean̓o^B
     * 
     * <p>
     * o^<code>manageableJobSize</code>𒴂ꍇA
     * o^ÂWuԂÎ̂B<br>
     * IԂ̃Wuꍇ́AIԂɊ֌WȂ
     * o^ÂqWuB
     * </p>
     * 
     * @throws NullPointerException
     *         ObjectNamënull̏ꍇ
     * @throws MalformedObjectNameException
     *         ObjectNamë̌̕`Ȃꍇ
     * @throws ReflectionException 
     *         ݒ胁\bȟĂяoɃX[
     *         java.lang.Exception bvꍇ
     * @throws MBeanException 
     *         MBean̎擾\bhɂăX[Obvꍇ 
     * @throws InstanceNotFoundException
     *         w肳ꂽMBeanMBeanT[oɓo^ĂȂꍇ
     * @throws AttributeNotFoundException 
     *         MBean ̎w肳ꂽANZXs\łꍇ
     *
     */
    private void unregisterMBean() throws MalformedObjectNameException,
            NullPointerException, AttributeNotFoundException,
            InstanceNotFoundException, MBeanException, ReflectionException {

        if (registerMBeanJobStatusMap.isEmpty()) {
            return;
        }

        // o^ȂȂ ܂ 폜܂Ń[v
        LOOP : while (mbeanCount > 0) {

            // qWuŏIԂ̂̂邩
            for (String childName : registerChildObjectName) {
                JobStatus jobStatus = registerMBeanJobStatusMap.get(childName);
                if (jobStatus != null && jobStatus.getJobState().isEndStatus())
                {
                    if (deleteMBean(childName)) {
                        registerChildObjectName.remove(childName);
                        break LOOP;
                    }
                }
            }

            // eWuŏIԂ̂̂邩
            for (String parentName : registerParentObjectName) {
                JobStatus jobStatus = registerMBeanJobStatusMap.get(parentName);
                if (jobStatus != null && jobStatus.getJobState().isEndStatus())
                {
                    if (deleteMBean(parentName)) {
                        registerParentObjectName.remove(parentName);
                        break LOOP;
                    }
                }
            }

            // qWuŏIԂ̂̂ȂΌÂqWu폜
            if (!registerChildObjectName.isEmpty()) {
                if (deleteMBean(registerChildObjectName.poll())) {
                    break;
                }
            }

            // eWuŏIԂ̂̂ȂΌÂeWu폜
            if (!registerParentObjectName.isEmpty()) {
                if (deleteMBean(registerParentObjectName.poll())) {
                    break;
                }
            }
        }
    }


    /**
     * MBeanServerMBean폜B
     * 
     * @param registerName
     *            MBeano^
     * @return 폜Ȃtrue
     * @throws InstanceNotFoundException w肳ꂽMBean݂Ȃꍇ̗O
     * @throws MBeanRegistrationException MBeanRegistrationŔO
     * @throws MalformedObjectNameException
     *           ̌`LObjectNameɑΉĂȂꍇ̗O
     * @throws NullPointerException NullPointerException
     */
    private boolean deleteMBean(String registerName)
            throws InstanceNotFoundException, MBeanRegistrationException,
            MalformedObjectNameException, NullPointerException {

        if (registerName == null) {
            return false;
        }

        ObjectName objectName = new ObjectName(registerName);

        if (server.isRegistered(objectName)) {
            server.unregisterMBean(objectName);
            mbeanCount--;
            registerMBeanJobStatusMap.remove(registerName);
            if (log.isDebugEnabled()) {
                log.debug("[" + registerName + "] MBean was unregister");
            }
            return true;
        }

        return false;
    }
    
    /**
     * MBeanServerւ̓o^lݒ肷B
     * 
     * @param manageableJobSize
     *            o^l
     */
    public void setManageableJobSize(int manageableJobSize) {
        MBeanRegister.manageableJobSize = manageableJobSize;
    }
}
