/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.restart;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.QueueingException;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.core.WorkUnit;
import jp.terasoluna.fw.batch.core.Workable;
import jp.terasoluna.fw.batch.standard.QueueProcessor;

/**
 * X^[g̃L[pNXB
 *
 * <p>L[vfoAoꂼ̗vfp[^Ƃă[J
 * [NB</p>
 * 
 * <p>L[̍Ō̗vfł΃X^[gp[JNB
 * L[̍Ō̗vfł͂Ȃꍇ͒ʏ̃[JNB</p>
 *
 */
public class RestartQueueProcessor extends QueueProcessor {

    /**
     * {X^[g̓o^EXV郏[J[B
     */
    private Workable<WorkUnit> normalWorker = null;

    /**
     * {X^[g̃N[Y郏[J[B
     */
    private Workable<WorkUnit> restartWorker = null;

    /**
     * L[̏sB
     *
     * @param workQueue L[
     * @param jobStatus WuXe[^X
     */
    public void process(WorkQueue workQueue, JobStatus jobStatus) {
        printStartLog("RestartQueueProcessor processing START", jobStatus);

        //@ς݂̃L[̑Ovf(X^[gN[YŎgpŏIL[̗vf)
        WorkUnit preElement = null;

        while (true) {
            //  L[̗vf
            WorkUnit element = null;
        
            try {
                element = workQueue.take();
            } catch (QueueingException e) {
                // QueueingExceptionăWuԂsԂł͂Ȃ
                // RN^ňُ킪ĂƔfďIB
                // łȂ΁A[Jُ̈ƌȂėOthrowB
                if (!jobStatus.isExecuting()) {
                    break;
                }
                throw e;
            }
            
            if (element.isEndMark()) {
                // {X^[g̃N[Y
                if (preElement != null) {
                    restartWorker.work(preElement, jobStatus);
                }
                break;
            } else if (preElement != null) {
                // {X^[g̓o^EXV
                normalWorker.work(preElement, jobStatus);
            }

            if (!jobStatus.isContinue()) {
                break;
            }
            
            preElement = element;
        }

        printEndLog("RestartQueueProcessor processing END", jobStatus);
    }

    /**
     * {X^[g̓o^EXV郏[J[ݒ肷B
     *
     * @param worker {X^[g̓o^EXV郏[J[
     */
    public void setWorker(Workable<WorkUnit> worker) {
        this.normalWorker = worker;
    }

    /**
     * {X^[g̃N[Y郏[J[ݒ肷B
     *
     * @param restartWorker {X^[g̃N[Y郏[J[[J[
     */
    public void setRestartWorker(Workable<WorkUnit> restartWorker) {
        this.restartWorker = restartWorker;
    }

}
