/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.Var;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.fw.validation.FieldChecks;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.validation.FieldChecks} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * TERASOLUNA̓̓`FbN@\ŋʂɎgp錟؃[NXB
 * <p>
 *
 * @see jp.terasoluna.fw.validation.FieldChecks
 */
public class FieldChecksTest05 extends TestCase {

    /**
     * eXgpCX^XB
     */
    private ValidatorAction va = null;

    /**
     * eXgpCX^XB
     */
    private Field field = null;

    /**
     * eXgpCX^XB
     */
    private FieldChecks_ValidationErrorsImpl01 errors = null;

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FieldChecksTest05.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        va = new ValidatorAction();
        field = new Field();
        errors = new FieldChecks_ValidationErrorsImpl01();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public FieldChecksTest05(String name) {
        super(name);
    }

    /**
     * testValidateFloatRange01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beannull̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateFloatRange01() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateFloatRange(null, va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateFloatRange02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean󕶎̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateFloatRange02() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateFloatRange("", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateFloatRange03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * beanfloat^ɕϊłȂꍇAG[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateFloatRange03() throws Exception {
        // eXg{
        // 
        assertFalse(new FieldChecks().validateFloatRange("test", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("test", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateFloatRange04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"1.4E-45"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                floatRangeMin=null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varfloatRangeMinnull̏ꍇA͈͂̍ŏlFloat.MIN_VALUEł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateFloatRange04() throws Exception {
        // eXg{
        // 
        assertTrue(
                new FieldChecks().validateFloatRange("1.4E-45", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateFloatRange05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"1.4E-45"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                floatRangeMin=""<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varfloatRangeMin󕶎̏ꍇA͈͂̍ŏlFloat.MIN_VALUEł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateFloatRange05() throws Exception {
        // O
        Var var = new Var();
        var.setName("floatRangeMin");
        var.setValue("");
        field.addVar(var);

        // eXg{
        // 
        assertTrue(
                new FieldChecks().validateFloatRange("1.4E-45", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateFloatRange06()
     * <br><br>
     *
     * (n) or (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"3.4028235E38"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                floatRangeMax=null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varfloatRangeMaxnull̏ꍇA͈͂̍őlFloat.MAX_VALUEł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateFloatRange06() throws Exception {
        // eXg{
        // 
        assertTrue(
                new FieldChecks().validateFloatRange(
                        "3.4028235E38", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateFloatRange07()
     * <br><br>
     *
     * (n) or (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"3.4028235E38"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                floatRangeMax=""<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * varfloatRangeMax󕶎̏ꍇA͈͂̍őlFloat.MAX_VALUEł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateFloatRange07() throws Exception {
        // O
        Var var = new Var();
        var.setName("floatRangeMax");
        var.setValue("");
        field.addVar(var);

        // eXg{
        // 
        assertTrue(
                new FieldChecks().validateFloatRange(
                        "3.4028235E38", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateFloatRange08()
     * <br><br>
     *
     * (n) or (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"0.5E1"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                floatRangeMin="test"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file. - floatRangeMin is not number. You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file. - floatRangeMin is not number. You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * varfloatRangeMin̒lfloat^ɕϊłȂꍇAValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateFloatRange08() throws Exception {
        // O
        Var var = new Var();
        var.setName("floatRangeMin");
        var.setValue("test");
        field.addVar(var);

        // eXg{
        // 
        try {
            new FieldChecks().validateFloatRange("0.5E1", va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Mistake on validation definition file. " +
                    "- floatRangeMin is not number. You'll have to check " +
                    "it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateFloatRange09()
     * <br><br>
     *
     * (n) or (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"0.5E1"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                floatRangeMax="test"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file. - floatRangeMax is not number. You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file. - floatRangeMax is not number. You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * varfloatRangeMax̒lfloat^ɕϊłȂꍇAValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateFloatRange09() throws Exception {
        // O
        Var var = new Var();
        var.setName("floatRangeMax");
        var.setValue("test");
        field.addVar(var);

        // eXg{
        // 
        try {
            new FieldChecks().validateFloatRange("0.5E1", va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Mistake on validation definition file. " +
                    "- floatRangeMax is not number. You'll have to check " +
                    "it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateFloatRange10()
     * <br><br>
     *
     * (n) or (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"0.5E1"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                floatRangeMin="0.1E1"<br>
     *                floatRangeMax="0.1E2"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean̒lAfloatRangeMinfloatRangeMax͈͓̔̒l̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateFloatRange10() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("floatRangeMin");
        var1.setValue("0.1E1");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("floatRangeMax");
        var2.setValue("0.1E2");
        field.addVar(var2);

        // eXg{
        // 
        assertTrue(
                new FieldChecks().validateFloatRange("0.5E1", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);

    }

    /**
     * testValidateFloatRange11()
     * <br><br>
     *
     * (n) or (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"0.5E1"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                floatRangeMin="0.1E2"<br>
     *                floatRangeMax="0.1E3"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * bean̒lAfloatRangeMin̒l菬ꍇAG[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateFloatRange11() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("floatRangeMin");
        var1.setValue("0.1E2");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("floatRangeMax");
        var2.setValue("0.1E3");
        field.addVar(var2);

        // eXg{
        // 
        assertFalse(
                new FieldChecks().validateFloatRange("0.5E1", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("0.5E1", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateFloatRange12()
     * <br><br>
     *
     * (n) or (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"0.5E1"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                floatRangeMin="0.1E1"<br>
     *                floatRangeMax="0.4E1"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * bean̒lAfloatRangeMax̒l傫ꍇAG[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateFloatRange12() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("floatRangeMin");
        var1.setValue("0.1E1");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("floatRangeMax");
        var2.setValue("0.4E1");
        field.addVar(var2);

        // eXg{
        // 
        assertFalse(
                new FieldChecks().validateFloatRange("0.5E1", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("0.5E1", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));
    }

    /**
     * testValidateFloatRange13()
     * <br><br>
     *
     * (n) or (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"0.5E1"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                floatRangeMin="0.5E1"<br>
     *                floatRangeMax="0.5E1"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean̒lƁAfloatRangeMax,floatRangeMin̒lƓꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateFloatRange13() throws Exception {
        // O
        Var var1 = new Var();
        var1.setName("floatRangeMin");
        var1.setValue("0.5E1");
        field.addVar(var1);
        
        Var var2 = new Var();
        var2.setName("floatRangeMax");
        var2.setValue("0.5E1");
        field.addVar(var2);

        // eXg{
        // 
        assertTrue(
                new FieldChecks().validateFloatRange("0.5E1", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateMaxLength01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beannull̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMaxLength01() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateMaxLength(null, va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateMaxLength02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) return: true<br>
     *
     * <br>
     * varmaxlengthnull̏ꍇAValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMaxLength02() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateMaxLength("", va, field, errors));
        
        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateMaxLength03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                maxlength=null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file. - maxlength is not number. You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file. - maxlength is not number. You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * varmaxlengthnull̏ꍇAValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMaxLength03() throws Exception {
        // eXg{
        // 
        try {
            new FieldChecks().validateMaxLength("test", va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Mistake on validation definition file. " +
                    "- maxlength is not number. You'll have to check it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateMaxLength04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                maxlength=""<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file. - maxlength is not number. You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file. - maxlength is not number. You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * varmaxlength󕶎̏ꍇAValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMaxLength04() throws Exception {
        // O
        Var var = new Var();
        var.setName("maxlength");
        var.setValue("");
        field.addVar(var);

        // eXg{
        // 
        try {
            new FieldChecks().validateMaxLength("test", va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Mistake on validation definition file. " +
                    "- maxlength is not number. You'll have to check it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateMaxLength05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                maxlength="abc"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file. - maxlength is not number. You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file. - maxlength is not number. You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * varmaxlengthlɕϊłȂꍇAValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMaxLength05() throws Exception {
        // O
        Var var = new Var();
        var.setName("maxlength");
        var.setValue("abc");
        field.addVar(var);

        // eXg{
        // 
        try {
            new FieldChecks().validateMaxLength("test", va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Mistake on validation definition file. " +
                    "- maxlength is not number. You'll have to check it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateMaxLength06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                maxlength="5"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * ͂ꂽ̌Avarmaxlength̒l菬ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMaxLength06() throws Exception {
        // O
        Var var = new Var();
        var.setName("maxlength");
        var.setValue("5");
        field.addVar(var);

        // eXg{
        // 
        assertTrue(new FieldChecks().validateMaxLength("test", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);

    }

    /**
     * testValidateMaxLength07()
     * <br><br>
     *
     * (n) or (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                maxlength="3"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * ͂ꂽ̌Avarmaxlength̒l傫ꍇAG[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMaxLength07() throws Exception {
        // O
        Var var = new Var();
        var.setName("maxlength");
        var.setValue("3");
        field.addVar(var);

        // eXg{
        // 
        assertFalse(new FieldChecks().validateMaxLength("test", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("test", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));

    }

    /**
     * testValidateMaxLength08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                maxlength="4"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * ͂ꂽ̌Avarmaxlength̒lƓꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMaxLength08() throws Exception {
        // O
        Var var = new Var();
        var.setName("maxlength");
        var.setValue("4");
        field.addVar(var);

        // eXg{
        // 
        assertTrue(new FieldChecks().validateMaxLength("test", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);

    }

    /**
     * testValidateMinLength01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beannull̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMinLength01() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateMinLength(null, va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateMinLength02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) return : true<br>
     *
     * <br>
     * varminlengthnull̏ꍇAValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMinLength02() throws Exception {
        // eXg{
        // 
        assertTrue(new FieldChecks().validateMinLength("", va, field, errors));
     
        // addErrorsmF
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateMinLength03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                minlength=null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - minlength is not number.
     *                    You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - minlength is not number.
     *                    You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * varminlengthnull̏ꍇAValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMinLength03() throws Exception {
        // eXg{
        // 
        try {
            new FieldChecks().validateMinLength("test", va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Mistake on validation definition file. " +
                    "- minlength is not number. You'll have to check it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateMinLength04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                minlength=""<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - minlength is not number.
     *                    You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - minlength is not number.
     *                    You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * varminlength󕶎̏ꍇAValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMinLength04() throws Exception {
        // O
        Var var = new Var();
        var.setName("minlength");
        var.setValue("");
        field.addVar(var);

        // eXg{
        // 
        try {
            new FieldChecks().validateMinLength("test", va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Mistake on validation definition file. " +
                    "- minlength is not number. You'll have to check it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateMinLength05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                minlength="abc"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - minlength is not number.
     *                    You'll have to check it over. "<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"Mistake on validation definition file.
     *                    - minlength is not number.
     *                    You'll have to check it over. ", new NumberFormatException()<br>
     *
     * <br>
     * varminlengthlɕϊłȂꍇAValidatorException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMinLength05() throws Exception {
        // O
        Var var = new Var();
        var.setName("minlength");
        var.setValue("abc");
        field.addVar(var);

        // eXg{
        // 
        try {
            new FieldChecks().validateMinLength("test", va, field, errors);
            fail();
        } catch (ValidatorException e) {
            String message = "Mistake on validation definition file. " +
                    "- minlength is not number. You'll have to check it over. ";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message, new NumberFormatException()));
        }
    }

    /**
     * testValidateMinLength06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                minlength="3"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * ͂ꂽ̌Avarminlength̒l傫ꍇA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMinLength06() throws Exception {
        // O
        Var var = new Var();
        var.setName("minlength");
        var.setValue("3");
        field.addVar(var);

        // eXg{
        // 
        assertTrue(new FieldChecks().validateMinLength("test", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);

    }

    /**
     * testValidateMinLength07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                minlength="5"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂ
     *                           addErrorsĂяoB<br>
     *
     * <br>
     * ͂ꂽ̌Avarminlength̒l菬ꍇA
     * G[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMinLength07() throws Exception {
        // O
        Var var = new Var();
        var.setName("minlength");
        var.setValue("5");
        field.addVar(var);

        // eXg{
        // 
        assertFalse(new FieldChecks().validateMinLength("test", va, field, errors));

        // addErrorsmF
        assertEquals(1, errors.addErrorCount);
        assertEquals("test", errors.beanList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(field, errors.fieldList.get(0));

    }

    /**
     * testValidateMinLength08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                minlength="4"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * ͂ꂽ̌Avarminlength̒lƓꍇA
     * trueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMinLength08() throws Exception {
        // O
        Var var = new Var();
        var.setName("minlength");
        var.setValue("4");
        field.addVar(var);

        // eXg{
        // 
        assertTrue(new FieldChecks().validateMinLength("test", va, field, errors));

        // addErrorsmF
        assertEquals(0, errors.addErrorCount);

    }

}
