/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.restart;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.restart.JobRestartInfo;
import jp.terasoluna.fw.batch.restart.JobRestartInfoFactory;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;

public class JobRestartTableHandler {
    private static final String JOB_END_STATE = "2";
    private static final String JOB_START_STATE = "1";
    private static final String INSERT_JOB_RESTART_POINT = "jobRestart.INSERT_JOB_RESTART_POINT";
    private static final String UPDATE_JOB_RESTART_POINT = "jobRestart.UPDATE_JOB_RESTART_POINT";
    private JobRestartInfoFactory jobRestartInfoFactory = null;
    private QueryDAO queryDAO = null;
    private UpdateDAO updateDAO = null;

    public JobContext getRestartJobContext(JobContext jobContext, JobStatus jobStatus) {
        JobRestartInfo jobRestartInfo = this.jobRestartInfoFactory.getInstance();
        this.initJobRestartInfo(jobRestartInfo, jobContext, jobStatus);
        jobRestartInfo.setState(JOB_START_STATE);
        JobRestartInfo restoreJobRestartInfo = (JobRestartInfo)this.queryDAO.executeForObject("jobRestart.SELECT_JOB_RESTART_INFO", (Object)jobRestartInfo, JobRestartInfo.class);
        if (restoreJobRestartInfo == null) {
            jobContext.setRestarted(false);
            jobStatus.setJobState(JobStatus.STATE.STARTED);
            return jobContext;
        }
        if (JOB_END_STATE.equals(restoreJobRestartInfo.getState())) {
            jobStatus.setJobState(JobStatus.STATE.ENDING_NORMALLY);
            return jobContext;
        }
        JobContext newjobContext = this.changeByteToJobContext(restoreJobRestartInfo.getJobContext());
        newjobContext.setRestartPoint(restoreJobRestartInfo.getRestartPoint());
        jobStatus.setRestartPoint(restoreJobRestartInfo.getRestartPoint());
        newjobContext.setRestarted(true);
        jobStatus.setJobState(JobStatus.STATE.RESTARTED);
        return newjobContext;
    }

    public void registerRestartPoint(JobContext jobContext, JobStatus jobStatus) {
        if (!jobStatus.isRestartable()) {
            return;
        }
        JobRestartInfo jobRestartInfo = this.jobRestartInfoFactory.getInstance();
        this.initJobRestartInfo(jobRestartInfo, jobContext, jobStatus);
        jobRestartInfo.setRestartPoint(jobStatus.getRestartPoint());
        jobRestartInfo.setState(JOB_START_STATE);
        if (this.queryDAO.executeForObject("jobRestart.SELECT_JOB_RESTART_INFO", (Object)jobRestartInfo, JobRestartInfo.class) != null) {
            this.updateRestartPoint(jobRestartInfo);
        } else {
            this.insertRestartPoint(jobRestartInfo);
        }
    }

    public void setJobRestartInfoFactory(JobRestartInfoFactory jobRestartInfoFactory) {
        this.jobRestartInfoFactory = jobRestartInfoFactory;
    }

    public void setQueryDAO(QueryDAO queryDAO) {
        this.queryDAO = queryDAO;
    }

    public void setUpdateDAO(UpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }

    public int restartPointClear(JobStatus jobStatus, String sqlkey) {
        JobRestartInfo jobRestartInfo = this.jobRestartInfoFactory.getInstance();
        jobRestartInfo.setRequestNo(jobStatus.getJobRequestNo());
        jobRestartInfo.setJobId(jobStatus.getJobId());
        jobRestartInfo.setPartitionNo(jobStatus.getPartitionNo());
        jobRestartInfo.setState(JOB_END_STATE);
        return this.updateDAO.execute(sqlkey, (Object)jobRestartInfo);
    }

    protected void initJobRestartInfo(JobRestartInfo jobRestartInfo, JobContext jobContext, JobStatus jobStatus) {
        if (jobContext == null) {
            throw new IllegalArgumentException("JobContext is NULL");
        }
        jobRestartInfo.setRequestNo(jobStatus.getJobRequestNo());
        jobRestartInfo.setJobId(jobStatus.getJobId());
        jobRestartInfo.setPartitionNo(jobStatus.getPartitionNo());
        jobRestartInfo.setPartitionKey(jobStatus.getPartitionKey());
        jobRestartInfo.setJobContext(this.changeJobContextToByte(jobContext));
    }

    protected byte[] changeJobContextToByte(JobContext jobContext) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(byteOut);
            out.writeObject(jobContext);
        }
        catch (IOException e) {
            throw new JobException(e);
        }
        return byteOut.toByteArray();
    }

    protected JobContext changeByteToJobContext(byte[] obj) {
        try {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(obj);
            ObjectInputStream in = new ObjectInputStream(byteIn);
            return (JobContext)in.readObject();
        }
        catch (IOException e) {
            throw new JobException(e);
        }
        catch (ClassNotFoundException e) {
            throw new JobException(e);
        }
    }

    private int insertRestartPoint(JobRestartInfo jobRestartInfo) {
        return this.updateDAO.execute(INSERT_JOB_RESTART_POINT, (Object)jobRestartInfo);
    }

    private int updateRestartPoint(JobRestartInfo jobRestartInfo) {
        return this.updateDAO.execute(UPDATE_JOB_RESTART_POINT, (Object)jobRestartInfo);
    }
}

