/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.springsupport.transaction;

import jp.terasoluna.fw.batch.core.Chunk;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.Workable;
import jp.terasoluna.fw.batch.springsupport.transaction.TransactionalJobStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionalWorker
implements Workable<Chunk> {
    private Workable<Chunk> jobWorker = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void work(Chunk chunk, JobStatus jobStatus) {
        TransactionalJobStatus transactionalJobStatus = (TransactionalJobStatus)jobStatus;
        transactionalJobStatus.beginTransaction();
        if (transactionalJobStatus.useSavepoint()) {
            transactionalJobStatus.releaseAndCreateSavepoint();
        }
        boolean commitFlag = false;
        try {
            this.jobWorker.work(chunk, transactionalJobStatus);
            commitFlag = true;
        }
        finally {
            if (commitFlag && jobStatus.isNormallyState()) {
                transactionalJobStatus.commit();
            } else if (transactionalJobStatus.useSavepoint()) {
                transactionalJobStatus.rollbackToSavepoint();
                transactionalJobStatus.commit();
            } else {
                transactionalJobStatus.rollback();
            }
        }
        if (jobStatus.isShutdownGraceful() || jobStatus.isShutdownImmediate()) {
            jobStatus.suspend();
            return;
        }
    }

    public void setJobWorker(Workable<Chunk> jobWorker) {
        this.jobWorker = jobWorker;
    }
}

