/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.service.thin;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.beanutils.MethodUtils;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.fw.util.PropertyAccessException;
import jp.terasoluna.fw.util.ClassUtil;
import jp.terasoluna.fw.util.BeanUtil;
import jp.terasoluna.fw.util.StringUtil;

/**
 * rWlXWbNo͏񔽉fۃNXB
 *
 * <p>
 *  rWlXWbNo͏ێBLogicResourcesƂɁA
 *  Webw̃IuWFNgƁArWlXWbNԂ̃f[^̃}bsOs@\
 *  W񂵂ۃNXłBSẴrWlXWbNo͏񔽉fNX
 *  ̃NXpĎB
 *  AbstractBLogicMapper̎Ȗ́Aȉ̂Q
 *  <ul>
 *   <li>BLogicResources̐ݒ肩AANVƂ
 *    rWlXWbN̓͏NXƂȂJavaBean
 *    𐶐@\񋟂</li>
 *   <li>rWlXWbN̏o͏NXł
 *    BLogicResultpABLogicResources̐ݒ肩A
 *    Webw̃IuWFNgɔf@\񋟂</li>
 *  </ul>
 * </p>
 * <p>
 *  AbstractBLogicMapper̃TuNXƂāA
 *  ftHgłBLogicMapper񋟂Ă邪A
 *  ̋@\u邱ƂłB
 *  ̍ہAAbstractBLogicMapper܂BLogicMapper
 *  prWlXWbNo͏񔽉fNX쐬KvB
 *  grWlXWbNo͏񔽉fNXł́A
 *  blogic-io.xmlsourcerequestAsessionAapplicationA
 *  destrequestAsessionȊO̔Cӂ̕
 *  w肵ꍇ̓͒l擾Ao͒lfB<br>
 *  ͒l擾̃\bh́A
 *  "getValueFrom" + sourceɎw肷镶ƂB
 *  source"factory"Ǝw肷ꍇA\bhgetValueFromFactoryƂȂB
 *  ͑SĂ̓͒l擾\bhŋʂŁA
 *  getValueFromForm()\bhƓƂB<br>
 *  o͒lf̃\bh́A
 *  "setValueTo" + destɎw肷镶ƂB
 *  dest"factory"Ǝw肷ꍇA\bhgetValueToFactoryƂȂB
 *  ͑SĂ̏o͒lf\bhŋʂŁA
 *  getValueToForm()\bhƓƂB<br>
 *  AftHgBLogicMapperT|[grequestAsessionAapplication
 *  ꂼANGXgAZbVAT[ubgReLXg
 *  ΏۂɂĂB
 * </p>
 * <p>
 *  Strutsgpꍇ̃rWlXWbNo͏񔽉fNX̓ւE
 *  struts-config.xml̋Lq@ɂẮABLogicIOPlugInQƂ̂ƁB
 * </p>
 *
 * @see jp.terasoluna.fw.service.thin.BLogicMapper
 * @see jp.terasoluna.fw.web.struts.plugins.BLogicIOPlugIn
 * @see jp.terasoluna.fw.service.thin.BLogicResult
 * @see jp.terasoluna.fw.service.thin.BLogicIO
 * @see jp.terasoluna.fw.service.thin.BLogicProperty
 * @see jp.terasoluna.fw.service.thin.BLogicResources
 * @see jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction
 * @see jp.terasoluna.fw.web.struts.actions.BLogicAction
 *
 */
public abstract class AbstractBLogicMapper {


    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(AbstractBLogicMapper.class);

    /**
     * BLogicResultnullꍇ̃G[R[hB
     */
    private static final String NULL_RESULT_KEY =
        "errors.blogic.mapper.result";

    /**
     * ͒l̎擾̎wɌ肪ꍇ̃G[R[hB
     */
    private static final String ERROR_SOURCE =
        "errors.blogic.mapper.source";

    /**
     * o͒l̐ݒ̎wɌ肪ꍇ̃G[R[hB
     */
    private static final String ERROR_DEST =
        "errors.blogic.mapper.dest";

    /**
     * rWlXWbNɓ͂JavaBean̐Ɏsꍇ̃G[R[hB
     */
    private static final String ERROR_BEAN_CREATE =
        "errors.blogic.mapper.create";

    /**
     * vpeBlJavaBean擾łȂꍇ̃G[R[hB
     */
    private static final String ERROR_GETPROPERTY =
        "errors.blogic.mapper.getproperty";

    /**
     * vpeBlJavaBeanɐݒłȂꍇ̃G[R[hB
     */
    private static final String ERROR_SETPROPERTY =
        "errors.blogic.mapper.setproperty";

    /**
     * l͌̃CX^X擾łȂꍇ̃G[R[hB
     */
    private static final String ERROR_GETVALUE =
        "errors.blogic.mapper.getvalue";

    /**
     * lo͐̃CX^XɔfłȂꍇ̃G[R[hB
     */
    private static final String ERROR_SETVALUE =
        "errors.blogic.mapper.setvalue";

    /**
     * ʔfionullȂ̂result.getResultObject()Ŏ擾lnullłȂ
     * ꍇ̃G[R[hB
     */
    private static final String ERROR_BEAN_NOTNULL =
        "errors.blogic.mapper.notnull";

    /**
     * Webw̃IuWFNgɊi[ꂽlJavaBeanɃ}bsOB
     *
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @param io rWlXWbNo͏
     * @return WebwɊi[ꂽKvȃp[^SĊi[JavaBeanAio
     * NXw肳ĂȂꍇnullԋpB
     */
    public Object mapBLogicParams(HttpServletRequest request,
            HttpServletResponse response, BLogicIO io) {
        if (io == null) {
            // ionull̏ꍇAnullԋp
            return null;
        }

        if (io.getInputBeanName() == null) {
            // Beanw肳ĂȂꍇnullԋpB
            if (log.isDebugEnabled()) {
                log.debug("blogic-io.inputBeanName is null.");
            }
            return null;
        }

        // Ce[^[̐
        Iterator it = io.getBLogicParams().iterator();

        // ߂lŕԂJavaBean̐
        Object bean = null;
        // blogic-ioblogic-paramsݒ肳Ăꍇ̂݃CX^X쐬
        if (it.hasNext()) {
            try {
                bean = ClassUtil.create(io.getInputBeanName());
            } catch (ClassLoadException e) {
                log.error("bean creation failure.");
                throw new SystemException(e, ERROR_BEAN_CREATE);
            }
        } else {
            return null;
        }

        // List̑SĂBLogicPropertyCX^XɂāAs
        while (it.hasNext()) {

            // BLogicPropertyCX^X擾
            BLogicProperty property = (BLogicProperty) it.next();
            // vpeB擾
            String propertyName = property.getProperty();

            // rWlXWbNŎgpvpeB擾
            String blogicPropertyName = property.getBLogicProperty();

            // blogicPropertyNameݒ̏ꍇApropertyName
            if (blogicPropertyName == null) {
                blogicPropertyName = propertyName;
            }

            // ͒li[̔sAJavaBeanɊi[
            if (!"".equals(property.getSource())
                    && property.getSource() != null) {
                // N͒lݒ胁\bhɑ΂̔z
                Object[] methodParams = new Object[] { propertyName, request,
                        response };
                Class[] parameterTypes = new Class[] { String.class,
                        HttpServletRequest.class, HttpServletResponse.class };
                Object value = null;
                try {
                    // ͒l擾s
                    value = MethodUtils.invokeMethod(this, "getValueFrom"
                            + StringUtil
                                    .capitalizeInitial(property.getSource()),
                            methodParams, parameterTypes);
                } catch (NoSuchMethodException e) {
                    log.error("no such method.");
                    throw new SystemException(new BLogicMapperException(e),
                            ERROR_GETVALUE, new String[] { propertyName });
                } catch (IllegalAccessException e) {
                    log.error("illegal access to the method.");
                    throw new SystemException(new BLogicMapperException(e),
                            ERROR_GETVALUE, new String[] { propertyName });
                } catch (InvocationTargetException e) {
                    log.error("exception is thrown out by invokeMethod.");
                    throw new SystemException(new BLogicMapperException(e),
                            ERROR_GETVALUE, new String[] { propertyName });
                }

                try {
                    // ͒lݒ胁\bhs
                    BeanUtil.setBeanProperty(bean, blogicPropertyName, value);
                } catch (PropertyAccessException e) {
                    log.error("setBeanProperty failure.");
                    throw new SystemException(new BLogicMapperException(e),
                            ERROR_SETPROPERTY,
                            new String[] { blogicPropertyName });
                }

            } else {
                // i[̎w肪ԈĂ邽ߗOX[
                log.error("source is illegal.");
                throw new SystemException(new BLogicMapperException(),
                        ERROR_SOURCE);
            }
        }
        return bean;
    }

    /**
     * NGXgw肳ꂽvpeBl擾B
     *
     * @param propName vpeB
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @return vpeBl
     */
    public abstract Object getValueFromRequest(String propName,
            HttpServletRequest request, HttpServletResponse response);

    /**
     * ZbVw̃vpeBL[ɒl擾B
     *
     * @param propName vpeB
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @return vpeBl
     */
    public abstract Object getValueFromSession(String propName,
            HttpServletRequest request, HttpServletResponse response);

    /**
     * BLogicIOɏ]AWebw̃IuWFNgɒli[B
     *
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @param io rWlXWbNo͏
     * @param result rWlXWbN̏o͏
     */
    public void mapBLogicResult(HttpServletRequest request,
                                          HttpServletResponse response,
                                          BLogicIO io,
                                          BLogicResult result) {
        // BLogicResultnull`FbN
        if (result == null) {
            log.error("BLogicResult is null.");
            throw new SystemException(new BLogicMapperException(
                    new NullPointerException()), NULL_RESULT_KEY);
        }

        // resultJavaBean擾
        Object bean = result.getResultObject();

        // ioݒȂ̂ɁAbeani[Ăꍇ̃`FbN
        if (io == null) {
            if (bean != null) {
                if (log.isDebugEnabled()) {
                    log.debug("The bean should be null.");
                }
                log.error("bean is not null.");
                throw new SystemException(new BLogicMapperException(),
                        ERROR_BEAN_NOTNULL);
            }
            // ȍ~͍̏sȂȂ
            return;
        }

        // Ce[^[̐
        Iterator it = io.getBLogicResults().iterator();

        // blogic-resultݒȂ̂ɁAbeani[Ăꍇ̃`FbN
        if (!it.hasNext()) {
            if (bean != null) {
                if (log.isDebugEnabled()) {
                    log.debug("The bean should be null.");
                }
                log.error("bean is not null.");
                throw new SystemException(new BLogicMapperException(),
                        ERROR_BEAN_NOTNULL);
            }
            // ȍ~͍̏sȂȂ
            return;
        }

        // List̑SĂBLogicPropertyNXCX^XɂāAs
        while (it.hasNext()) {

            // BLogicPropertyCX^X擾
            BLogicProperty property = (BLogicProperty) it.next();

            // vpeB擾
            String propertyName = property.getProperty();

            // rWlXWbNŎgpvpeB擾
            String blogicPropertyName = property.getBLogicProperty();

            // blogicPropertyNameݒ̏ꍇApropertyName
            if (blogicPropertyName == null) {
                blogicPropertyName = propertyName;
            }

            if (!"".equals(property.getDest()) && property.getDest() != null) {

                Object value = null;
                try {
                    // o͒l擾\bhs
                    value = BeanUtil.getBeanProperty(bean, blogicPropertyName);
                } catch (PropertyAccessException e) {
                    log.error("getBeanProperty failure.");
                    throw new SystemException(new BLogicMapperException(e),
                            ERROR_GETPROPERTY,
                            new String[] { blogicPropertyName });
                }

                // i[̔sAo͒li[
                Object[] methodParams = new Object[] { value, propertyName,
                       request, response };
                Class[] parameterTypes = new Class[] { Object.class,
                        String.class, HttpServletRequest.class,
                        HttpServletResponse.class };
                try {
                    MethodUtils.invokeMethod(this, "setValueTo"
                            + StringUtil
                                    .capitalizeInitial(property.getSource()),
                            methodParams, parameterTypes);
                } catch (NoSuchMethodException e) {
                    log.error("no such method.");
                    throw new SystemException(new BLogicMapperException(e),
                            ERROR_SETVALUE, new String[] { propertyName });
                } catch (IllegalAccessException e) {
                    log.error("illegal access to the method.");
                    throw new SystemException(new BLogicMapperException(e),
                            ERROR_SETVALUE, new String[] { propertyName });
                } catch (InvocationTargetException e) {
                    log.error("exception is thrown out by invokeMethod.");
                    throw new SystemException(new BLogicMapperException(e),
                            ERROR_SETVALUE, new String[] { propertyName });
                }
            } else {
                // i[̎w肪ԈĂ邽߁AOX[
                log.error("dest is illegal.");
                throw new SystemException(new BLogicMapperException(),
                        ERROR_DEST);
            }
        }
    }

    /**
     * NGXg̎w肳ꂽvpeBɒli[B
     *
     * @param value o͒l
     * @param propName vpeB
     * @param request HTTPNGXg
     * @param response HTTPX|X
     */
    public abstract void setValueToRequest(Object value, String propName,
            HttpServletRequest request, HttpServletResponse response);

    /**
     * ZbVɎw̃vpeBL[ɒli[B
     *
     * @param value o͒l
     * @param propName vpeB
     * @param request HTTPNGXg
     * @param response HTTPX|X
     */
    public abstract void setValueToSession(Object value, String propName,
            HttpServletRequest request, HttpServletResponse response);

    /**
     * T[ubgReLXgw肳ꂽvpeBl擾B
     *
     * @param propName vpeB
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @return vpeBl
     */
    public abstract Object getValueFromApplication(String propName,
            HttpServletRequest request, HttpServletResponse response);

}
