/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

/**
 * DataSource ̃bNAbvNXB
 * <BR><BR>
 * getConnection() ĂяoƁAutlib.conf Őݒ肵 JDBC Connection
 * ̃CX^X߂悤ɂȂĂB
 * 
 */
public class MockDataSource implements DataSource {

    /**
     * OC^[B
     */
    protected PrintWriter logWriter = null;

    /**
     * OC^CAEglB
     */
    protected int loginTimeout = 0;

    /**
     * ڑIuWFNg̎擾B
     * UTConnectionWrapper̗B̃CX^XԋpĂB
     * 
     * @see javax.sql.DataSource#getConnection()
     */
    public Connection getConnection() throws SQLException {
        return DBConnectionWrapper.getInstance();
    }

    /**
     * T|[gĂȂB
     * @see javax.sql.DataSource#getConnection(String, String)
     */
    public Connection getConnection(String arg0, String arg1)
        throws SQLException {

        throw new SQLException("getConnection(String,String) IS Not Supported");

    }

    /**
     * @see javax.sql.DataSource#getLogWriter()
     */
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    /**
     * @see javax.sql.DataSource#setLogWriter(PrintWriter)
     */
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.logWriter = logWriter;
    }

    /**
     * @see javax.sql.DataSource#getLoginTimeout()
     */
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    /**
     * @see javax.sql.DataSource#setLoginTimeout(int)
     */
    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.loginTimeout = loginTimeout;
    }

}
