/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;


/**
 *  HttpServletResponse ̃bNAbvNXB
 * <BR><BR>
 * ɁAActionNXeXgۂɗpB
 * 
 * <pre>
 * [gp]
 * // p[^̗p
 * ActionMapping mapping = new ActionMapping();
 * SampleActionForm form = new SampleActionForm();
 * MockHttpServletRequest req = new MockHttpServletRequest();
 * MockHttpServletResponse res = new MockHttpServletResponse();
 * 
 * // perform̌Ăяo
 * SampleAction action = new SampleAction();
 * action.execute(mapping, form, req, res);
 * </pre>
 * 
 */
public class MockHttpServletResponse extends MockServletResponse
                                      implements HttpServletResponse {

    /**
     * Cookie
     */
    private List cookies = new ArrayList();

    /**
     * Httpwb_i[Map
     */
    private Map httpHeaderMap = new HashMap();

    /**
     * GR[fBOw肳ꂽURL
     */
    private String encodeURL = null;

    /**
     * _CNgw肳ꂽGR[fBOURL
     */
    private String encodeRedirectURL = null;

    /**
     * bZ[W
     */
    private String message = null;

    /**
     * ԃR[h
     */
    private int status = -1;

    /**
     * P[V
     */
    private String location = null;

    /**
     * @see javax.servlet.http.HttpServletResponse#addCookie(Cookie)
     */
    public void addCookie(Cookie cookie) {
        cookies.add(cookie);
    }
    
    /**
     * Cookie擾B
     * 
     * @return cookies ĂCookieQ
     */
    public List getCookies() {
        return cookies;
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#containsHeader(String)
     */
    public boolean containsHeader(String name) {
        if (httpHeaderMap.get(name) == null) {
            return false;
        }
        return true;
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#encodeURL(String)
     */
    public String encodeURL(String url) {
        encodeURL = url;
        return encodeURL;
    }

    /**
     * GR[fBOw肳ꂽURL擾B
     * 
     * @return URL
     */
    public String getEncodeURL() {
        return encodeURL;
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#encodeURL(String)
     */
    public String encodeRedirectURL(String url) {
        encodeRedirectURL = url;
        return encodeRedirectURL;
    }

    /**
     * _CNgw肳ꂽURLGR[fBO擾B
     *
     * @return _CNgw肳ꂽURLGR[fBO
     */
    public String getEncodeRedirectURL() {
        return encodeRedirectURL;
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#encodeUrl(String)
     */
    public String encodeUrl(String url) {
        throw new UnsupportedOperationException(
            "encodeUrl() IS Not Supported!");
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#encodeRedirectUrl(String)
     */
    public String encodeRedirectUrl(String url) {
        throw new UnsupportedOperationException(
            "encodeRedirectUrl() IS Not Supported!");
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#sendError(int, String)
     */
    public void sendError(int sc, String msg) throws IOException {
        if (isCommitted()) {
            throw new IllegalStateException();
        }
        this.status = sc;
        this.message = msg;
    }

    /**
     * G[bZ[W擾B
     *
     * @return message bZ[W
     */
    public String getErrorMessage() {
        return this.message;
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#sendError(int)
     */
    public void sendError(int sc) throws IOException {
        if (isCommitted()) {
            throw new IllegalStateException();
        }
        this.status = sc;
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#sendRedirect(String)
     */
    public void sendRedirect(String location)
                  throws IOException {
        this.location = location;
    }

    /**
     * _CNg擾B
     * 
     * @return _CNg̕
     */
    public String getRedirect() {
        return this.location;
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#setDateHeader(String,long)
     */
    public void setDateHeader(String name, long date) {
        throw new UnsupportedOperationException(
            "setDateHeader() IS Not Supported!");
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#addDateHeader(String,long)
     */
    public void addDateHeader(String name, long date) {
        throw new UnsupportedOperationException(
            "addDateHeader() IS Not Supported!");
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#setHeader(String,String)
     */
    public void setHeader(String name, String value) {
        if (value != null) {
            httpHeaderMap.put(name, value);
        } else {
            httpHeaderMap.remove(name);
        }
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#addHeader(String,String)
     */
    public void addHeader(String name, String value) {
        if (value != null) {
            httpHeaderMap.put(name, value);
        } else {
            httpHeaderMap.remove(name);
        }
    }
    
    /**
     * @see javax.servlet.http.HttpServletResponse#setIntHeader(String,int)
     */
    public void setIntHeader(String name, int value) {
        Integer intValue = new Integer(value);
        if (intValue != null) {
            httpHeaderMap.put(name, intValue);
        } else {
            httpHeaderMap.remove(name);
        }
    }
    
    /**
     * @see javax.servlet.http.HttpServletResponse#addIntHeader(String,int)
     */
    public void addIntHeader(String name, int value) {
        Integer intValue = new Integer(value);
        if (intValue != null) {
            httpHeaderMap.put(name, intValue);
        } else {
            httpHeaderMap.remove(name);
        }
    }
    
    /**
     * @see javax.servlet.http.HttpServletResponse#setStatus(int)
     */
    public void setStatus(int sc) {
        this.status = sc;
    }

    /**
     * ԃR[h擾B
     *
     * @return ԃR[h
     */
    public int getStatus() {
        return this.status;
    }

    /**
     * @see javax.servlet.http.HttpServletResponse#setStatus(int,String)
     */
    public void setStatus(int sc, String sm) {
        throw new UnsupportedOperationException(
            "setStatus() IS Not Supported!");
    }
    
}
