/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * Postgresf[^x[X̃VPXIuWFNg̃ANZX@\NXB<br>
 * C^tF[XDBSequenceB <br>
 * 
 * @see jp.terasoluna.utlib.DBSequence
 * 
 * @version 1.0
 */
public class PostgresDBSequence implements DBSequence{

    /**
     * <p>fBtHgERXgN^</p>
     *
     */
    public PostgresDBSequence() {
        super();
    }

    /**
     * w肵VPX̌ݒl擾B
     * 
     * @param sequenceName VPX
     * @return@VPX̌ݒl
     * 
     * @throws SQLException@DBANZXɗOꍇ
     */
    public int getSequenceValue(String sequenceName) throws SQLException{
        
        //VPX擾邽߂SQL\zB
        //Fselect currval('reserve_number_seq');
        StringBuffer buf = new StringBuffer();
        
        buf.append("select currval('");
        buf.append(sequenceName);
        buf.append("');");
        
        //SQL̎s
        DBQueryObject q = new DBQueryObject();
        List result = q.query(buf.toString());
        
        if(result != null && result.size() > 0){
            Map row = (Map)result.get(0);
            String value = (String)row.get("currval");
            return Integer.parseInt(value);
        }else{
            throw new RuntimeException("w肵VPX݂Ă܂F" + sequenceName);
        }
    }
    
    /**
     * w肵VPXɒlݒ肷B
     * 
     * @param sequenceName@VPX
     * @param value@VPXɐݒ肷l
     * 
     * @throws SQLException@DBANZXɗOꍇ
     */
    public void setSequenceValue(String sequenceName,int value) throws SQLException{

        //VPXݒ肷邽߂SQL\zB
        //Fselect setval('reserve_number_seq',10);
        StringBuffer buf = new StringBuffer();
        
        buf.append("select setval('");
        buf.append(sequenceName);
        buf.append("',");
        buf.append(value);
        buf.append(");");
        
        //SQL̎s
        DBQueryObject q = new DBQueryObject();
        q.query(buf.toString());

    }
}
