/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.core;

import java.util.LinkedHashMap;
import java.util.List;

import jp.terasoluna.fw.batch.openapi.BLogic;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.standard.ThrowBatchSystemErrorThrowableHandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * rWlXWbNsNX̕WB
 * 
 * <p>̃NXł́AAvP[ṼrWlXWbNi<code>BLogic<code> 
 * C^tF[XNXj NANʂWuXe[^X֔f
 * B</p>
 * 
 * <p>rWlXWbN̏ʂ́ÃNX̑ɐݒ肳ĂrWlXW
 * bNʃnhɂăWuXe[^XɔfBrWlXWbN
 * ʃnh́ArWlXWbNԋp^[R[hɊւ炸N
 * B܂ArWlXWbN푱s(<code>NORMAL_CONTINUE</code>)ԋp
 * ꍇłAُI(<code>ERROR_END</code>)ԋpꍇłĂ
 * nhĂ΂B</p>
 * 
 * <p>rWlXWbNŗOꍇɂ́ÃNX̑ɐݒ肳Ă
 * Onh̐ݒɂėOnhNB
 * ܂ArWlXWbNX[ꂽÓAOnhɓnOɃt
 * [[ÑrWlXWbNONX(<code>BLogicException<code>)ɂāA
 * bvB</p>
 * 
 * <p>Oꍇɂ́ArWlXWbNʃnh͌Ă΂ȂƂ
 * ӂ邱ƁB
 * </p>
 * 
 * <p>̃NXł̓gUNVɊւ鏈͍sȂB</p>
 * 
 * @see jp.terasoluna.fw.batch.openapi.BLogic
 * @see jp.terasoluna.fw.batch.core.BLogicResultHandler
 * @see jp.terasoluna.fw.batch.core.JobExceptionHandler
 * 
 */
public class StandardBLogicExecutor implements BLogicExecutor {

    /**
     * OCX^XB
     */
    private static final Log log = LogFactory.getLog(StandardBLogicExecutor.class);

    /**
     * rWlXWbNʏnhB
     */
    private BLogicResultHandler bLogicResultHandler = null;

    /**
     * rWlXWbNB
     */
    private BLogic<Object, JobContext> blogic = null;

    /**
     * Onhi[MapB
     */
    private LinkedHashMap<JobException, JobExceptionHandler>
            exceptionHandlerMap = null;

    /**
     * ftHgOnhB
     */
    private JobExceptionHandler defaultJobExceptionHandler = null;

    /**
     * ThrowablenhB
     */
    private ThrowableHandler throwableHandler = new ThrowBatchSystemErrorThrowableHandler(); 

    /**
     * rWlXWbNsArWlXWbNsʂ̏sB
     *
     * @param blogicInputData Ώۃf[^
     * @param jobContext WuReLXg
     * @param jobStatus Wu
     * @param batchUpdateMapList ob`XVXg
     */
    public void executeBLogic(Object blogicInputData, JobContext jobContext,
            JobStatus jobStatus,
            List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        BLogicResult blogicResult = null;
        try {
            try {
                writeStartLog(jobStatus);
                
                blogicResult = blogic.execute(blogicInputData, jobContext);
                
                bLogicResultHandler.handle(blogicResult, blogicInputData, jobStatus,
                        batchUpdateMapList);
                
                writeEndLog(jobStatus, blogicResult);
            } catch (RuntimeException e) {
                // BLogicABLogicʃnhŔȌ
                BLogicException wrappingException
                = new BLogicException(e, blogicInputData, blogicResult);
                
                JobExceptionHandler handler
                = ExceptionHandlerUtil.getJobExceptionHandler(wrappingException,
                        exceptionHandlerMap,
                        defaultJobExceptionHandler);

                try {
                    handler.handlException(jobContext, wrappingException, jobStatus);
                } catch (RuntimeException handlerException) {
                    log.error("[Exception in ExceptionHandler] Error JobID: "
                            + jobStatus.getJobId(), handlerException);
                    jobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
                }
            }
        } catch (Throwable throwable) {
            throwableHandler.handle(jobContext, throwable, jobStatus);
        }
    }

    /**
     * Wuʃnhݒ肷B
     *
     * @param bLogicResultHandler Wuʃnh
     */
    public void setBlogicResultHandler(
            BLogicResultHandler bLogicResultHandler) {
        this.bLogicResultHandler = bLogicResultHandler;
    }

    /**
     * rWlXWbNݒ肷B
     *
     * @param blogic rWlXWbN
     */
    public void setBlogic(BLogic<Object, JobContext> blogic) {
        this.blogic = blogic;
    }

    /**
     * Onhi[Mapݒ肷B
     *
     * @param exceptionHandlerMap Onhi[Map
     */
    public void setExceptionHandlerMap(
         LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap) {
        this.exceptionHandlerMap = exceptionHandlerMap;
    }

    /**
     * ftHgOnhݒ肷B
     * @param defaultJobExceptionHandler ftHgOnh
     */
    public void setDefaultJobExceptionHandler(
        JobExceptionHandler defaultJobExceptionHandler) {
        this.defaultJobExceptionHandler = defaultJobExceptionHandler;
    }

    /**
     * BLogicExecutor̊JnOo͂B
     * 
     * @param jobStatus WuXe[^X
     */
    private void writeStartLog(JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Business logic processing START: [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [BLogicName=");
            logStr.append(blogic.getClass().getSimpleName());
            logStr.append("] [JobState=");
            logStr.append(jobStatus.getJobState());
            logStr.append("]");
            log.debug(logStr.toString());
        }
    }

    /**
     * BLogicExecutořʃOo͂B
     * 
     * @param jobStatus WuXe[^X
     * @param blogicResult rWlXWbNs
     */
    private void writeEndLog(JobStatus jobStatus, BLogicResult blogicResult) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Business logic processing END: [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [BLogicName=");
            logStr.append(blogic.getClass().getSimpleName());
            logStr.append("] [ResultHandler=");
            logStr.append(bLogicResultHandler.getClass().getSimpleName());
            logStr.append("] [ReturnCode=");
            logStr.append(blogicResult.getReturnCode());
            logStr.append("] [JobExitCode=");
            logStr.append(jobStatus.getJobExitCode());
            logStr.append("] [JobState=");
            logStr.append(jobStatus.getJobState());
            logStr.append("]");
            log.debug(logStr.toString());
        }
    }

    /**
     * Throwablenhݒ肷B
     * 
     * @param throwableHandler Throwablenh
     */
    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }

}
