/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.springsupport.messages;

import org.springframework.context.support.ApplicationObjectSupport;

import jp.terasoluna.fw.batch.messages.MessageAccessor;

/**
 * bZ[W擾NX̎NX<br>
 * Spring Framework̃AvP[VReLXgɕێĂ郁bZ[W
 * NX<br>
 * org.springframework.context.support.ApplicationObjectSupportɒ`Ă
 * MessageSourceAccesorgetMessage\bhgpĂ
 * <br><br>
 * <strong>gp@</strong><br>
 * ̃NX𗘗pɂ́ABean`t@CɂăbZ[W𗘗pNX̃v
 * peBƂĐݒ肷B<br>
 * <br>
 * <strong>ݒ</strong><br>
 * rWlXWbNŃbZ[W擾pNX𗘗p邽߂Bean`t@C̋L
 * q<br>
 * 
 * <pre>
 * &lt;bean id = &quot;blogic&quot;
 *   class = &quot;jp.terasoluna.batch.sample.SampleBLogic&quot;&gt;
 *   &lt;property name = &quot;messageAccessor&quot;&gt;
 *     &lt;ref bean = &quot;messageAccessor&quot;&gt;&lt;/ref&gt;
 *   &lt;/property&gt;
 * &lt;/bean&gt;
 * </pre>
 * 
 * t[[NBean`t@C̒`<br>
 * 
 * <pre>
 * &lt;bean id = &quot;messageAccessor&quot;
 *   class = &quot;jp.terasoluna.fw.batch.springsupport.messages.MessageAccessorImpl&quot;&gt;&lt;/ref&gt;
 * </pre>
 * 
 * 
 */
public class MessageAccessorImpl extends ApplicationObjectSupport 
    implements MessageAccessor {

    /**
     * bZ[WL[Ŏw肵bZ[W擾B
     * w肳ꂽbZ[WIDɑΉ郁bZ[W݂Ȃꍇɂ
     * bZ[WIDԋpB
     * 
     * @param code bZ[WL[
     * @param args bZ[W̃v[Xz_ɖߍޕ 
     * @return bZ[W
     */
    public String getMessage(String code, Object[] args) {
        

         // ftHgbZ[W(ftHgbZ[WƂăbZ[WIDݒ)
        String defaultMessage = code;
        
        // bZ[Wԋp
        return 
            getMessageSourceAccessor().getMessage(code, args, defaultMessage);

    }

}
