/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.beans;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.terasoluna.fw.beans.IndexedBeanWrapper;
import jp.terasoluna.fw.beans.jxpath.BeanPointerFactoryEx;
import jp.terasoluna.fw.beans.jxpath.DynamicPointerFactoryEx;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXPathIndexedBeanWrapperImpl
implements IndexedBeanWrapper {
    private static Log log = LogFactory.getLog(JXPathIndexedBeanWrapperImpl.class);
    protected JXPathContext context = null;

    public JXPathIndexedBeanWrapperImpl(Object target) {
        if (target == null) {
            log.error((Object)"TargetBean is null!");
            throw new IllegalArgumentException("TargetBean is null!");
        }
        this.context = JXPathContext.newContext((Object)target);
    }

    @Override
    public Map<String, Object> getIndexedPropertyValues(String propertyName) {
        if (StringUtils.isEmpty((String)propertyName)) {
            String message = "PropertyName is empty!";
            log.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        if (StringUtils.indexOfAny((String)propertyName, (char[])new char[]{'/', '\"', '\''}) != -1) {
            String message = "Invalid character has found within property name. '" + propertyName + "' " + "Cannot use [ / \" ' ]";
            log.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        String stringIndex = this.extractIndex(propertyName);
        if (stringIndex.length() > 0) {
            try {
                Integer.parseInt(stringIndex);
            }
            catch (NumberFormatException e) {
                String message = "Invalid character has found within property name. '" + propertyName + "' " + "Cannot use [ [] ]";
                log.error((Object)message);
                throw new IllegalArgumentException(message);
            }
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        String requestXpath = this.toXPath(propertyName);
        Iterator ite = null;
        try {
            ite = this.context.iteratePointers(requestXpath);
        }
        catch (JXPathException e) {
            String message = "Invalid property name. PropertyName: '" + propertyName + "'" + "XPath: '" + requestXpath + "'";
            log.error((Object)message, (Throwable)e);
            throw new IllegalArgumentException(message, e);
        }
        while (ite.hasNext()) {
            Pointer p = (Pointer)ite.next();
            result.put(this.toPropertyName(p.asPath()), p.getValue());
        }
        return result;
    }

    protected String toXPath(String propertyName) {
        StringBuilder builder = new StringBuilder("/");
        String[] properties = StringUtils.split((String)propertyName, (char)'.');
        if (properties == null || properties.length == 0) {
            String message = "Property name is null or blank.";
            log.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        for (String property : properties) {
            if (builder.length() > 1) {
                builder.append('/');
            }
            if (this.isMapProperty(property)) {
                builder.append(this.escapeMapProperty(property));
            } else {
                builder.append(this.extractAttributeName(property));
            }
            builder.append(this.extractIncrementIndex(property));
        }
        return builder.toString();
    }

    protected String extractIncrementIndex(String property) {
        return this.extractIncrementIndex(property, 1);
    }

    protected String extractIncrementIndex(String property, int increment) {
        String stringIndex = this.extractIndex(property);
        if ("".equals(stringIndex)) {
            return "";
        }
        try {
            int index = Integer.parseInt(stringIndex);
            return "" + '[' + (index + increment) + ']';
        }
        catch (NumberFormatException e) {
            return "";
        }
    }

    protected String extractIndex(String property) {
        int start = property.lastIndexOf(91);
        int end = property.lastIndexOf(93);
        if (start == -1 && end == -1) {
            return "";
        }
        if (start == -1 || end == -1 || start > end) {
            String message = "Cannot get Index. Invalid property name. '" + property + "'";
            log.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        return property.substring(start + 1, end);
    }

    protected String escapeMapProperty(String property) {
        String mapPropertyName = this.extractMapPropertyName(property);
        String mapKey = this.extractMapPropertyKey(property);
        return mapPropertyName + "/" + mapKey;
    }

    protected String extractMapPropertyName(String property) {
        int pos = property.indexOf(40);
        if (pos == -1) {
            String message = "Cannot get Map attribute. Invalid property name. '" + property + "'";
            log.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        return property.substring(0, pos);
    }

    protected String extractMapPropertyKey(String property) {
        int start = property.indexOf(40);
        int end = property.indexOf(41);
        if (start == -1 || end == -1 || start > end) {
            String message = "Cannot get Map key. Invalid property name. '" + property + "'";
            log.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        return property.substring(start + 1, end);
    }

    protected boolean isMapProperty(String property) {
        return property.indexOf(40) != -1 && property.indexOf(41) != -1;
    }

    protected String toPropertyName(String xpath) {
        StringBuilder builder = new StringBuilder("");
        String[] nodes = StringUtils.split((String)xpath, (char)'/');
        if (nodes == null || nodes.length == 0) {
            String message = "XPath is null or blank.";
            log.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        for (int i = 0; i < nodes.length; ++i) {
            String node = nodes[i];
            if (i == 0 && this.isMapObject(node)) {
                builder.append(this.extractMapKey(node));
                builder.append(this.extractDecrementIndex(node));
                continue;
            }
            if (builder.length() > 0) {
                builder.append('.');
            }
            if (this.isMapAttribute(node)) {
                builder.append(this.extractMapAttributeName(node));
                builder.append('(');
                builder.append(this.extractMapKey(node));
                builder.append(')');
            } else {
                builder.append(this.extractAttributeName(node));
            }
            builder.append(this.extractDecrementIndex(node));
        }
        return builder.toString();
    }

    protected String extractAttributeName(String node) {
        int pos = node.lastIndexOf(91);
        if (pos == -1) {
            return node;
        }
        return node.substring(0, pos);
    }

    protected String extractMapAttributeName(String node) {
        int pos = node.indexOf(91);
        if (pos == -1) {
            String message = "Cannot get Map attribute. Invalid property name. '" + node + "'";
            log.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        return node.substring(0, pos);
    }

    protected String extractMapKey(String node) {
        int start = node.indexOf(91);
        int end = node.indexOf(93);
        if (start == -1 || end == -1 || start > end) {
            String message = "Cannot get Map key. Invalid property name. '" + node + "'";
            log.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        return node.substring(start + "[@name='".length(), end - "'".length());
    }

    protected String extractDecrementIndex(String node) {
        return this.extractIncrementIndex(node, -1);
    }

    protected boolean isMapAttribute(String node) {
        return node.indexOf("[@name") != -1;
    }

    protected boolean isMapObject(String node) {
        return node.startsWith(".[@name");
    }

    static {
        JXPathContextReferenceImpl.addNodePointerFactory((NodePointerFactory)new BeanPointerFactoryEx());
        JXPathContextReferenceImpl.addNodePointerFactory((NodePointerFactory)new DynamicPointerFactoryEx());
    }
}

