/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.actions;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDownloadObject
implements Serializable {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final String NO_DOWNLOAD_CONTENT_ERROR = "errors.no.download.content";
    protected String contentType = null;
    protected String name = null;
    protected String charset = null;
    protected Map<String, List<String>> additionalHeaders = new HashMap<String, List<String>>();

    public AbstractDownloadObject(String name, String contentType, String charset) {
        this.name = name;
        this.setContentType(contentType);
        this.setCharset(charset);
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
        if (this.charset == null) {
            this.charset = DEFAULT_CHARSET;
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        if (this.contentType == null) {
            this.setContentType(DEFAULT_CONTENT_TYPE);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InputStream getStream() throws IOException {
        InputStream stream = this.getStreamInternal();
        if (!(stream instanceof BufferedInputStream)) {
            stream = new BufferedInputStream(stream);
        }
        return stream;
    }

    public void addHeader(String name, String value) {
        List<String> headerValues = this.additionalHeaders.get(name);
        if (headerValues == null) {
            headerValues = new ArrayList<String>();
            this.additionalHeaders.put(name, headerValues);
        }
        headerValues.add(value);
    }

    public Map<String, List<String>> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    protected abstract InputStream getStreamInternal() throws IOException;

    public abstract int getLengthOfData();
}

