/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.service.thin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

/**
 *  bZ[WꗗNXB
 * <p>
 *  BLogicMessageCX^Xi[NXB
 * </p>
 * <p>
 *  gpɂẮAAbstractBLogicActionQƂ̂ƁB
 * </p>
 *
 * @see jp.terasoluna.fw.service.thin.BLogicMessage
 * @see jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction
 *
 */
public class BLogicMessages implements Serializable {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = -7410826431026041043L;

    // ----------------------------------------------------- Instance Variables
    /**
     * BLogicMessageXgB
     *
     * <p>bZ[WO[v𖳎āAPadd()
     * BLogicMessageێB</p>
     */
    protected ArrayList<BLogicMessage> list = new ArrayList<BLogicMessage>();

    /**
     * bZ[WO[ṽXgB
     *
     * <p>Padd()ŃbZ[WO[vێB</p>
     */
    protected ArrayList<String> groupList = new ArrayList<String>();

    // --------------------------------------------------------- Public Methods

    /**
     * RXgN^B
     */
    public BLogicMessages() {

        super();
    }

    /**
     * RXgN^B
     *
     * @param messages bZ[Wꗗ
     */
    public BLogicMessages(BLogicMessages messages) {
        super();
        this.add(messages);
    }

    /**
     * bZ[WǉB
     *
     * @param group bZ[WO[v
     * @param message ǉ郁bZ[W
     */
    public void add(String group, BLogicMessage message) {

        this.list.add(message);
        this.groupList.add(group);
    }

    /**
     * bZ[WǉB
     *
     * @param messages ǉBLogicMessagesCX^X
     */
    public void add(BLogicMessages messages) {

        if (messages == null) {
            return;
        }

        // loop over properties
        Iterator<BLogicMessage> itr = messages.get();
        Iterator<String> groupItr = messages.getGroup();
        while (itr.hasNext()) {
            BLogicMessage message = itr.next();
            String group = groupItr.next();

            this.add(group, message);
        }
    }

    /**
     * ێĂ郁bZ[WNAB
     */
    public void clear() {

        this.list.clear();
        this.groupList.clear();
    }

    /**
     * bZ[Wi[ĂȂꍇAtrueԂB
     *
     * @return bZ[Wi[ĂȂꍇAtrue
     */
    public boolean isEmpty() {

        return (list.isEmpty());
    }

    /**
     * ێĂ郁bZ[WꗗɃANZXCe[^擾B
     * bZ[WO[v͖āAadd()Ŏ擾邱Ƃۏ؂B
     *
     * @return bZ[Wꗗ̃Ce[^
     */
    @SuppressWarnings("unchecked")
    public Iterator<BLogicMessage> get() {
        return ((ArrayList) this.list.clone()).iterator();
    }

    /**
     * ێĂ郁bZ[WO[vꗗɃANZXCe[^擾B
     * add()Ŏ擾邱Ƃۏ؂B
     *
     * @return bZ[WO[vꗗ̃Ce[^
     */
    @SuppressWarnings("unchecked")
    public Iterator<String> getGroup() {
        return ((ArrayList) this.groupList.clone()).iterator();
    }

}
