/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.common;

import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.springframework.aop.interceptor.SimpleTraceInterceptor;

/**
 * fobOx̃Oo͂邽߂̃C^Zv^
 * 
 */
public class FunctionDebugInterceptor extends SimpleTraceInterceptor {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = 6350482237743804401L;

    /**
     * ONX擾AOo͂̔sB
     * 
     * @param invocation {Ăяo郁\bh
     * @return {Ăяo郁\bȟ
     */
    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {

        //ONX̐
        Log logger = getLoggerForInvocation(invocation);

        if (logger.isDebugEnabled()) {
            //Ȍo͂і{Ăяo郁\bhĂсAʂԋpB
            return invokeUnderTrace(invocation, logger);
        }
        else {
            //Oo͂sȂꍇ́A
            //{Ăяo郁\bhĂсAʂԋpB
            return invocation.proceed();
        }
    }

    /**
     * JnȌóA\bh̎sAIȌo͂sB
     * 
     * @param invocation {Ăяo郁\bh
     * @param logger ONX
     * @return MethodInvocation.proceed()̌
     */
    @Override
    protected Object invokeUnderTrace(MethodInvocation invocation, Log logger)
        throws Throwable {

        //{Ăяo郁\bh擾
        String invocationDescription = getInvocationDescription(invocation);

        //JnȌo
        logger.debug("Start:" + invocationDescription);

        try {
            //{Ăяo郁\bhĂяo
            Object rval = invocation.proceed();

            //IȌo
            logger.debug("End:" + invocationDescription);

            //ʂ̕ԋp
            return rval;

        } catch (Throwable ex) {
            //Oۂ̃Oo
            logger.debug("Exception thrown in:" + invocationDescription, ex);
            throw ex;
        }
    }
}