/*
 * Copyright (c) 2008 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.util.MessageResources;

/**
 * w肵OxŃOo͂ėpOnhB
 *
 * <p>
 * ÕOo͂ƃG[ʂւ̑JڂsB<br>
 * </p>
 *
 * <p>
 * {@\𗘗p邽߂ɂ́AStrutsݒt@C(struts-config.xml)
 * O[oOA܂̓ANVxOnhNXƂĎw肷B<br>
 * </p>
 *
 * <p>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>Ox̎w</legend>
 * vpeB<strong><u>logLevel</u></strong>ɉL6ނ̃Ox
 * w肷邱Ƃ\B
 * <p>
 * <ol>
 *   <li>trace</li>
 *   <li>debug</li>
 *   <li>info</li>
 *   <li>warn</li>
 *   <li>error</li>
 *   <li>fatal</li>
 * </ol>
 * </p>
 * w肵Ȃꍇ́AftHgerrorƂȂB<br>
 * logLevelw肷ꍇ́A&lt;exception&gt;^OclassName
 * <strong><u>ExceptionConfigEx</u></strong>w肷邱ƁB
 * </fieldset>
 * </p>
 *
 * <p>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>O[oOnhOݒ</legend>
 *
 * Strutsݒt@C(struts-config.xml)Ɉȉ̂悤ɋLqB
 * <pre><code>
 * &lt;struts-config&gt;
 *   c
 *   &lt;global-exceptions&gt;
 *     &lt;exception key="some.key"
 *                path="/system-error"
 *                type="org.springframework.dao.DataAccessException"
 *                className="jp.terasoluna.fw.web.struts.action.ExceptionConfigEx"
 *                handler="jp.terasoluna.fw.web.struts.action.DefaultExceptionHandler"&gt;
 *       &lt;set-property property="module" value="/exp"/&gt;
 *     &lt;/exception&gt;
 *     &lt;exception key="some.key"
 *                path="/system-error"
 *                type="jp.terasoluna.fw.exception.SystemException"
 *                className="jp.terasoluna.fw.web.struts.action.ExceptionConfigEx"
 *                handler="jp.terasoluna.fw.web.struts.action.SystemExceptionHandler"&gt;
 *       &lt;set-property property="module" value="/exp"/&gt;
 *     &lt;/exception&gt;
 *     &lt;exception key="some.key"
 *                path="/system-error"
 *                type="java.lang.Exception"
 *                className="jp.terasoluna.fw.web.struts.action.ExceptionConfigEx"
 *                handler="jp.terasoluna.fw.web.struts.action.DefaultExceptionHandler"&gt;
 *       &lt;set-property property="module" value="/exp"/&gt;
 *       &lt;set-property property="logLevel" value="fatal"/&gt;
 *     &lt;/exception&gt;
 *   &lt;/global-exceptions&gt;
 *   c
 * &lt;struts-config&gt;
 * </code></pre>
 * </fieldset>
 * </p>
 *
 * <p>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 * <legend>ANVxOnhOݒ</legend>
 *
 * Strutsݒt@C(struts-config.xml)Ɉȉ̂悤ɋLqB
 * <pre><code>
 * &lt;struts-config&gt;
 *   c
 *   &lt;action path="/start"
 *           type="jp.terasoluna.sample.xxx.SampleAction"
 *           name="_sampleForm"
 *           scope="session"&gt;
 *     &lt;exception key="some.key"
 *                type="jp.terasoluna.sample.xxx.exception.XxxException"
 *                className="jp.terasoluna.fw.web.struts.action.ExceptionConfigEx"
 *                handler="jp.terasoluna.fw.web.struts.action.DefaultExceptionHandler"
 *                path="/sub-forward.do"&gt;
 *       &lt;set-property property="module" value="/sub"/&gt;
 *     &lt;/exception&gt;
 *     &lt;forward name="success" path="/business-error"/&gt;
 *   &lt;/action&gt;
 *   c
 * &lt;struts-config&gt;
 * </code></pre>
 * </fieldset>
 * </p>
 *
 * <p>
 * ȂA&lt;exception&gt;vfpathőJڐpXw
 * ĂȂꍇ́AANV}bsOinput
 * ]惊\[XƂB
 * </p>
 *
 * <p>
 * OCX^X́Areuqest<strong>Globals.EXCEPTION_KEY</strong>̃L[Ŋi[B
 * </p>
 *
 * @see org.apache.struts.action.ExceptionHandler
 * @see jp.terasoluna.fw.web.struts.action.ExceptionConfigEx
 * @see jp.terasoluna.fw.web.struts.action.SystemExceptionHandler
 * @see org.apache.struts.Globals
 */
public class DefaultExceptionHandler extends ExceptionHandler {

    /** OCX^X */
    private static final Log logger = LogFactory
            .getLog(DefaultExceptionHandler.class);

    /** Ox(TRACE) */
    protected static final String LOG_LEVEL_TRACE = "trace";

    /** Ox(DEBUG) */
    protected static final String LOG_LEVEL_DEBUG = "debug";

    /** Ox(INFO) */
    protected static final String LOG_LEVEL_INFO = "info";

    /** Ox(WARN) */
    protected static final String LOG_LEVEL_WARN = "warn";

    /** Ox(ERROR) */
    protected static final String LOG_LEVEL_ERROR = "error";

    /** Ox(FATAL) */
    protected static final String LOG_LEVEL_FATAL = "fatal";

    /** bZ[W\[X */
    private static MessageResources messages = MessageResources
            .getMessageResources("org.apache.struts.action.LocalStrings");

    /**
     * <p>
     * OnhOsB
     * </p>
     *
     * @param ex O
     * @param eConfig ORtBO
     * @param mapping ANV}bsO
     * @param formInstance ANVtH[
     * @param request HTTPNGXg
     * @param response HTTPX|X
     *
     * @return Jڏ
     *
     * @throws ServletException T[ubgO
     *
     * @see org.apache.struts.action.ExceptionHandler#execute(
     *  java.lang.Exception,
     *  org.apache.struts.config.ExceptionConfig,
     *  org.apache.struts.action.ActionMapping,
     *  org.apache.struts.action.ActionForm,
     *  javax.servlet.http.HttpServletRequest,
     *  javax.servlet.http.HttpServletResponse
     *  )
     */
    @Override
    public ActionForward execute(Exception ex, ExceptionConfig eConfig,
            ActionMapping mapping, ActionForm formInstance,
            HttpServletRequest request, HttpServletResponse response)
            throws ServletException {

        // X[p[NXĂяo
        ActionForward af = super.execute(ex, eConfig, mapping, formInstance,
                request, response);

        // ExceptionConfigEx̏ꍇlogLevel擾
        if (eConfig instanceof ExceptionConfigEx) {
            // Jڐ惂W[ݒ肳ĂƂAW[ݒ肷
            af.setModule(((ExceptionConfigEx) eConfig).getModule());

            // logLevel𗘗păOo
            this.logException(ex, ((ExceptionConfigEx) eConfig).getLogLevel());
        } else {
            // ftHgxŃOo
            this.logException(ex, null);
        }

        return af;
    }

    /**
     * ÕOo͂B
     *
     * @param e O
     * @param logLevel Ox
     */
    protected void logException(Exception e, String logLevel) {
        this.logException(e, logLevel, messages.getMessage("exception.log"));
    }

    /**
     * ÕOo͂B
     *
     * @param logLevel Ox
     * @param message o͂郁bZ[W
     */
    protected void logException(String logLevel, String message) {
        this.logException(null, logLevel, message);
    }

    /**
     * ÕOo͂B
     *
     * @param e O
     * @param logLevel Ox
     * @param message o͂郁bZ[W
     */
    protected void logException(Exception e, String logLevel, String message) {
        if (LOG_LEVEL_TRACE.equalsIgnoreCase(logLevel)) {
            if (getLogger().isTraceEnabled()) {
                // TRACE
                if (e != null) {
                    getLogger().trace(message, e);
                } else {
                    getLogger().trace(message);
                }
            }
        } else if (LOG_LEVEL_DEBUG.equalsIgnoreCase(logLevel)) {
            if (getLogger().isDebugEnabled()) {
                // DEBUG
                if (e != null) {
                    getLogger().debug(message, e);
                } else {
                    getLogger().debug(message);
                }
            }
        } else if (LOG_LEVEL_INFO.equalsIgnoreCase(logLevel)) {
            if (getLogger().isInfoEnabled()) {
                // INFO
                if (e != null) {
                    getLogger().info(message, e);
                } else {
                    getLogger().info(message);
                }
            }
        } else if (LOG_LEVEL_WARN.equalsIgnoreCase(logLevel)) {
            if (getLogger().isWarnEnabled()) {
                // WARN
                if (e != null) {
                    getLogger().warn(message, e);
                } else {
                    getLogger().warn(message);
                }
            }
        } else if (LOG_LEVEL_ERROR.equalsIgnoreCase(logLevel)) {
            if (getLogger().isErrorEnabled()) {
                // ERROR
                if (e != null) {
                    getLogger().error(message, e);
                } else {
                    getLogger().error(message);
                }
            }
        } else if (LOG_LEVEL_FATAL.equalsIgnoreCase(logLevel)) {
            if (getLogger().isFatalEnabled()) {
                // FATAL
                if (e != null) {
                    getLogger().fatal(message, e);
                } else {
                    getLogger().fatal(message);
                }
            }
        } else {
            if (getLogger().isErrorEnabled()) {
                // ERRORiftHgj
                if (e != null) {
                    getLogger().error(message, e);
                } else {
                    getLogger().error(message);
                }
            }
        }
    }

    /**
     * ÕOo͂B
     *
     * <p>
     * <strong><u>ł͏o͂Ȃ</u></strong>
     * </p>
     *
     * @param e O
     * @see org.apache.struts.action.ExceptionHandler#logException(
     *  java.lang.Exception)
     */
    @Override
    protected void logException(Exception e) {
        // ł͏o͂Ȃ
    }

    /**
     * nh̃K[擾B
     *
     * <p>
     * ̃NXgēƎ̗OnhꍇA
     * TuNXł̃\bhI[o[ChĎg̃K[ԂƁB
     * </p>
     *
     * @return K[
     */
    protected Log getLogger() {
        return logger;
    }

}
