/**
 * 
 */
package jp.terasoluna.fw.dao.ibatis;

import jp.terasoluna.fw.dao.event.DataRowHandler;
import jp.terasoluna.utlib.LogUTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.co.nttdata.illigra.lucy.illigralib.dao.ibatis.RowHandledQueryDAOiBatisImpl}
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * RowHandledQueryDAOC^tF[XiBATISpNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.dao.ibatis.QueryDAOiBatisImpl
 */
public class QueryRowHandleDAOiBatisImplTest extends TestCase {

    /**
     * eXgΏۃNX
     */
    private QueryRowHandleDAOiBatisImpl dao = new QueryRowHandleDAOiBatisImpl();

    /**
     * sB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        dao = new QueryRowHandleDAOiBatisImpl();
    }

    /**
     * IsB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        dao = null;
    }

    /**
     * testExecuteWithRowHandler01()
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() sqlID:"sqlId"<br>
     *         () bindParams:"hoge"<br>
     *         () rowHandler:not null<br>
     *         (O) sqlMapClientTemplate:SqlMapClientTemplateStub01<br>
     * <br>
     * ҒlF(߂l) Ȃ<br>
     *         (ԕω) SqlMapClientTemplatěďomF:sqlIDAbindParams
     *                    ĂяoĂ鎖mF<br>
     *         (ԕω) DataRowHandleřďomF:yINFOOz"param=hoge"<br>
     *
     * <br>
     * oChp[^nullłȂꍇADataRowHandler
     * s邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExecuteWithRowHandler01() throws Exception {
        // O
        QueryRowHandleDAOiBatisImpl_SqlMapClientTemplateStub01 sqlMapClTemp = 
            new QueryRowHandleDAOiBatisImpl_SqlMapClientTemplateStub01();
        dao.setSqlMapClientTemplate(sqlMapClTemp);

        DataRowHandler rowHandler = 
                    new QueryRowHandleDAOiBatisImpl_DataRowHandlerImpl();

        // eXg{
        dao.executeWithRowHandler("sqlId", "hoge", rowHandler);

        // 
        assertTrue(sqlMapClTemp.isCalled());
        assertEquals("sqlId", sqlMapClTemp.getStatementName());
        assertEquals("hoge", sqlMapClTemp.getParameterObject());
        // RowHandlerWrappereoRDataRowHandlersꂽƂ̊mF
        assertTrue(LogUTUtil.checkInfo("param=hoge"));
    }

    /**
     * testExecuteWithRowHandler02()
     * <br><br>
     *
     * n
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() sqlID:"sqlId"<br>
     *         () bindParams:null<br>
     *         () rowHandler:not null<br>
     *         (O) sqlMapClientTemplate:SqlMapClientTemplateStub01<br>
     * <br>
     * ҒlF(߂l) Ȃ<br>
     *         (ԕω) SqlMapClientTemplatěďomF:sqlIDAbindParams
     *                    ĂяoĂ鎖mF<br>
     *         (ԕω) DataRowHandleřďomF:yINFOOz"param=hoge"<br>
     *
     * <br>
     * oChp[^null̏ꍇADataRowHandler
     * s邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExecuteWithRowHandler02() throws Exception {
        // O
        QueryRowHandleDAOiBatisImpl_SqlMapClientTemplateStub01 sqlMapClTemp = new QueryRowHandleDAOiBatisImpl_SqlMapClientTemplateStub01();
        dao.setSqlMapClientTemplate(sqlMapClTemp);

        DataRowHandler rowHandler = new QueryRowHandleDAOiBatisImpl_DataRowHandlerImpl();

        // eXg{
        dao.executeWithRowHandler("sqlId", null, rowHandler);

        // 
        assertTrue(sqlMapClTemp.isCalled());
        assertEquals("sqlId", sqlMapClTemp.getStatementName());
        assertNull(sqlMapClTemp.getParameterObject());
        // RowHandlerWrappereoRDataRowHandlersꂽƂ̊mF
        assertTrue(LogUTUtil.checkInfo("param is null"));
    }

}
