/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.PropertyTestCase;

/**
 * {@link jp.terasoluna.fw.web.UserValueObject} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * OI[U񒊏ۃNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.UserValueObject
 * 
 */
@SuppressWarnings("unused")
public class UserValueObjectTest extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * 
     * @param args
     *            java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(UserValueObjectTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
    }

    /**
     * IsB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * RXgN^B
     * 
     * @param name
     *            ̃eXgP[X̖OB
     */
    public UserValueObjectTest(String name) {
        super(name);
    }

    /**
     * testCreateUserValueObject01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() vpeBt@C:user.value.object=<br>
     *                jp.terasoluna.fw.web.UserValueObjectImpl01<br>
     *         
     * <br>
     * ҒlF(߂l) UserValueObject:UserValueObjectImpl01CX^X<br>
     *         
     * <br>
     * vpeBt@Cuser.value.objectL[ƂāAUserValueObjectNXLqĂꍇÃNX̃CX^X擾ł邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateUserValueObject01() throws Exception {
        // O
        addProperty("user.value.object",
                "jp.terasoluna.fw.web.UserValueObjectImpl01");

        // eXg{
        UserValueObject userObject = UserValueObject.createUserValueObject();

        // 
        assertEquals(UserValueObjectImpl01.class.getName(), userObject
                .getClass().getName());
    }

    /**
     * testCreateUserValueObject02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() vpeBt@C:user.value.object=java.lang.String<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"errors.uvo.class"<br>
     *                    uPF<br>
     *                    "java.lang.String"<br>
     *                    bvOFClassCastException<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF<br>
     *                    illegal uvo class:java.lang.String<br>
     *                    OFClassCastException<br>
     *         
     * <br>
     * vpeBt@Cuser.value.objectL[ƂāAUserValueObjectĂȂNXLqĂꍇAClassCastExceptionbvSystemExceptionX[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateUserValueObject02() throws Exception {
        // O
        addProperty("user.value.object", "java.lang.String");
        try {
            // eXg{
            UserValueObject userObject = 
                UserValueObject.createUserValueObject();
            fail();

        } catch (SystemException sysEx) {
            // 
            // SystemException ̒g`FbN
            // bZ[WL[`FbN
            assertEquals("errors.uvo.class", sysEx.getErrorCode());
            // bvO`FbN
            assertEquals(ClassCastException.class.getName(), 
                    sysEx.getCause().getClass().getName());
            
            // u`FbN
            assertEquals("java.lang.String", sysEx.getOptions()[0]);
            // O`FbN
            assertTrue(LogUTUtil.checkError(
                    "illegal uvo class:java.lang.String", sysEx.getCause()));
        }
    }

    /**
     * testCreateUserValueObject03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() vpeBt@C:user.value.object=uvo<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"errors.uvo.class"<br>
     *                    uPF<br>
     *                    "uvo"<br>
     *                    bvOFClassLoadException<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF<br>
     *                    illegal uvo class:uvo<br>
     *                    OFClassLoadException<br>
     *         
     * <br>
     * vpeBt@Cuser.value.objectL[ƂāANXpXɑ݂ȂNXLqĂꍇAClassLoadExceptionbvSystemExceptionX[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateUserValueObject03() throws Exception {
        // O
        addProperty("user.value.object", "uvo");
        try {
            // eXg{
            UserValueObject userObject = 
                UserValueObject.createUserValueObject();
            fail();

        } catch (SystemException sysEx) {
            // 
            // SystemException ̒g`FbN
            // bZ[WL[`FbN
            assertEquals("errors.uvo.class", sysEx.getErrorCode());
            // bvO`FbN
            assertEquals(ClassLoadException.class.getName(),
                    sysEx.getCause().getClass().getName());
            // u`FbN
            assertEquals("uvo", sysEx.getOptions()[0]);
            // O`FbN
            assertTrue(LogUTUtil.checkError("illegal uvo class:uvo", 
                    sysEx.getCause()));

        }
    }

    /**
     * testCreateUserValueObject04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() vpeBt@C:user.value.object̐ݒȂ<br>
     *         
     * <br>
     * ҒlF(߂l) UserValueObject:null<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WFspecify user.value.object.<br>
     *         
     * <br>
     * vpeBt@Cuser.value.object̃L[݂ȂꍇAG[Oo͂Anullԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateUserValueObject04() throws Exception {
        // O
        // user.value.object̐ݒȂ

        // eXg{
        UserValueObject userObject = UserValueObject.createUserValueObject();

        // eXg
        assertNull(userObject);
        
        // O`FbN
        assertTrue(LogUTUtil.checkError("specify user.value.object."));        

    }
}
