/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link MessageFormatCloneReturnIfUseDateFormatMap} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Struts̃oO(STR-2172)pHashMap(MessageFormatLbV)B<br>
 * tnTutH[}bggpMessageFormat̂݁AcloneĕԂB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.MessageFormatCloneReturnIfUseDateFormatMap
 */
public class MessageFormatCloneReturnIfUseDateFormatMapTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(MessageFormatCloneReturnIfUseDateFormatMapTest.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public MessageFormatCloneReturnIfUseDateFormatMapTest(String name) {
        super(name);
    }

    /**
     * testGet01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() "key1"
     *         () Gg[[key1 : MessageFormat]
     *         () cloneReturnMap:key1̃Gg[Ȃ
     *         
     * <br>
     * ҒlF(߂l) Gg[ɂMessageFormat<br>
     *         
     * <br>
     * cloneReturnMapłȂ̃Gg[ɑ݂̂́A
     * cloneꂸɕԋp邱ƂmFB<br>
     * OɂāAputsAcloneReturnMapMapɍւĐ퓮삷邱ƂɂA
     *   OɂĎO(Gg[)oĂ邱ƂmFB<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGet01() throws Exception {
        // O
        MessageFormatCloneReturnIfUseDateFormatMap map = new MessageFormatCloneReturnIfUseDateFormatMap();
        MessageFormat format = new MessageFormat("xxx");
        map.put("key1", format);
        UTUtil.setPrivateField(map, "cloneReturnMap", new MessageFormatCloneReturnMap());
        
        // eXg{
        MessageFormat ret = map.get("key1");
        
        // 
        assertSame(format, ret);
    }

    /**
     * testGet02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() "key1"
     *         () key1̃Gg[Ȃ
     *         () cloneReturnMap:Gg[[key1 : MessageFormat]
     *         
     * <br>
     * ҒlF(߂l) cloneReturnMap̃Gg[ɂMessageFormatƓȕʃCX^X<br>
     *         
     * <br>
     * g̃Gg[ɂȂꍇA
     * cloneReturnMap̃Gg[擾邱ƂmFB<br>
     * cloneReturnMap̃Gg[擾CX^X́A
     * cloneReturnMap̃Gg[ɂ̂ł͂ȂAƓȕʃCX^Xł邱ƂmFB<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGet02() throws Exception {
        // O
        MessageFormatCloneReturnIfUseDateFormatMap map = new MessageFormatCloneReturnIfUseDateFormatMap();
        MessageFormat format = new MessageFormat("xxx{0,date}");
        MessageFormatCloneReturnMap cloneReturnMap = new MessageFormatCloneReturnMap();
        cloneReturnMap.put("key1", format);
        UTUtil.setPrivateField(map, "cloneReturnMap", cloneReturnMap);
        
        // eXg{
        MessageFormat ret = map.get("key1");
        
        // 
        assertNotSame(format, ret);
        assertEquals(format, ret);
    }

    /**
     * testGet03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() "key1"
     *         () key1̃Gg[Ȃ
     *         () cloneReturnMap:key1̃Gg[Ȃ
     *         
     * <br>
     * ҒlF(߂l) null<br>
     *         
     * <br>
     * L[ɊYGg[AgɂcloneReturnMapɂ݂ȂꍇA
     * nullԋp邱ƂmFB<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGet03() throws Exception {
        // O
        MessageFormatCloneReturnIfUseDateFormatMap map = new MessageFormatCloneReturnIfUseDateFormatMap();
        
        // eXg{
        MessageFormat ret = map.get("key1");
        
        // 
        assertNull(ret);
    }

    /**
     * testPut01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"key1"<br>
     *         () value:MessageFormatCX^X<br>
     *                      tH[}bg:"aaa"<br>
     *         () key1̃Gg[Ȃ
     *         () cloneReturnMap:key1̃Gg[Ȃ
     *         
     * <br>
     * ҒlF(߂l) null<br>
     *         (ԕω) Gg[[key1 : œnMessageFormat]
     *         (ԕω) cloneReturnMap:key1̃Gg[Ȃ
     *         
     * <br>
     * tH[}bgɃv[Xz_݂ȂƂA
     * cloneReturnMapł͂ȂAgput(X[p[NX̋@\)ƂmFB<br>
     * get\bh̓삪OŁAgetCX^XԂƂŁA
     *   put̊i[U蕪퓮삵ƔfB<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testPut01() throws Exception {
        // O
        MessageFormatCloneReturnIfUseDateFormatMap map = new MessageFormatCloneReturnIfUseDateFormatMap();
        MessageFormat format = new MessageFormat("aaa");
        
        // eXg{
        MessageFormat ret = map.put("key1", format);
        
        // 
        assertNull(ret);
        assertSame(format, map.get("key1"));
    }

    /**
     * testPut02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"key1"<br>
     *         () value:MessageFormatCX^X<br>
     *                      tH[}bg:"aaa{0}"<br>
     *         () key1̃Gg[Ȃ
     *         () cloneReturnMap:key1̃Gg[Ȃ
     *         
     * <br>
     * ҒlF(߂l) null<br>
     *         (ԕω) Gg[[key1 : œnMessageFormat]
     *         (ԕω) cloneReturnMap:key1̃Gg[Ȃ
     *         
     * <br>
     * tH[}bgɃTutH[}bgw肵Ȃv[Xz_݂݂̂ƂA
     * cloneReturnMapł͂ȂAgput(X[p[NX̋@\)ƂmFB<br>
     * get\bh̓삪OŁAgetCX^XԂƂŁA
     *   put̊i[U蕪퓮삵ƔfB<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testPut02() throws Exception {
        // O
        MessageFormatCloneReturnIfUseDateFormatMap map = new MessageFormatCloneReturnIfUseDateFormatMap();
        MessageFormat format = new MessageFormat("aaa{0}");
        
        // eXg{
        MessageFormat ret = map.put("key1", format);
        
        // 
        assertNull(ret);
        assertSame(format, map.get("key1"));
    }

    /**
     * testPut03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"key1"<br>
     *         () value:MessageFormatCX^X<br>
     *                      tH[}bg:"aaa{0,date}"<br>
     *         () key1̃Gg[Ȃ
     *         () cloneReturnMap:key1̃Gg[Ȃ
     *         
     * <br>
     * ҒlF(߂l) null<br>
     *         (ԕω) key1̃Gg[Ȃ
     *         (ԕω) cloneReturnMap:Gg[[key1 : œnMessageFormat]
     *         
     * <br>
     * tH[}bgɓtnTutH[}bgw肵v[Xz_݂݂̂ƂA
     * cloneReturnMapputAgɂputȂƂmFB<br>
     * get\bh̓삪OŁAgetقȂ铙ȃCX^XԂƂŁA
     *   put̊i[U蕪퓮삵ƔfB<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testPut03() throws Exception {
        // O
        MessageFormatCloneReturnIfUseDateFormatMap map = new MessageFormatCloneReturnIfUseDateFormatMap();
        MessageFormat format = new MessageFormat("aaa{0,date}");
        
        // eXg{
        MessageFormat ret = map.put("key1", format);
        
        // 
        assertNull(ret);
        assertNotSame(format, map.get("key1"));
        assertEquals(format, map.get("key1"));
    }

    /**
     * testPut04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"key1"<br>
     *         () value:MessageFormatCX^X<br>
     *                      tH[}bg:"aaa{0,time}"<br>
     *         () key1̃Gg[Ȃ
     *         () cloneReturnMap:key1̃Gg[Ȃ
     *         
     * <br>
     * ҒlF(߂l) null<br>
     *         (ԕω) key1̃Gg[Ȃ
     *         (ԕω) cloneReturnMap:Gg[[key1 : œnMessageFormat]
     *         
     * <br>
     * tH[}bgɓtnTutH[}bgw肵v[Xz_݂݂̂ƂA
     * cloneReturnMapputAgɂputȂƂmFB<br>
     * get\bh̓삪OŁAgetقȂ铙ȃCX^XԂƂŁA
     *   put̊i[U蕪퓮삵ƔfB<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testPut04() throws Exception {
        // O
        MessageFormatCloneReturnIfUseDateFormatMap map = new MessageFormatCloneReturnIfUseDateFormatMap();
        MessageFormat format = new MessageFormat("aaa{0,date}");
        
        // eXg{
        MessageFormat ret = map.put("key1", format);
        
        // 
        assertNull(ret);
        assertNotSame(format, map.get("key1"));
        assertEquals(format, map.get("key1"));
    }

    /**
     * testPut05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"key1"<br>
     *         () value:MessageFormatCX^X<br>
     *                      tH[}bg:"aaa{0,number}"<br>
     *         () key1̃Gg[Ȃ
     *         () cloneReturnMap:key1̃Gg[Ȃ
     *         
     * <br>
     * ҒlF(߂l) null<br>
     *         (ԕω) Gg[[key1 : œnMessageFormat]
     *         (ԕω) cloneReturnMap:key1̃Gg[Ȃ
     *         
     * <br>
     * tH[}bgɐlnTutH[}bgw肵v[Xz_݂݂̂ƂA
     * cloneReturnMapł͂ȂAgput(X[p[NX̋@\)ƂmFB<br>
     * get\bh̓삪OŁAgetCX^XԂƂŁA
     *   put̊i[U蕪퓮삵ƔfB<br>
     * <br>
    * 
     * @throws Exception ̃\bhŔO
     */
    public void testPut05() throws Exception {
        // O
        MessageFormatCloneReturnIfUseDateFormatMap map = new MessageFormatCloneReturnIfUseDateFormatMap();
        MessageFormat format = new MessageFormat("aaa{0,number}");
        
        // eXg{
        MessageFormat ret = map.put("key1", format);
        
        // 
        assertNull(ret);
        assertSame(format, map.get("key1"));
    }

    /**
     * testPut06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"key1"<br>
     *         () value:MessageFormatCX^X<br>
     *                      tH[}bg:"aaa{0,choice,0#zero | 1#one}"<br>
     *         () key1̃Gg[Ȃ
     *         () cloneReturnMap:key1̃Gg[Ȃ
     *         
     * <br>
     * ҒlF(߂l) null<br>
     *         (ԕω) Gg[[key1 : œnMessageFormat]
     *         (ԕω) cloneReturnMap:key1̃Gg[Ȃ
     *         
     * <br>
     * tH[}bgɑI^TutH[}bgw肵v[Xz_݂݂̂ƂA
     * cloneReturnMapł͂ȂAgput(X[p[NX̋@\)ƂmFB<br>
     * get\bh̓삪OŁAgetCX^XԂƂŁA
     *   put̊i[U蕪퓮삵ƔfB<br>
     * <br>
    * 
     * @throws Exception ̃\bhŔO
     */
    public void testPut06() throws Exception {
        // O
        MessageFormatCloneReturnIfUseDateFormatMap map = new MessageFormatCloneReturnIfUseDateFormatMap();
        MessageFormat format = new MessageFormat("aaa{0,choice,0#zero | 1#one}");
        
        // eXg{
        MessageFormat ret = map.put("key1", format);
        
        // 
        assertNull(ret);
        assertSame(format, map.get("key1"));
    }

    /**
     * testPut07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"key1"<br>
     *         () value:MessageFormatCX^X<br>
     *                      tH[}bg:"aaa{0}bbb{1,number}"<br>
     *         () key1̃Gg[Ȃ
     *         () cloneReturnMap:key1̃Gg[Ȃ
     *         
     * <br>
     * ҒlF(߂l) null<br>
     *         (ԕω) Gg[[key1 : œnMessageFormat]
     *         (ԕω) cloneReturnMap:key1̃Gg[Ȃ
     *         
     * <br>
     * tH[}bgɓtnTutH[}bgȊOw肵v[Xz_݂ƂA
     * cloneReturnMapł͂ȂAgput(X[p[NX̋@\)ƂmFB<br>
     * get\bh̓삪OŁAgetCX^XԂƂŁA
     *   put̊i[U蕪퓮삵ƔfB<br>
     * <br>
    * 
     * @throws Exception ̃\bhŔO
     */
    public void testPut07() throws Exception {
        // O
        MessageFormatCloneReturnIfUseDateFormatMap map = new MessageFormatCloneReturnIfUseDateFormatMap();
        MessageFormat format = new MessageFormat("aaa{0}bbb{1,number}");
        
        // eXg{
        MessageFormat ret = map.put("key1", format);
        
        // 
        assertNull(ret);
        assertSame(format, map.get("key1"));
    }

    /**
     * testPut08()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"key1"<br>
     *         () value:MessageFormatCX^X<br>
     *                      tH[}bg:"aaa{0}bbb{1,date}"<br>
     *         () key1̃Gg[Ȃ
     *         () cloneReturnMap:key1̃Gg[Ȃ
     *         
     * <br>
     * ҒlF(߂l) null<br>
     *         (ԕω) Gg[[key1 : œnMessageFormat]
     *         (ԕω) cloneReturnMap:key1̃Gg[Ȃ
     *         
     * <br>
     * tH[}bgɓtnTutH[}bgw肵v[Xz_܂܂Av[Xz_킹ĕ݂ƂA
     * cloneReturnMapputAgɂputȂƂmFB<br>
     * get\bh̓삪OŁAgetقȂ铙ȃCX^XԂƂŁA
     *   put̊i[U蕪퓮삵ƔfB<br>
     * <br>
    * 
     * @throws Exception ̃\bhŔO
     */
    public void testPut08() throws Exception {
        // O
        MessageFormatCloneReturnIfUseDateFormatMap map = new MessageFormatCloneReturnIfUseDateFormatMap();
        MessageFormat format = new MessageFormat("aaa{0}bbb{1,date}");
        
        // eXg{
        MessageFormat ret = map.put("key1", format);
        
        // 
        assertNull(ret);
        assertNotSame(format, map.get("key1"));
        assertEquals(format, map.get("key1"));
    }

    /**
     * testPut09()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"key1"<br>
     *         () value:MessageFormatCX^X<br>
     *                      tH[}bg:"aaa"<br>
     *         () Gg[[key1 : MessageFormat]
     *         () cloneReturnMap:key1̃Gg[Ȃ
     *         
     * <br>
     * ҒlF(߂l) ƂƃGg[ɂMessageFormat<br>
     *         (ԕω) Gg[[key1 : œnMessageFormat]
     *         (ԕω) cloneReturnMap:key1̃Gg[Ȃ
     *         
     * <br>
     * put̖߂ldl(ȑOɃLbVĂlԂ)𖞂Ă邱ƂmFB<br>
     * tH[}bgɃv[Xz_݂ȂƂA
     * cloneReturnMapł͂ȂAgput(X[p[NX̋@\)ƂmFB<br>
     * get\bh̓삪OŁAgetCX^XԂƂŁA
     *   put̊i[U蕪퓮삵ƔfB<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testPut09() throws Exception {
        // O
        MessageFormatCloneReturnIfUseDateFormatMap map = new MessageFormatCloneReturnIfUseDateFormatMap();
        MessageFormat old = new MessageFormat("xxx");
        map.put("key1", old);
        MessageFormat format = new MessageFormat("aaa");
        
        // eXg{
        MessageFormat ret = map.put("key1", format);
        
        // 
        assertSame(old, ret);
        assertSame(format, map.get("key1"));
    }

    /**
     * testPut10()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"key1"<br>
     *         () value:MessageFormatCX^X<br>
     *                      tH[}bg:"aaa{0,date}"<br>
     *         () key1̃Gg[Ȃ
     *         () cloneReturnMap:Gg[[key1 : MessageFormat]
     *         
     * <br>
     * ҒlF(߂l) ƂƃGg[ɂMessageFormat<br>
     *         (ԕω) key1̃Gg[Ȃ
     *         (ԕω) cloneReturnMap:Gg[[key1 : œnMessageFormat]
     *         
     * <br>
     * put̖߂ldl(ȑOɃLbVĂlԂ)𖞂Ă邱ƂmFB<br>
     * tH[}bgɓtnTutH[}bgw肵v[Xz_݂݂̂ƂA
     * cloneReturnMapputAgɂputȂƂmFB<br>
     * get\bh̓삪OŁAgetقȂ铙ȃCX^XԂƂŁA
     *   put̊i[U蕪퓮삵ƔfB<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testPut10() throws Exception {
        // O
        MessageFormatCloneReturnIfUseDateFormatMap map = new MessageFormatCloneReturnIfUseDateFormatMap();
        MessageFormat old = new MessageFormat("xxx{0,date}");
        map.put("key1", old);
        MessageFormat format = new MessageFormat("aaa{0,date}");
        
        // eXg{
        MessageFormat ret = map.put("key1", format);
        
        // 
        assertEquals(old, ret);
        assertNotSame(format, map.get("key1"));
        assertEquals(format, map.get("key1"));
    }

}
