/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts;

import java.text.MessageFormat;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link MessageFormatCloneReturnMap} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Struts̃oO(STR-2172)pHashMap(MessageFormatLbV)B<br>
 * get̍ہAcloneĕԂBDecimalFormat#clone̖邽߁AputɂcloneB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.MessageFormatCloneReturnMap
 */
public class MessageFormatCloneReturnMapTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(MessageFormatCloneReturnMapTest.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public MessageFormatCloneReturnMapTest(String name) {
        super(name);
    }

    /**
     * testGet01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() "key1"
     *         () Gg[[key1 : MessageFormat]
     *         
     * <br>
     * ҒlF(߂l) Gg[ɂMessageFormatƓȕʃCX^X<br>
     *                  2ڎsɂ́A1ڂƓȕʃCX^X
     * <br>
     * Gg[ɑ݂̂́Acloneĕԋp邱ƂmFB<br>
     * putgetclone邽߁Aputgetł́AgetcloneĂȂĂfȂB<br>
     *   āAł́Aget2sāA1ڂ2ڂ̖߂lAȕʃCX^Xł邱ƂmF邱ƂŁA
     *   getcloneĂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGet01() {
        // O
        MessageFormatCloneReturnMap map = new MessageFormatCloneReturnMap();
        MessageFormat format = new MessageFormat("xxx");
        map.put("key1", format);
        
        // eXg{
        MessageFormat ret1 = map.get("key1");
        MessageFormat ret2 = map.get("key1");
        
        // 
        assertNotSame(format, ret1);
        assertEquals(format, ret1);
        assertNotSame(ret1, ret2);
        assertEquals(ret1, ret2);
    }

    /**
     * testGet02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() "key1"
     *         () key1̃Gg[Ȃ
     *         
     * <br>
     * ҒlF(߂l) null<br>
     *         
     * <br>
     * L[ɊYGg[݂ȂꍇAnullԋp邱ƂmFB<br>
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGet02() {
        // O
        MessageFormatCloneReturnMap map = new MessageFormatCloneReturnMap();
        
        // eXg{
        MessageFormat ret = map.get("key1");
        
        // 
        assertNull(ret);
    }

    /**
     * testPut01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"key1"
     *         () value:MessageFormat
     *         () key, valueCX^Xňxsς
     *         
     * <br>
     * ҒlF(߂l) valueœnMessageFormatƓȕʃCX^X<br>
     *         
     * <br>
     * putہAcloneăLbV邱ƂmFB<br>
     * putgetclone邽߁Aputget̂ł́AputcloneCX^XLbVĂȂĂfȂB<br>
     *   āAł́Aput̖߂l(߂lɂĂ͊gĂȂ)𗘗pA
     *   put̖߂lA炩߈valueɓnCX^XƂ͈قȂ铙ȃCX^Xł邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testPut01() {
        // O
        MessageFormatCloneReturnMap map = new MessageFormatCloneReturnMap();
        MessageFormat format = new MessageFormat("xxx");
        map.put("key1", format);
        
        // eXg{
        MessageFormat ret = map.put("key1", format);
        
        // 
        assertNotSame(format, ret);
        assertEquals(format, ret);
    }
}
