/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.IOException;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.web.struts.action.ActionMappingEx;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import junit.framework.TestCase;

import org.apache.struts.action.ActionForward;

/**
 * {@link jp.terasoluna.fw.web.struts.actions.LogoffAction}
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * JSPȂǂփtH[hANV
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.actions.LogoffAction
 */
public class LogoffActionTest extends TestCase {

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LogUTUtil.flush();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public LogoffActionTest(String name) {
        super(name);
    }

    /**
     * testDoExecute01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () session:null<br>
     *         () path:null<br>
     *         
     * <br>
     * ҒlF(߂l) actionForward:null<br>
     *         (ԕω) res.sendError():ĂяomF<br>
     *         
     * <br>
     * mappingp[^̎擾ʂnullłA
     * HttpServletResponse.sendError()ĂяoꂽꍇAnullԂƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute01() throws Exception {
        // O
        LogoffAction action = new LogoffAction();
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        
        // path : null
        String path = null;
        mapping.setParameter(path);
        
        LogoffAction_ActionFormStub01 form =
            new LogoffAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        
        // sendErrořĂяomFp
        LogoffAction_HttpServletResponseStub01 res =
            new LogoffAction_HttpServletResponseStub01();
        
        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);

        // 
        assertNull(forward);
        assertTrue(res.isSendError);
    }

    /**
     * testDoExecute02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () session:null<br>
     *         () path:null<br>
     *         () res.sendError():IOException<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"error.forward.errorpage"<br>
     *                    bvOFIOException<br>
     *         (ԕω) O:O<br>
     *                    G[OF"Error page(404) forwarding failed."<br>
     *         
     * <br>
     * mappingp[^̎擾ʂnullłA
     * HttpServletResponse.sendError()ďoŗOꍇA
     * SystemException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute02() throws Exception {
        // O
        LogoffAction action = new LogoffAction();
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        
        // path : null
        String path = null;
        mapping.setParameter(path);
        
        LogoffAction_ActionFormStub01 form =
            new LogoffAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        
        // sendErrořĂяomFp
        LogoffAction_HttpServletResponseStub02 res =
            new LogoffAction_HttpServletResponseStub02();
        
        @SuppressWarnings("unused") ActionForward forward = null;

        // eXg{
        try {
            forward = action.doExecute(mapping, form, req, res);
            fail("O܂ł");
        } catch (SystemException e) {
            // 
            // IOExceptionbv
            assertEquals(e.getCause().getClass().getName(),
                    IOException.class.getName());
            // G[OmF
            assertTrue(LogUTUtil.checkError(
                    "Error page(404) forwarding failed."));
            assertEquals("error.forward.errorpage", e.getErrorCode());
        }
    }

    /**
     * testDoExecute03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () session:null<br>
     *         () path:"abc"<br>
     *         
     * <br>
     * ҒlF(߂l) actionForward:ActionForward.getPath()F"abc"<br>
     *         
     * <br>
     * mappingp[^̎擾ʂnot null̏ꍇA
     * ActionForwardpathw肵pathƈv邩mFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute03() throws Exception {
        // O
        LogoffAction action = new LogoffAction();
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        
        // path : "abc"
        String path = "abc";
        mapping.setParameter(path);
        
        LogoffAction_ActionFormStub01 form =
            new LogoffAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        
        // sendErrořĂяomFp
        LogoffAction_HttpServletResponseStub01 res =
            new LogoffAction_HttpServletResponseStub01();
        
        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);

        // 
        assertEquals("abc", forward.getPath());
    }

    /**
     * testDoExecute04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () session:not null<br>
     *         () path:"abc"<br>
     *         
     * <br>
     * ҒlF(߂l) actionForward:ActionForward.getPath()F"abc"<br>
     *         (ԕω) session.invalidate():ĂяomF<br>
     *         
     * <br>
     * req擾sessionnot null̏ꍇA
     * session.invalidate()ĂяoꂽmFB
     * ActionForwardpathw肵pathƈv邩mFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute04() throws Exception {
        // O
        LogoffAction action = new LogoffAction();
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        
        // path : "abc"
        String path = "abc";
        mapping.setParameter(path);
        
        LogoffAction_ActionFormStub01 form =
            new LogoffAction_ActionFormStub01();
        
        // LogoffAction_HttpSessionStub01擾X^u
        LogoffAction_HttpServletRequestStub01 req =
            new LogoffAction_HttpServletRequestStub01();
        
        // sendErrořĂяomFp
        LogoffAction_HttpServletResponseStub01 res =
            new LogoffAction_HttpServletResponseStub01();
        
        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);

        // 
        LogoffAction_HttpSessionStub01 session =
            (LogoffAction_HttpSessionStub01) req.getSession(false); 
        assertEquals("abc", forward.getPath());
        assertTrue(session.isInvalidate);
    }

}
